% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesisanalyticsv2_operations.R
\name{kinesisanalyticsv2_update_application}
\alias{kinesisanalyticsv2_update_application}
\title{Updates an existing Kinesis Data Analytics application}
\usage{
kinesisanalyticsv2_update_application(
  ApplicationName,
  CurrentApplicationVersionId = NULL,
  ApplicationConfigurationUpdate = NULL,
  ServiceExecutionRoleUpdate = NULL,
  RunConfigurationUpdate = NULL,
  CloudWatchLoggingOptionUpdates = NULL,
  ConditionalToken = NULL
)
}
\arguments{
\item{ApplicationName}{[required] The name of the application to update.}

\item{CurrentApplicationVersionId}{The current application version ID. You must provide the
\code{CurrentApplicationVersionId} or the \code{ConditionalToken}.You can retrieve
the application version ID using
\code{\link[=kinesisanalyticsv2_describe_application]{describe_application}}. For
better concurrency support, use the \code{ConditionalToken} parameter instead
of \code{CurrentApplicationVersionId}.}

\item{ApplicationConfigurationUpdate}{Describes application configuration updates.}

\item{ServiceExecutionRoleUpdate}{Describes updates to the service execution role.}

\item{RunConfigurationUpdate}{Describes updates to the application's starting parameters.}

\item{CloudWatchLoggingOptionUpdates}{Describes application Amazon CloudWatch logging option updates. You can
only update existing CloudWatch logging options with this action. To add
a new CloudWatch logging option, use
\code{\link[=kinesisanalyticsv2_add_application_cloud_watch_logging_option]{add_application_cloud_watch_logging_option}}.}

\item{ConditionalToken}{A value you use to implement strong concurrency for application updates.
You must provide the \code{CurrentApplicationVersionId} or the
\code{ConditionalToken}. You get the application's current \code{ConditionalToken}
using \code{\link[=kinesisanalyticsv2_describe_application]{describe_application}}.
For better concurrency support, use the \code{ConditionalToken} parameter
instead of \code{CurrentApplicationVersionId}.}
}
\description{
Updates an existing Kinesis Data Analytics application. Using this operation, you can update application code, input configuration, and output configuration.

See \url{https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_update_application/} for full documentation.
}
\keyword{internal}
