% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entityresolution_operations.R
\name{entityresolution_create_schema_mapping}
\alias{entityresolution_create_schema_mapping}
\title{Creates a schema mapping, which defines the schema of the input customer
records table}
\usage{
entityresolution_create_schema_mapping(
  description = NULL,
  mappedInputFields,
  schemaName,
  tags = NULL
)
}
\arguments{
\item{description}{A description of the schema.}

\item{mappedInputFields}{[required] A list of \code{MappedInputFields}. Each \code{MappedInputField} corresponds to a
column the source data table, and contains column name plus additional
information that Entity Resolution uses for matching.}

\item{schemaName}{[required] The name of the schema. There can't be multiple \code{SchemaMappings} with
the same name.}

\item{tags}{The tags used to organize, track, or control access for this resource.}
}
\description{
Creates a schema mapping, which defines the schema of the input customer records table. The \code{SchemaMapping} also provides Entity Resolution with some metadata about the table, such as the attribute types of the columns and which columns to match on.

See \url{https://www.paws-r-sdk.com/docs/entityresolution_create_schema_mapping/} for full documentation.
}
\keyword{internal}
