% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sns_operations.R
\name{sns_set_topic_attributes}
\alias{sns_set_topic_attributes}
\title{Allows a topic owner to set an attribute of the topic to a new value}
\usage{
sns_set_topic_attributes(TopicArn, AttributeName, AttributeValue)
}
\arguments{
\item{TopicArn}{[required] The ARN of the topic to modify.}

\item{AttributeName}{[required] A map of attributes with their corresponding values.

The following lists the names, descriptions, and values of the special
request parameters that the \code{SetTopicAttributes} action uses:
\itemize{
\item \code{DeliveryPolicy} -- The policy that defines how Amazon SNS retries
failed deliveries to HTTP/S endpoints.
\item \code{DisplayName} -- The display name to use for a topic with SMS
subscriptions.
\item \code{Policy} -- The policy that defines who can access your topic. By
default, only the topic owner can publish or subscribe to the topic.
}}

\item{AttributeValue}{The new value for the attribute.}
}
\description{
Allows a topic owner to set an attribute of the topic to a new value.
}
\section{Request syntax}{
\preformatted{svc$set_topic_attributes(
  TopicArn = "string",
  AttributeName = "string",
  AttributeValue = "string"
)
}
}

\keyword{internal}
