% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eks_operations.R
\name{eks_update_cluster_config}
\alias{eks_update_cluster_config}
\title{Updates an Amazon EKS cluster configuration}
\usage{
eks_update_cluster_config(name, resourcesVpcConfig, clientRequestToken)
}
\arguments{
\item{name}{[required] The name of the Amazon EKS cluster to update.}

\item{resourcesVpcConfig}{}

\item{clientRequestToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request.}
}
\description{
Updates an Amazon EKS cluster configuration. Your cluster continues to
function during the update. The response output includes an update ID
that you can use to track the status of your cluster update with the
DescribeUpdate API operation.
}
\details{
Currently, the only cluster configuration changes supported are to
enable or disable Amazon EKS public and private API server endpoints.
For more information, see \href{https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html}{Amazon EKS Cluster Endpoint Access Control}
in the \strong{Amazon EKS User Guide} .

Cluster updates are asynchronous, and they should finish within a few
minutes. During an update, the cluster status moves to \code{UPDATING} (this
status transition is eventually consistent). When the update is complete
(either \code{Failed} or \code{Successful}), the cluster status moves to \code{Active}.
}
\section{Request syntax}{
\preformatted{svc$update_cluster_config(
  name = "string",
  resourcesVpcConfig = list(
    subnetIds = list(
      "string"
    ),
    securityGroupIds = list(
      "string"
    ),
    endpointPublicAccess = TRUE|FALSE,
    endpointPrivateAccess = TRUE|FALSE
  ),
  clientRequestToken = "string"
)
}
}

\keyword{internal}
