% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_vpn_gateway}
\alias{ec2_create_vpn_gateway}
\title{Creates a virtual private gateway}
\usage{
ec2_create_vpn_gateway(AvailabilityZone, Type, TagSpecifications,
  AmazonSideAsn, DryRun)
}
\arguments{
\item{AvailabilityZone}{The Availability Zone for the virtual private gateway.}

\item{Type}{[required] The type of VPN connection this virtual private gateway supports.}

\item{TagSpecifications}{The tags to apply to the virtual private gateway.}

\item{AmazonSideAsn}{A private Autonomous System Number (ASN) for the Amazon side of a BGP
session. If you're using a 16-bit ASN, it must be in the 64512 to 65534
range. If you're using a 32-bit ASN, it must be in the 4200000000 to
4294967294 range.

Default: 64512}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Creates a virtual private gateway. A virtual private gateway is the
endpoint on the VPC side of your VPN connection. You can create a
virtual private gateway before creating the VPC itself.

For more information, see \href{https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html}{AWS Site-to-Site VPN} in the
\emph{AWS Site-to-Site VPN User Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_vpn_gateway(
  AvailabilityZone = "string",
  Type = "ipsec.1",
  TagSpecifications = list(
    list(
      ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      )
    )
  ),
  AmazonSideAsn = 123,
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
