% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_disable_transit_gateway_route_table_propagation}
\alias{ec2_disable_transit_gateway_route_table_propagation}
\title{Disables the specified resource attachment from propagating routes to
the specified propagation route table}
\usage{
ec2_disable_transit_gateway_route_table_propagation(
  TransitGatewayRouteTableId, TransitGatewayAttachmentId, DryRun)
}
\arguments{
\item{TransitGatewayRouteTableId}{[required] The ID of the propagation route table.}

\item{TransitGatewayAttachmentId}{[required] The ID of the attachment.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\value{
A list with the following syntax:\preformatted{list(
  Propagation = list(
    TransitGatewayAttachmentId = "string",
    ResourceId = "string",
    ResourceType = "vpc"|"vpn"|"direct-connect-gateway"|"connect"|"peering"|"tgw-peering",
    TransitGatewayRouteTableId = "string",
    State = "enabling"|"enabled"|"disabling"|"disabled"
  )
)
}
}
\description{
Disables the specified resource attachment from propagating routes to
the specified propagation route table.
}
\section{Request syntax}{
\preformatted{svc$disable_transit_gateway_route_table_propagation(
  TransitGatewayRouteTableId = "string",
  TransitGatewayAttachmentId = "string",
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
