% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_security_group}
\alias{ec2_create_security_group}
\title{Creates a security group}
\usage{
ec2_create_security_group(Description, GroupName, VpcId, DryRun)
}
\arguments{
\item{Description}{[required] A description for the security group. This is informational only.

Constraints: Up to 255 characters in length

Constraints for EC2-Classic: ASCII characters

Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and
.\\_-:/()\\#,@[]+=&;\{\}!\\$*}

\item{GroupName}{[required] The name of the security group.

Constraints: Up to 255 characters in length. Cannot start with \verb{sg-}.

Constraints for EC2-Classic: ASCII characters

Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and
.\\_-:/()\\#,@[]+=&;\{\}!\\$*}

\item{VpcId}{[EC2-VPC] The ID of the VPC. Required for EC2-VPC.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Creates a security group.
}
\details{
A security group acts as a virtual firewall for your instance to control
inbound and outbound traffic. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html}{Amazon EC2 Security Groups}
in the \emph{Amazon Elastic Compute Cloud User Guide} and \href{https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html}{Security Groups for Your VPC}
in the \emph{Amazon Virtual Private Cloud User Guide}.

When you create a security group, you specify a friendly name of your
choice. You can have a security group for use in EC2-Classic with the
same name as a security group for use in a VPC. However, you can\'t have
two security groups for use in EC2-Classic with the same name or two
security groups for use in a VPC with the same name.

You have a default security group for use in EC2-Classic and a default
security group for use in your VPC. If you don\'t specify a security
group when you launch an instance, the instance is launched into the
appropriate default security group. A default security group includes a
default rule that grants instances unrestricted network access to each
other.

You can add or remove rules from your security groups using
AuthorizeSecurityGroupIngress, AuthorizeSecurityGroupEgress,
RevokeSecurityGroupIngress, and RevokeSecurityGroupEgress.

For more information about VPC security group limits, see \href{https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html}{Amazon VPC Limits}.
}
\section{Request syntax}{
\preformatted{svc$create_security_group(
  Description = "string",
  GroupName = "string",
  VpcId = "string",
  DryRun = TRUE|FALSE
)
}
}

\examples{
# This example creates a security group for the specified VPC.
\dontrun{svc$create_security_group(
  Description = "My security group",
  GroupName = "my-security-group",
  VpcId = "vpc-1a2b3c4d"
)}

}
\keyword{internal}
