% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_describe_clusters}
\alias{ecs_describe_clusters}
\title{Describes one or more of your clusters}
\usage{
ecs_describe_clusters(clusters, include)
}
\arguments{
\item{clusters}{A list of up to 100 cluster names or full cluster Amazon Resource Name
(ARN) entries. If you do not specify a cluster, the default cluster is
assumed.}

\item{include}{Whether to include additional information about your clusters in the
response. If this field is omitted, the attachments, statistics, and
tags are not included.

If \code{ATTACHMENTS} is specified, the attachments for the container
instances or tasks within the cluster are included.

If \code{SETTINGS} is specified, the settings for the cluster are included.

If \code{STATISTICS} is specified, the following additional information,
separated by launch type, is included:
\itemize{
\item runningEC2TasksCount
\item runningFargateTasksCount
\item pendingEC2TasksCount
\item pendingFargateTasksCount
\item activeEC2ServiceCount
\item activeFargateServiceCount
\item drainingEC2ServiceCount
\item drainingFargateServiceCount
}

If \code{TAGS} is specified, the metadata tags associated with the cluster
are included.}
}
\description{
Describes one or more of your clusters.
}
\section{Request syntax}{
\preformatted{svc$describe_clusters(
  clusters = list(
    "string"
  ),
  include = list(
    "ATTACHMENTS"|"SETTINGS"|"STATISTICS"|"TAGS"
  )
)
}
}

\examples{
\dontrun{
# This example provides a description of the specified cluster in your
# default region.
svc$describe_clusters(
  clusters = list(
    "default"
  )
)
}

}
\keyword{internal}
