% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_get_relational_database_parameters}
\alias{lightsail_get_relational_database_parameters}
\title{Returns all of the runtime parameters offered by the underlying database
software, or engine, for a specific database in Amazon Lightsail}
\usage{
lightsail_get_relational_database_parameters(relationalDatabaseName,
  pageToken)
}
\arguments{
\item{relationalDatabaseName}{[required] The name of your database for which to get parameters.}

\item{pageToken}{The token to advance to the next page of results from your request.

To get a page token, perform an initial
\code{GetRelationalDatabaseParameters} request. If your results are
paginated, the response will return a next page token that you can
specify as the page token in a subsequent request.}
}
\description{
Returns all of the runtime parameters offered by the underlying database
software, or engine, for a specific database in Amazon Lightsail.
}
\details{
In addition to the parameter names and values, this operation returns
other information about each parameter. This information includes
whether changes require a reboot, whether the parameter is modifiable,
the allowed values, and the data types.
}
\section{Request syntax}{
\preformatted{svc$get_relational_database_parameters(
  relationalDatabaseName = "string",
  pageToken = "string"
)
}
}

\keyword{internal}
