% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apprunner_service.R
\name{apprunner}
\alias{apprunner}
\title{AWS App Runner}
\usage{
apprunner(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e., \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
}}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
App Runner

App Runner is an application service that provides a fast, simple, and
cost-effective way to go directly from an existing container image or
source code to a running service in the Amazon Web Services Cloud in
seconds. You don't need to learn new technologies, decide which compute
service to use, or understand how to provision and configure Amazon Web
Services resources.

App Runner connects directly to your container registry or source code
repository. It provides an automatic delivery pipeline with fully
managed operations, high performance, scalability, and security.

For more information about App Runner, see the \href{https://docs.aws.amazon.com/apprunner/latest/dg/}{App Runner Developer Guide}. For release
information, see the \href{https://docs.aws.amazon.com/apprunner/latest/relnotes/}{App Runner Release Notes}.

To install the Software Development Kits (SDKs), Integrated Development
Environment (IDE) Toolkits, and command line tools that you can use to
access the API, see \href{https://aws.amazon.com/developer/tools/}{Tools for Amazon Web Services}.

\strong{Endpoints}

For a list of Region-specific endpoints that App Runner supports, see
\href{https://docs.aws.amazon.com/general/latest/gr/apprunner.html}{App Runner endpoints and quotas} in
the \emph{Amazon Web Services General Reference}.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- apprunner(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical"
  )
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[=apprunner_associate_custom_domain]{associate_custom_domain} \tab Associate your own domain name with the App Runner subdomain URL of your App Runner service\cr
\link[=apprunner_create_auto_scaling_configuration]{create_auto_scaling_configuration} \tab Create an App Runner automatic scaling configuration resource\cr
\link[=apprunner_create_connection]{create_connection} \tab Create an App Runner connection resource\cr
\link[=apprunner_create_observability_configuration]{create_observability_configuration} \tab Create an App Runner observability configuration resource\cr
\link[=apprunner_create_service]{create_service} \tab Create an App Runner service\cr
\link[=apprunner_create_vpc_connector]{create_vpc_connector} \tab Create an App Runner VPC connector resource\cr
\link[=apprunner_delete_auto_scaling_configuration]{delete_auto_scaling_configuration} \tab Delete an App Runner automatic scaling configuration resource\cr
\link[=apprunner_delete_connection]{delete_connection} \tab Delete an App Runner connection\cr
\link[=apprunner_delete_observability_configuration]{delete_observability_configuration} \tab Delete an App Runner observability configuration resource\cr
\link[=apprunner_delete_service]{delete_service} \tab Delete an App Runner service\cr
\link[=apprunner_delete_vpc_connector]{delete_vpc_connector} \tab Delete an App Runner VPC connector resource\cr
\link[=apprunner_describe_auto_scaling_configuration]{describe_auto_scaling_configuration} \tab Return a full description of an App Runner automatic scaling configuration resource\cr
\link[=apprunner_describe_custom_domains]{describe_custom_domains} \tab Return a description of custom domain names that are associated with an App Runner service\cr
\link[=apprunner_describe_observability_configuration]{describe_observability_configuration} \tab Return a full description of an App Runner observability configuration resource\cr
\link[=apprunner_describe_service]{describe_service} \tab Return a full description of an App Runner service\cr
\link[=apprunner_describe_vpc_connector]{describe_vpc_connector} \tab Return a description of an App Runner VPC connector resource\cr
\link[=apprunner_disassociate_custom_domain]{disassociate_custom_domain} \tab Disassociate a custom domain name from an App Runner service\cr
\link[=apprunner_list_auto_scaling_configurations]{list_auto_scaling_configurations} \tab Returns a list of active App Runner automatic scaling configurations in your Amazon Web Services account\cr
\link[=apprunner_list_connections]{list_connections} \tab Returns a list of App Runner connections that are associated with your Amazon Web Services account\cr
\link[=apprunner_list_observability_configurations]{list_observability_configurations} \tab Returns a list of active App Runner observability configurations in your Amazon Web Services account\cr
\link[=apprunner_list_operations]{list_operations} \tab Return a list of operations that occurred on an App Runner service\cr
\link[=apprunner_list_services]{list_services} \tab Returns a list of running App Runner services in your Amazon Web Services account\cr
\link[=apprunner_list_tags_for_resource]{list_tags_for_resource} \tab List tags that are associated with for an App Runner resource\cr
\link[=apprunner_list_vpc_connectors]{list_vpc_connectors} \tab Returns a list of App Runner VPC connectors in your Amazon Web Services account\cr
\link[=apprunner_pause_service]{pause_service} \tab Pause an active App Runner service\cr
\link[=apprunner_resume_service]{resume_service} \tab Resume an active App Runner service\cr
\link[=apprunner_start_deployment]{start_deployment} \tab Initiate a manual deployment of the latest commit in a source code repository or the latest image in a source image repository to an App Runner service\cr
\link[=apprunner_tag_resource]{tag_resource} \tab Add tags to, or update the tag values of, an App Runner resource\cr
\link[=apprunner_untag_resource]{untag_resource} \tab Remove tags from an App Runner resource\cr
\link[=apprunner_update_service]{update_service} \tab Update an App Runner service
}
}

\examples{
\dontrun{
svc <- apprunner()
svc$associate_custom_domain(
  Foo = 123
)
}

}
