% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_capacity_reservation_fleet}
\alias{ec2_create_capacity_reservation_fleet}
\title{Creates a Capacity Reservation Fleet}
\usage{
ec2_create_capacity_reservation_fleet(
  AllocationStrategy = NULL,
  ClientToken = NULL,
  InstanceTypeSpecifications,
  Tenancy = NULL,
  TotalTargetCapacity,
  EndDate = NULL,
  InstanceMatchCriteria = NULL,
  TagSpecifications = NULL,
  DryRun = NULL
)
}
\arguments{
\item{AllocationStrategy}{The strategy used by the Capacity Reservation Fleet to determine which
of the specified instance types to use. Currently, only the
\code{prioritized} allocation strategy is supported. For more information,
see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#allocation-strategy}{Allocation strategy}
in the Amazon EC2 User Guide.

Valid values: \code{prioritized}}

\item{ClientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{Ensure Idempotency}.}

\item{InstanceTypeSpecifications}{[required] Information about the instance types for which to reserve the capacity.}

\item{Tenancy}{Indicates the tenancy of the Capacity Reservation Fleet. All Capacity
Reservations in the Fleet inherit this tenancy. The Capacity Reservation
Fleet can have one of the following tenancy settings:
\itemize{
\item \code{default} - The Capacity Reservation Fleet is created on hardware
that is shared with other Amazon Web Services accounts.
\item \code{dedicated} - The Capacity Reservations are created on single-tenant
hardware that is dedicated to a single Amazon Web Services account.
}}

\item{TotalTargetCapacity}{[required] The total number of capacity units to be reserved by the Capacity
Reservation Fleet. This value, together with the instance type weights
that you assign to each instance type used by the Fleet determine the
number of instances for which the Fleet reserves capacity. Both values
are based on units that make sense for your workload. For more
information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity}{Total target capacity}
in the Amazon EC2 User Guide.}

\item{EndDate}{The date and time at which the Capacity Reservation Fleet expires. When
the Capacity Reservation Fleet expires, its state changes to \code{expired}
and all of the Capacity Reservations in the Fleet expire.

The Capacity Reservation Fleet expires within an hour after the
specified time. For example, if you specify \code{5/31/2019}, \code{13:30:55}, the
Capacity Reservation Fleet is guaranteed to expire between \code{13:30:55}
and \code{14:30:55} on \code{5/31/2019}.}

\item{InstanceMatchCriteria}{Indicates the type of instance launches that the Capacity Reservation
Fleet accepts. All Capacity Reservations in the Fleet inherit this
instance matching criteria.

Currently, Capacity Reservation Fleets support \code{open} instance matching
criteria only. This means that instances that have matching attributes
(instance type, platform, and Availability Zone) run in the Capacity
Reservations automatically. Instances do not need to explicitly target a
Capacity Reservation Fleet to use its reserved capacity.}

\item{TagSpecifications}{The tags to assign to the Capacity Reservation Fleet. The tags are
automatically assigned to the Capacity Reservations in the Fleet.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Creates a Capacity Reservation Fleet. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/work-with-cr-fleets.html#create-crfleet}{Create a Capacity Reservation Fleet} in the Amazon EC2 User Guide.

See \url{https://paws-r.github.io/docs/ec2/create_capacity_reservation_fleet.html} for full documentation.
}
\keyword{internal}
