% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_default_vpc}
\alias{ec2_create_default_vpc}
\title{Creates a default VPC with a size /16 IPv4 CIDR block and a default
subnet in each Availability Zone}
\usage{
ec2_create_default_vpc(DryRun = NULL)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Creates a default VPC with a size \verb{/16} IPv4 CIDR block and a default subnet in each Availability Zone. For more information about the components of a default VPC, see \href{https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html}{Default VPC and default subnets} in the \emph{Amazon Virtual Private Cloud User Guide}. You cannot specify the components of the default VPC yourself.

See \url{https://paws-r.github.io/docs/ec2/create_default_vpc.html} for full documentation.
}
\keyword{internal}
