% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_snapshots}
\alias{ec2_create_snapshots}
\title{Creates crash-consistent snapshots of multiple EBS volumes and stores
the data in S3}
\usage{
ec2_create_snapshots(
  Description = NULL,
  InstanceSpecification,
  OutpostArn = NULL,
  TagSpecifications = NULL,
  DryRun = NULL,
  CopyTagsFromSource = NULL
)
}
\arguments{
\item{Description}{A description propagated to every snapshot specified by the instance.}

\item{InstanceSpecification}{[required] The instance to specify which volumes should be included in the
snapshots.}

\item{OutpostArn}{The Amazon Resource Name (ARN) of the Outpost on which to create the
local snapshots.
\itemize{
\item To create snapshots from an instance in a Region, omit this
parameter. The snapshots are created in the same Region as the
instance.
\item To create snapshots from an instance on an Outpost and store the
snapshots in the Region, omit this parameter. The snapshots are
created in the Region for the Outpost.
\item To create snapshots from an instance on an Outpost and store the
snapshots on an Outpost, specify the ARN of the destination Outpost.
The snapshots must be created on the same Outpost as the instance.
}

For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#create-multivol-snapshot}{Create multi-volume local snapshots from instances on an Outpost}
in the \emph{Amazon Elastic Compute Cloud User Guide}.}

\item{TagSpecifications}{Tags to apply to every snapshot specified by the instance.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{CopyTagsFromSource}{Copies the tags from the specified volume to corresponding snapshot.}
}
\description{
Creates crash-consistent snapshots of multiple EBS volumes and stores the data in S3. Volumes are chosen by specifying an instance. Any attached volumes will produce one snapshot each that is crash-consistent across the instance. Boot volumes can be excluded by changing the parameters.

See \url{https://paws-r.github.io/docs/ec2/create_snapshots.html} for full documentation.
}
\keyword{internal}
