% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_replace_root_volume_tasks}
\alias{ec2_describe_replace_root_volume_tasks}
\title{Describes a root volume replacement task}
\usage{
ec2_describe_replace_root_volume_tasks(
  ReplaceRootVolumeTaskIds = NULL,
  Filters = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  DryRun = NULL
)
}
\arguments{
\item{ReplaceRootVolumeTaskIds}{The ID of the root volume replacement task to view.}

\item{Filters}{Filter to use:
\itemize{
\item \code{instance-id} - The ID of the instance for which the root volume
replacement task was created.
}}

\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}

\item{NextToken}{The token for the next page of results.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Describes a root volume replacement task. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-restoring-volume.html#replace-root}{Replace a root volume} in the \emph{Amazon Elastic Compute Cloud User Guide}.

See \url{https://paws-r.github.io/docs/ec2/describe_replace_root_volume_tasks.html} for full documentation.
}
\keyword{internal}
