% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_store_image_tasks}
\alias{ec2_describe_store_image_tasks}
\title{Describes the progress of the AMI store tasks}
\usage{
ec2_describe_store_image_tasks(
  ImageIds = NULL,
  DryRun = NULL,
  Filters = NULL,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{ImageIds}{The AMI IDs for which to show progress. Up to 20 AMI IDs can be included
in a request.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{Filters}{The filters.
\itemize{
\item \code{task-state} - Returns tasks in a certain state (\code{InProgress} |
\code{Completed} | \code{Failed})
\item \code{bucket} - Returns task information for tasks that targeted a
specific bucket. For the filter value, specify the bucket name.
}}

\item{NextToken}{The token for the next page of results.}

\item{MaxResults}{The maximum number of results to return in a single call. To retrieve
the remaining results, make another call with the returned \code{NextToken}
value. This value can be between 1 and 200. You cannot specify this
parameter and the \code{ImageIDs} parameter in the same call.}
}
\description{
Describes the progress of the AMI store tasks. You can describe the store tasks for specified AMIs. If you don't specify the AMIs, you get a paginated list of store tasks from the last 31 days.

See \url{https://paws-r.github.io/docs/ec2/describe_store_image_tasks.html} for full documentation.
}
\keyword{internal}
