% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_revoke_security_group_egress}
\alias{ec2_revoke_security_group_egress}
\title{[VPC only] Removes the specified outbound (egress) rules from a
security group for EC2-VPC}
\usage{
ec2_revoke_security_group_egress(
  DryRun = NULL,
  GroupId,
  IpPermissions = NULL,
  SecurityGroupRuleIds = NULL,
  CidrIp = NULL,
  FromPort = NULL,
  IpProtocol = NULL,
  ToPort = NULL,
  SourceSecurityGroupName = NULL,
  SourceSecurityGroupOwnerId = NULL
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{GroupId}{[required] The ID of the security group.}

\item{IpPermissions}{The sets of IP permissions. You can't specify a destination security
group and a CIDR IP address range in the same set of permissions.}

\item{SecurityGroupRuleIds}{The IDs of the security group rules.}

\item{CidrIp}{Not supported. Use a set of IP permissions to specify the CIDR.}

\item{FromPort}{Not supported. Use a set of IP permissions to specify the port.}

\item{IpProtocol}{Not supported. Use a set of IP permissions to specify the protocol name
or number.}

\item{ToPort}{Not supported. Use a set of IP permissions to specify the port.}

\item{SourceSecurityGroupName}{Not supported. Use a set of IP permissions to specify a destination
security group.}

\item{SourceSecurityGroupOwnerId}{Not supported. Use a set of IP permissions to specify a destination
security group.}
}
\description{
[VPC only] Removes the specified outbound (egress) rules from a security group for EC2-VPC. This action does not apply to security groups for use in EC2-Classic.

See \url{https://paws-r.github.io/docs/ec2/revoke_security_group_egress.html} for full documentation.
}
\keyword{internal}
