% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_put_account_setting}
\alias{ecs_put_account_setting}
\title{Modifies an account setting}
\usage{
ecs_put_account_setting(name, value, principalArn = NULL)
}
\arguments{
\item{name}{[required] The Amazon ECS resource name for which to modify the account setting. If
\code{serviceLongArnFormat} is specified, the ARN for your Amazon ECS
services is affected. If \code{taskLongArnFormat} is specified, the ARN and
resource ID for your Amazon ECS tasks is affected. If
\code{containerInstanceLongArnFormat} is specified, the ARN and resource ID
for your Amazon ECS container instances is affected. If \code{awsvpcTrunking}
is specified, the elastic network interface (ENI) limit for your Amazon
ECS container instances is affected. If \code{containerInsights} is
specified, the default setting for CloudWatch Container Insights for
your clusters is affected.}

\item{value}{[required] The account setting value for the specified principal ARN. Accepted
values are \code{enabled} and \code{disabled}.}

\item{principalArn}{The ARN of the principal, which can be an IAM user, IAM role, or the
root user. If you specify the root user, it modifies the account setting
for all IAM users, IAM roles, and the root user of the account unless an
IAM user or role explicitly overrides these settings. If this field is
omitted, the setting is changed only for the authenticated user.

Federated users assume the account setting of the root user and can't
have explicit account settings set for them.}
}
\description{
Modifies an account setting. Account settings are set on a per-Region basis.

See \url{https://paws-r.github.io/docs/ecs/put_account_setting.html} for full documentation.
}
\keyword{internal}
