% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_attach_network_interface}
\alias{ec2_attach_network_interface}
\title{Attaches a network interface to an instance}
\usage{
ec2_attach_network_interface(
  DeviceIndex,
  DryRun = NULL,
  InstanceId,
  NetworkInterfaceId,
  NetworkCardIndex = NULL,
  EnaSrdSpecification = NULL
)
}
\arguments{
\item{DeviceIndex}{[required] The index of the device for the network interface attachment.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{InstanceId}{[required] The ID of the instance.}

\item{NetworkInterfaceId}{[required] The ID of the network interface.}

\item{NetworkCardIndex}{The index of the network card. Some instance types support multiple
network cards. The primary network interface must be assigned to network
card index 0. The default is network card index 0.}

\item{EnaSrdSpecification}{Configures ENA Express for the network interface that this action
attaches to the instance.}
}
\description{
Attaches a network interface to an instance.

See \url{https://www.paws-r-sdk.com/docs/ec2_attach_network_interface/} for full documentation.
}
\keyword{internal}
