% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_move_byoip_cidr_to_ipam}
\alias{ec2_move_byoip_cidr_to_ipam}
\title{Move a BYOIPv4 CIDR to IPAM from a public IPv4 pool}
\usage{
ec2_move_byoip_cidr_to_ipam(DryRun = NULL, Cidr, IpamPoolId, IpamPoolOwner)
}
\arguments{
\item{DryRun}{A check for whether you have the required permissions for the action
without actually making the request and provides an error response. If
you have the required permissions, the error response is
\code{DryRunOperation}. Otherwise, it is \code{UnauthorizedOperation}.}

\item{Cidr}{[required] The BYOIP CIDR.}

\item{IpamPoolId}{[required] The IPAM pool ID.}

\item{IpamPoolOwner}{[required] The Amazon Web Services account ID of the owner of the IPAM pool.}
}
\description{
Move a BYOIPv4 CIDR to IPAM from a public IPv4 pool.

See \url{https://www.paws-r-sdk.com/docs/ec2_move_byoip_cidr_to_ipam/} for full documentation.
}
\keyword{internal}
