% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pricing_operations.R
\name{pricing_describe_services}
\alias{pricing_describe_services}
\title{Returns the metadata for one service or a list of the metadata for all
services}
\usage{
pricing_describe_services(ServiceCode, FormatVersion, NextToken,
  MaxResults)
}
\arguments{
\item{ServiceCode}{The code for the service whose information you want to retrieve, such as
\code{AmazonEC2}. You can use the \code{ServiceCode} to filter the results in a
\code{GetProducts} call. To retrieve a list of all services, leave this
blank.}

\item{FormatVersion}{The format version that you want the response to be in.

Valid values are: \code{aws_v1}}

\item{NextToken}{The pagination token that indicates the next set of results that you
want to retrieve.}

\item{MaxResults}{The maximum number of results that you want returned in the response.}
}
\description{
Returns the metadata for one service or a list of the metadata for all
services. Use this without a service code to get the service codes for
all services. Use it with a service code, such as \code{AmazonEC2}, to get
information specific to that service, such as the attribute names
available for that service. For example, some of the attribute names
available for EC2 are \code{volumeType}, \code{maxIopsVolume}, \code{operation},
\code{locationType}, and \code{instanceCapacity10xlarge}.
}
\section{Request syntax}{
\preformatted{svc$describe_services(
  ServiceCode = "string",
  FormatVersion = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\examples{
#
\dontrun{svc$describe_services(
  FormatVersion = "aws_v1",
  MaxResults = 1L,
  ServiceCode = "AmazonEC2"
)}

}
\keyword{internal}
