% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/budgets_service.R
\name{budgets}
\alias{budgets}
\title{AWS Budgets}
\usage{
budgets(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.}
}
\description{
The AWS Budgets API enables you to use AWS Budgets to plan your service
usage, service costs, and instance reservations. The API reference
provides descriptions, syntax, and usage examples for each of the
actions and data types for AWS Budgets.

Budgets provide you with a way to see the following information:
\itemize{
\item How close your plan is to your budgeted amount or to the free tier
limits
\item Your usage-to-date, including how much you\'ve used of your Reserved
Instances (RIs)
\item Your current estimated charges from AWS, and how much your predicted
usage will accrue in charges by the end of the month
\item How much of your budget has been used
}

AWS updates your budget status several times a day. Budgets track your
unblended costs, subscriptions, refunds, and RIs. You can create the
following types of budgets:
\itemize{
\item \strong{Cost budgets} - Plan how much you want to spend on a service.
\item \strong{Usage budgets} - Plan how much you want to use one or more
services.
\item \strong{RI utilization budgets} - Define a utilization threshold, and
receive alerts when your RI usage falls below that threshold. This
lets you see if your RIs are unused or under-utilized.
\item \strong{RI coverage budgets} - Define a coverage threshold, and receive
alerts when the number of your instance hours that are covered by
RIs fall below that threshold. This lets you see how much of your
instance usage is covered by a reservation.
}

Service Endpoint

The AWS Budgets API provides the following endpoint:
\itemize{
\item https://budgets.amazonaws.com
}

For information about costs that are associated with the AWS Budgets
API, see \href{https://aws.amazon.com/aws-cost-management/pricing/}{AWS Cost Management Pricing}.
}
\section{Service syntax}{
\preformatted{svc <- budgets(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string"
    ),
    endpoint = "string",
    region = "string"
  )
)
}
}

\section{Operations}{

\tabular{ll}{
\link[=budgets_create_budget]{create_budget} \tab Creates a budget and, if included, notifications and subscribers\cr
\link[=budgets_create_notification]{create_notification} \tab Creates a notification \cr
\link[=budgets_create_subscriber]{create_subscriber} \tab Creates a subscriber \cr
\link[=budgets_delete_budget]{delete_budget} \tab Deletes a budget \cr
\link[=budgets_delete_notification]{delete_notification} \tab Deletes a notification \cr
\link[=budgets_delete_subscriber]{delete_subscriber} \tab Deletes a subscriber \cr
\link[=budgets_describe_budget]{describe_budget} \tab Describes a budget \cr
\link[=budgets_describe_budget_performance_history]{describe_budget_performance_history} \tab Describes the history for DAILY, MONTHLY, and QUARTERLY budgets \cr
\link[=budgets_describe_budgets]{describe_budgets} \tab Lists the budgets that are associated with an account \cr
\link[=budgets_describe_notifications_for_budget]{describe_notifications_for_budget} \tab Lists the notifications that are associated with a budget \cr
\link[=budgets_describe_subscribers_for_notification]{describe_subscribers_for_notification} \tab Lists the subscribers that are associated with a notification \cr
\link[=budgets_update_budget]{update_budget} \tab Updates a budget \cr
\link[=budgets_update_notification]{update_notification} \tab Updates a notification \cr
\link[=budgets_update_subscriber]{update_subscriber} \tab Updates a subscriber
}
}

\examples{
\dontrun{
svc <- budgets()
svc$create_budget(
  Foo = 123
)
}

}
