% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/budgets_operations.R
\name{budgets_update_budget}
\alias{budgets_update_budget}
\title{Updates a budget}
\usage{
budgets_update_budget(AccountId, NewBudget)
}
\arguments{
\item{AccountId}{[required] The \code{accountId} that is associated with the budget that you want to
update.}

\item{NewBudget}{[required] The budget that you want to update your budget to.}
}
\description{
Updates a budget. You can change every part of a budget except for the
\code{budgetName} and the \code{calculatedSpend}. When you modify a budget, the
\code{calculatedSpend} drops to zero until AWS has new usage data to use for
forecasting.
}
\details{
Only one of \code{BudgetLimit} or \code{PlannedBudgetLimits} can be present in the
syntax at one time. Use the syntax that matches your case. The Request
Syntax section shows the \code{BudgetLimit} syntax. For
\code{PlannedBudgetLimits}, see the
\href{https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_UpdateBudget.html#API_UpdateBudget_Examples}{Examples}
section.
}
\section{Request syntax}{
\preformatted{svc$update_budget(
  AccountId = "string",
  NewBudget = list(
    BudgetName = "string",
    BudgetLimit = list(
      Amount = "string",
      Unit = "string"
    ),
    PlannedBudgetLimits = list(
      list(
        Amount = "string",
        Unit = "string"
      )
    ),
    CostFilters = list(
      list(
        "string"
      )
    ),
    CostTypes = list(
      IncludeTax = TRUE|FALSE,
      IncludeSubscription = TRUE|FALSE,
      UseBlended = TRUE|FALSE,
      IncludeRefund = TRUE|FALSE,
      IncludeCredit = TRUE|FALSE,
      IncludeUpfront = TRUE|FALSE,
      IncludeRecurring = TRUE|FALSE,
      IncludeOtherSubscription = TRUE|FALSE,
      IncludeSupport = TRUE|FALSE,
      IncludeDiscount = TRUE|FALSE,
      UseAmortized = TRUE|FALSE
    ),
    TimeUnit = "DAILY"|"MONTHLY"|"QUARTERLY"|"ANNUALLY",
    TimePeriod = list(
      Start = as.POSIXct(
        "2015-01-01"
      ),
      End = as.POSIXct(
        "2015-01-01"
      )
    ),
    CalculatedSpend = list(
      ActualSpend = list(
        Amount = "string",
        Unit = "string"
      ),
      ForecastedSpend = list(
        Amount = "string",
        Unit = "string"
      )
    ),
    BudgetType = "USAGE"|"COST"|"RI_UTILIZATION"|"RI_COVERAGE"|"SAVINGS_PLANS_UTILIZATION"|"SAVINGS_PLANS_COVERAGE",
    LastUpdatedTime = as.POSIXct(
      "2015-01-01"
    )
  )
)
}
}

\keyword{internal}
