# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' AWS Cost and Usage Report Service
#'
#' @description
#' The AWS Cost and Usage Report API enables you to programmatically
#' create, query, and delete AWS Cost and Usage report definitions.
#' 
#' AWS Cost and Usage reports track the monthly AWS costs and usage
#' associated with your AWS account. The report contains line items for
#' each unique combination of AWS product, usage type, and operation that
#' your AWS account uses. You can configure the AWS Cost and Usage report
#' to show only the data that you want, using the AWS Cost and Usage API.
#' 
#' Service Endpoint
#' 
#' The AWS Cost and Usage Report API provides the following endpoint:
#' 
#' -   cur.us-east-1.amazonaws.com
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' \item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
#' \item{\strong{region}:} {The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}:} {Immediately close all HTTP connections.}
#' \item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}:} {Set this to `true` to force the request to use path-style addressing, i.e., `http://s3.amazonaws.com/BUCKET/KEY`.}
#' }
#'
#' @section Service syntax:
#' ```
#' svc <- costandusagereportservice(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- costandusagereportservice()
#' # The following example deletes the AWS Cost and Usage report named
#' # ExampleReport.
#' svc$delete_report_definition(
#'   ReportName = "ExampleReport"
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=costandusagereportservice_delete_report_definition]{delete_report_definition} \tab Deletes the specified report\cr
#'  \link[=costandusagereportservice_describe_report_definitions]{describe_report_definitions} \tab Lists the AWS Cost and Usage reports available to this account\cr
#'  \link[=costandusagereportservice_modify_report_definition]{modify_report_definition} \tab Allows you to programatically update your report preferences\cr
#'  \link[=costandusagereportservice_put_report_definition]{put_report_definition} \tab Creates a new report using the description that you provide
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname costandusagereportservice
#' @export
costandusagereportservice <- function(config = list()) {
  svc <- .costandusagereportservice$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.costandusagereportservice <- list()

.costandusagereportservice$operations <- list()

.costandusagereportservice$metadata <- list(
  service_name = "cur",
  endpoints = list("*" = list(endpoint = "cur.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "cur.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "cur.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "cur.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "Cost and Usage Report Service",
  api_version = "2017-01-06",
  signing_name = "cur",
  json_version = "1.1",
  target_prefix = "AWSOrigamiServiceGatewayService"
)

.costandusagereportservice$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.costandusagereportservice$metadata, handlers, config)
}
