% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paymentcryptographydataplane_operations.R
\name{paymentcryptographydataplane_decrypt_data}
\alias{paymentcryptographydataplane_decrypt_data}
\title{Decrypts ciphertext data to plaintext using a symmetric (TDES, AES),
asymmetric (RSA), or derived (DUKPT or EMV) encryption key scheme}
\usage{
paymentcryptographydataplane_decrypt_data(
  CipherText,
  DecryptionAttributes,
  KeyIdentifier
)
}
\arguments{
\item{CipherText}{[required] The ciphertext to decrypt.}

\item{DecryptionAttributes}{[required] The encryption key type and attributes for ciphertext decryption.}

\item{KeyIdentifier}{[required] The \code{keyARN} of the encryption key that Amazon Web Services Payment
Cryptography uses for ciphertext decryption.}
}
\description{
Decrypts ciphertext data to plaintext using a symmetric (TDES, AES), asymmetric (RSA), or derived (DUKPT or EMV) encryption key scheme. For more information, see \href{https://docs.aws.amazon.com/payment-cryptography/latest/userguide/decrypt-data.html}{Decrypt data} in the \emph{Amazon Web Services Payment Cryptography User Guide}.

See \url{https://www.paws-r-sdk.com/docs/paymentcryptographydataplane_decrypt_data/} for full documentation.
}
\keyword{internal}
