% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ses_operations.R
\name{ses_set_identity_dkim_enabled}
\alias{ses_set_identity_dkim_enabled}
\title{Enables or disables Easy DKIM signing of email sent from an identity: -
If Easy DKIM signing is enabled for a domain name identity (such as
example}
\usage{
ses_set_identity_dkim_enabled(Identity, DkimEnabled)
}
\arguments{
\item{Identity}{[required] The identity for which DKIM signing should be enabled or disabled.}

\item{DkimEnabled}{[required] Sets whether DKIM signing is enabled for an identity. Set to \code{true} to
enable DKIM signing for this identity; \code{false} to disable it.}
}
\description{
Enables or disables Easy DKIM signing of email sent from an identity:
}
\details{
\itemize{
\item If Easy DKIM signing is enabled for a domain name identity (such as
\code{example.com}), then Amazon SES will DKIM-sign all email sent by
addresses under that domain name (for example, \code{user@example.com}).
\item If Easy DKIM signing is enabled for an email address, then Amazon
SES will DKIM-sign all email sent by that email address.
}

For email addresses (for example, \code{user@example.com}), you can only
enable Easy DKIM signing if the corresponding domain (in this case,
\code{example.com}) has been set up for Easy DKIM using the AWS Console or
the \code{VerifyDomainDkim} operation.

You can execute this operation no more than once per second.

For more information about Easy DKIM signing, go to the \href{http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html}{Amazon SES Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$set_identity_dkim_enabled(
  Identity = "string",
  DkimEnabled = TRUE|FALSE
)
}
}

\examples{
# The following example configures Amazon SES to Easy DKIM-sign the email
# sent from an identity:
\donttest{svc$set_identity_dkim_enabled(
  DkimEnabled = TRUE,
  Identity = "user@example.com"
)}

}
\keyword{internal}
