% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_list_routing_profiles}
\alias{connect_list_routing_profiles}
\title{Provides summary information about the routing profiles for the
specified Amazon Connect instance}
\usage{
connect_list_routing_profiles(InstanceId, NextToken, MaxResults)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance.}

\item{NextToken}{The token for the next set of results. Use the value returned in the
previous response in the next request to retrieve the next set of
results.}

\item{MaxResults}{The maximimum number of results to return per page.}
}
\description{
Provides summary information about the routing profiles for the
specified Amazon Connect instance.

For more information about routing profiles, see \href{https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing.html}{Routing Profiles}
and \href{https://docs.aws.amazon.com/connect/latest/adminguide/routing-profiles.html}{Create a Routing Profile}
in the \emph{Amazon Connect Administrator Guide}.
}
\section{Request syntax}{
\preformatted{svc$list_routing_profiles(
  InstanceId = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
