% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pinpoint_operations.R
\name{pinpoint_put_events}
\alias{pinpoint_put_events}
\title{Creates a new event to record for endpoints, or creates or updates
endpoint data that existing events are associated with}
\usage{
pinpoint_put_events(ApplicationId, EventsRequest)
}
\arguments{
\item{ApplicationId}{[required] The unique identifier for the application. This identifier is displayed
as the \strong{Project ID} on the Amazon Pinpoint console.}

\item{EventsRequest}{[required]}
}
\description{
Creates a new event to record for endpoints, or creates or updates
endpoint data that existing events are associated with.
}
\section{Request syntax}{
\preformatted{svc$put_events(
  ApplicationId = "string",
  EventsRequest = list(
    BatchItem = list(
      list(
        Endpoint = list(
          Address = "string",
          Attributes = list(
            list(
              "string"
            )
          ),
          ChannelType = "PUSH"|"GCM"|"APNS"|"APNS_SANDBOX"|"APNS_VOIP"|"APNS_VOIP_SANDBOX"|"ADM"|"SMS"|"VOICE"|"EMAIL"|"BAIDU"|"CUSTOM",
          Demographic = list(
            AppVersion = "string",
            Locale = "string",
            Make = "string",
            Model = "string",
            ModelVersion = "string",
            Platform = "string",
            PlatformVersion = "string",
            Timezone = "string"
          ),
          EffectiveDate = "string",
          EndpointStatus = "string",
          Location = list(
            City = "string",
            Country = "string",
            Latitude = 123.0,
            Longitude = 123.0,
            PostalCode = "string",
            Region = "string"
          ),
          Metrics = list(
            123.0
          ),
          OptOut = "string",
          RequestId = "string",
          User = list(
            UserAttributes = list(
              list(
                "string"
              )
            ),
            UserId = "string"
          )
        ),
        Events = list(
          list(
            AppPackageName = "string",
            AppTitle = "string",
            AppVersionCode = "string",
            Attributes = list(
              "string"
            ),
            ClientSdkVersion = "string",
            EventType = "string",
            Metrics = list(
              123.0
            ),
            SdkName = "string",
            Session = list(
              Duration = 123,
              Id = "string",
              StartTimestamp = "string",
              StopTimestamp = "string"
            ),
            Timestamp = "string"
          )
        )
      )
    )
  )
)
}
}

\keyword{internal}
