% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pinpoint_operations.R
\name{pinpoint_update_endpoint}
\alias{pinpoint_update_endpoint}
\title{Creates a new endpoint for an application or updates the settings and
attributes of an existing endpoint for an application}
\usage{
pinpoint_update_endpoint(ApplicationId, EndpointId, EndpointRequest)
}
\arguments{
\item{ApplicationId}{[required] The unique identifier for the application. This identifier is displayed
as the \strong{Project ID} on the Amazon Pinpoint console.}

\item{EndpointId}{[required] The unique identifier for the endpoint.}

\item{EndpointRequest}{[required]}
}
\description{
Creates a new endpoint for an application or updates the settings and
attributes of an existing endpoint for an application. You can also use
this operation to define custom attributes (Attributes, Metrics, and
UserAttributes properties) for an endpoint.
}
\section{Request syntax}{
\preformatted{svc$update_endpoint(
  ApplicationId = "string",
  EndpointId = "string",
  EndpointRequest = list(
    Address = "string",
    Attributes = list(
      list(
        "string"
      )
    ),
    ChannelType = "GCM"|"APNS"|"APNS_SANDBOX"|"APNS_VOIP"|"APNS_VOIP_SANDBOX"|"ADM"|"SMS"|"VOICE"|"EMAIL"|"BAIDU"|"CUSTOM",
    Demographic = list(
      AppVersion = "string",
      Locale = "string",
      Make = "string",
      Model = "string",
      ModelVersion = "string",
      Platform = "string",
      PlatformVersion = "string",
      Timezone = "string"
    ),
    EffectiveDate = "string",
    EndpointStatus = "string",
    Location = list(
      City = "string",
      Country = "string",
      Latitude = 123.0,
      Longitude = 123.0,
      PostalCode = "string",
      Region = "string"
    ),
    Metrics = list(
      123.0
    ),
    OptOut = "string",
    RequestId = "string",
    User = list(
      UserAttributes = list(
        list(
          "string"
        )
      ),
      UserId = "string"
    )
  )
)
}
}

\keyword{internal}
