% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ses_operations.R
\name{ses_update_configuration_set_event_destination}
\alias{ses_update_configuration_set_event_destination}
\title{Updates the event destination of a configuration set}
\usage{
ses_update_configuration_set_event_destination(
  ConfigurationSetName,
  EventDestination
)
}
\arguments{
\item{ConfigurationSetName}{[required] The name of the configuration set that contains the event destination.}

\item{EventDestination}{[required] The event destination object.}
}
\description{
Updates the event destination of a configuration set. Event destinations are associated with configuration sets, which enable you to publish email sending events to Amazon CloudWatch, Amazon Kinesis Firehose, or Amazon Simple Notification Service (Amazon SNS). For information about using configuration sets, see \href{https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html}{Monitoring Your Amazon SES Sending Activity} in the \emph{Amazon SES Developer Guide.}

See \url{https://www.paws-r-sdk.com/docs/ses_update_configuration_set_event_destination/} for full documentation.
}
\keyword{internal}
