% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_update_evaluation_form}
\alias{connect_update_evaluation_form}
\title{Updates details about a specific evaluation form version in the
specified Amazon Connect instance}
\usage{
connect_update_evaluation_form(
  InstanceId,
  EvaluationFormId,
  EvaluationFormVersion,
  CreateNewVersion = NULL,
  Title,
  Description = NULL,
  Items,
  ScoringStrategy = NULL,
  ClientToken = NULL
)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance. You can \href{https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html}{find the instance ID}
in the Amazon Resource Name (ARN) of the instance.}

\item{EvaluationFormId}{[required] The unique identifier for the evaluation form.}

\item{EvaluationFormVersion}{[required] A version of the evaluation form to update.}

\item{CreateNewVersion}{A flag indicating whether the operation must create a new version.}

\item{Title}{[required] A title of the evaluation form.}

\item{Description}{The description of the evaluation form.}

\item{Items}{[required] Items that are part of the evaluation form. The total number of sections
and questions must not exceed 100 each. Questions must be contained in a
section.}

\item{ScoringStrategy}{A scoring strategy of the evaluation form.}

\item{ClientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. If not provided, the Amazon Web Services SDK
populates this field. For more information about idempotency, see
\href{https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/}{Making retries safe with idempotent APIs}.}
}
\description{
Updates details about a specific evaluation form version in the specified Amazon Connect instance. Question and section identifiers cannot be duplicated within the same evaluation form.

See \url{https://www.paws-r-sdk.com/docs/connect_update_evaluation_form/} for full documentation.
}
\keyword{internal}
