% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docdb_operations.R
\name{docdb_modify_db_cluster_parameter_group}
\alias{docdb_modify_db_cluster_parameter_group}
\title{Modifies the parameters of a cluster parameter group}
\usage{
docdb_modify_db_cluster_parameter_group(DBClusterParameterGroupName,
  Parameters)
}
\arguments{
\item{DBClusterParameterGroupName}{[required] The name of the cluster parameter group to modify.}

\item{Parameters}{[required] A list of parameters in the cluster parameter group to modify.}
}
\description{
Modifies the parameters of a cluster parameter group. To modify more
than one parameter, submit a list of the following: \code{ParameterName},
\code{ParameterValue}, and \code{ApplyMethod}. A maximum of 20 parameters can be
modified in a single request.

Changes to dynamic parameters are applied immediately. Changes to static
parameters require a reboot or maintenance window before the change can
take effect.

After you create a cluster parameter group, you should wait at least 5
minutes before creating your first cluster that uses that cluster
parameter group as the default parameter group. This allows Amazon
DocumentDB to fully complete the create action before the parameter
group is used as the default for a new cluster. This step is especially
important for parameters that are critical when creating the default
database for a cluster, such as the character set for the default
database defined by the \code{character_set_database} parameter.
}
\section{Request syntax}{
\preformatted{svc$modify_db_cluster_parameter_group(
  DBClusterParameterGroupName = "string",
  Parameters = list(
    list(
      ParameterName = "string",
      ParameterValue = "string",
      Description = "string",
      Source = "string",
      ApplyType = "string",
      DataType = "string",
      AllowedValues = "string",
      IsModifiable = TRUE|FALSE,
      MinimumEngineVersion = "string",
      ApplyMethod = "immediate"|"pending-reboot"
    )
  )
)
}
}

\keyword{internal}
