% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodb_operations.R
\name{dynamodb_describe_contributor_insights}
\alias{dynamodb_describe_contributor_insights}
\title{Returns information about contributor insights, for a given table or
global secondary index}
\usage{
dynamodb_describe_contributor_insights(TableName, IndexName)
}
\arguments{
\item{TableName}{[required] The name of the table to describe.}

\item{IndexName}{The name of the global secondary index to describe, if applicable.}
}
\value{
A list with the following syntax:\preformatted{list(
  TableName = "string",
  IndexName = "string",
  ContributorInsightsRuleList = list(
    "string"
  ),
  ContributorInsightsStatus = "ENABLING"|"ENABLED"|"DISABLING"|"DISABLED"|"FAILED",
  LastUpdateDateTime = as.POSIXct(
    "2015-01-01"
  ),
  FailureException = list(
    ExceptionName = "string",
    ExceptionDescription = "string"
  )
)
}
}
\description{
Returns information about contributor insights, for a given table or
global secondary index.
}
\section{Request syntax}{
\preformatted{svc$describe_contributor_insights(
  TableName = "string",
  IndexName = "string"
)
}
}

\keyword{internal}
