% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_modify_cluster_snapshot}
\alias{redshift_modify_cluster_snapshot}
\title{Modifies the settings for a snapshot}
\usage{
redshift_modify_cluster_snapshot(SnapshotIdentifier,
  ManualSnapshotRetentionPeriod, Force)
}
\arguments{
\item{SnapshotIdentifier}{[required] The identifier of the snapshot whose setting you want to modify.}

\item{ManualSnapshotRetentionPeriod}{The number of days that a manual snapshot is retained. If the value is
-1, the manual snapshot is retained indefinitely.

If the manual snapshot falls outside of the new retention period, you
can specify the force option to immediately delete the snapshot.

The value must be either -1 or an integer between 1 and 3,653.}

\item{Force}{A Boolean option to override an exception if the retention period has
already passed.}
}
\value{
A list with the following syntax:\preformatted{list(
  Snapshot = list(
    SnapshotIdentifier = "string",
    ClusterIdentifier = "string",
    SnapshotCreateTime = as.POSIXct(
      "2015-01-01"
    ),
    Status = "string",
    Port = 123,
    AvailabilityZone = "string",
    ClusterCreateTime = as.POSIXct(
      "2015-01-01"
    ),
    MasterUsername = "string",
    ClusterVersion = "string",
    EngineFullVersion = "string",
    SnapshotType = "string",
    NodeType = "string",
    NumberOfNodes = 123,
    DBName = "string",
    VpcId = "string",
    Encrypted = TRUE|FALSE,
    KmsKeyId = "string",
    EncryptedWithHSM = TRUE|FALSE,
    AccountsWithRestoreAccess = list(
      list(
        AccountId = "string",
        AccountAlias = "string"
      )
    ),
    OwnerAccount = "string",
    TotalBackupSizeInMegaBytes = 123.0,
    ActualIncrementalBackupSizeInMegaBytes = 123.0,
    BackupProgressInMegaBytes = 123.0,
    CurrentBackupRateInMegaBytesPerSecond = 123.0,
    EstimatedSecondsToCompletion = 123,
    ElapsedTimeInSeconds = 123,
    SourceRegion = "string",
    Tags = list(
      list(
        Key = "string",
        Value = "string"
      )
    ),
    RestorableNodeTypes = list(
      "string"
    ),
    EnhancedVpcRouting = TRUE|FALSE,
    MaintenanceTrackName = "string",
    ManualSnapshotRetentionPeriod = 123,
    ManualSnapshotRemainingDays = 123,
    SnapshotRetentionStartTime = as.POSIXct(
      "2015-01-01"
    )
  )
)
}
}
\description{
Modifies the settings for a snapshot.

This exanmple modifies the manual retention period setting for a cluster
snapshot.
}
\section{Request syntax}{
\preformatted{svc$modify_cluster_snapshot(
  SnapshotIdentifier = "string",
  ManualSnapshotRetentionPeriod = 123,
  Force = TRUE|FALSE
)
}
}

\keyword{internal}
