% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_add_role_to_db_cluster}
\alias{neptune_add_role_to_db_cluster}
\title{Associates an Identity and Access Management (IAM) role from an Neptune
DB cluster}
\usage{
neptune_add_role_to_db_cluster(DBClusterIdentifier, RoleArn)
}
\arguments{
\item{DBClusterIdentifier}{[required] The name of the DB cluster to associate the IAM role with.}

\item{RoleArn}{[required] The Amazon Resource Name (ARN) of the IAM role to associate with the
Neptune DB cluster, for example
\code{arn:aws:iam::123456789012:role/NeptuneAccessRole}.}
}
\description{
Associates an Identity and Access Management (IAM) role from an Neptune
DB cluster.
}
\section{Request syntax}{
\preformatted{svc$add_role_to_db_cluster(
  DBClusterIdentifier = "string",
  RoleArn = "string"
)
}
}

\keyword{internal}
