% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_restore_db_cluster_to_point_in_time}
\alias{neptune_restore_db_cluster_to_point_in_time}
\title{Restores a DB cluster to an arbitrary point in time}
\usage{
neptune_restore_db_cluster_to_point_in_time(DBClusterIdentifier,
  RestoreType, SourceDBClusterIdentifier, RestoreToTime,
  UseLatestRestorableTime, Port, DBSubnetGroupName, OptionGroupName,
  VpcSecurityGroupIds, Tags, KmsKeyId, EnableIAMDatabaseAuthentication,
  EnableCloudwatchLogsExports, DBClusterParameterGroupName)
}
\arguments{
\item{DBClusterIdentifier}{[required] The name of the new DB cluster to be created.

Constraints:
\itemize{
\item Must contain from 1 to 63 letters, numbers, or hyphens
\item First character must be a letter
\item Cannot end with a hyphen or contain two consecutive hyphens
}}

\item{RestoreType}{The type of restore to be performed. You can specify one of the
following values:
\itemize{
\item \code{full-copy} - The new DB cluster is restored as a full copy of the
source DB cluster.
\item \code{copy-on-write} - The new DB cluster is restored as a clone of the
source DB cluster.
}

If you don\'t specify a \code{RestoreType} value, then the new DB cluster is
restored as a full copy of the source DB cluster.}

\item{SourceDBClusterIdentifier}{[required] The identifier of the source DB cluster from which to restore.

Constraints:
\itemize{
\item Must match the identifier of an existing DBCluster.
}}

\item{RestoreToTime}{The date and time to restore the DB cluster to.

Valid Values: Value must be a time in Universal Coordinated Time (UTC)
format

Constraints:
\itemize{
\item Must be before the latest restorable time for the DB instance
\item Must be specified if \code{UseLatestRestorableTime} parameter is not
provided
\item Cannot be specified if \code{UseLatestRestorableTime} parameter is true
\item Cannot be specified if \code{RestoreType} parameter is \code{copy-on-write}
}

Example: \verb{2015-03-07T23:45:00Z}}

\item{UseLatestRestorableTime}{A value that is set to \code{true} to restore the DB cluster to the latest
restorable backup time, and \code{false} otherwise.

Default: \code{false}

Constraints: Cannot be specified if \code{RestoreToTime} parameter is
provided.}

\item{Port}{The port number on which the new DB cluster accepts connections.

Constraints: Value must be \code{1150-65535}

Default: The same port as the original DB cluster.}

\item{DBSubnetGroupName}{The DB subnet group name to use for the new DB cluster.

Constraints: If supplied, must match the name of an existing
DBSubnetGroup.

Example: \code{mySubnetgroup}}

\item{OptionGroupName}{The name of the option group for the new DB cluster.}

\item{VpcSecurityGroupIds}{A list of VPC security groups that the new DB cluster belongs to.}

\item{Tags}{The tags to be applied to the restored DB cluster.}

\item{KmsKeyId}{The AWS KMS key identifier to use when restoring an encrypted DB cluster
from an encrypted DB cluster.

The KMS key identifier is the Amazon Resource Name (ARN) for the KMS
encryption key. If you are restoring a DB cluster with the same AWS
account that owns the KMS encryption key used to encrypt the new DB
cluster, then you can use the KMS key alias instead of the ARN for the
KMS encryption key.

You can restore to a new DB cluster and encrypt the new DB cluster with
a KMS key that is different than the KMS key used to encrypt the source
DB cluster. The new DB cluster is encrypted with the KMS key identified
by the \code{KmsKeyId} parameter.

If you do not specify a value for the \code{KmsKeyId} parameter, then the
following will occur:
\itemize{
\item If the DB cluster is encrypted, then the restored DB cluster is
encrypted using the KMS key that was used to encrypt the source DB
cluster.
\item If the DB cluster is not encrypted, then the restored DB cluster is
not encrypted.
}

If \code{DBClusterIdentifier} refers to a DB cluster that is not encrypted,
then the restore request is rejected.}

\item{EnableIAMDatabaseAuthentication}{True to enable mapping of AWS Identity and Access Management (IAM)
accounts to database accounts, and otherwise false.

Default: \code{false}}

\item{EnableCloudwatchLogsExports}{The list of logs that the restored DB cluster is to export to CloudWatch
Logs.}

\item{DBClusterParameterGroupName}{The name of the DB cluster parameter group to associate with the new DB
cluster.

Constraints:
\itemize{
\item If supplied, must match the name of an existing
DBClusterParameterGroup.
}}
}
\description{
Restores a DB cluster to an arbitrary point in time. Users can restore
to any point in time before \code{LatestRestorableTime} for up to
\code{BackupRetentionPeriod} days. The target DB cluster is created from the
source DB cluster with the same configuration as the original DB
cluster, except that the new DB cluster is created with the default DB
security group.
}
\details{
This action only restores the DB cluster, not the DB instances for that
DB cluster. You must invoke the CreateDBInstance action to create DB
instances for the restored DB cluster, specifying the identifier of the
restored DB cluster in \code{DBClusterIdentifier}. You can create DB
instances only after the \code{RestoreDBClusterToPointInTime} action has
completed and the DB cluster is available.
}
\section{Request syntax}{
\preformatted{svc$restore_db_cluster_to_point_in_time(
  DBClusterIdentifier = "string",
  RestoreType = "string",
  SourceDBClusterIdentifier = "string",
  RestoreToTime = as.POSIXct(
    "2015-01-01"
  ),
  UseLatestRestorableTime = TRUE|FALSE,
  Port = 123,
  DBSubnetGroupName = "string",
  OptionGroupName = "string",
  VpcSecurityGroupIds = list(
    "string"
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  KmsKeyId = "string",
  EnableIAMDatabaseAuthentication = TRUE|FALSE,
  EnableCloudwatchLogsExports = list(
    "string"
  ),
  DBClusterParameterGroupName = "string"
)
}
}

\keyword{internal}
