% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodb_operations.R
\name{dynamodb_delete_table}
\alias{dynamodb_delete_table}
\title{The DeleteTable operation deletes a table and all of its items}
\usage{
dynamodb_delete_table(TableName)
}
\arguments{
\item{TableName}{[required] The name of the table to delete.}
}
\description{
The \code{DeleteTable} operation deletes a table and all of its items. After
a \code{DeleteTable} request, the specified table is in the \code{DELETING} state
until DynamoDB completes the deletion. If the table is in the \code{ACTIVE}
state, you can delete it. If a table is in \code{CREATING} or \code{UPDATING}
states, then DynamoDB returns a \code{ResourceInUseException}. If the
specified table does not exist, DynamoDB returns a
\code{ResourceNotFoundException}. If table is already in the \code{DELETING}
state, no error is returned.
}
\details{
DynamoDB might continue to accept data read and write operations, such
as \code{GetItem} and \code{PutItem}, on a table in the \code{DELETING} state until the
table deletion is complete.

When you delete a table, any indexes on that table are also deleted.

If you have DynamoDB Streams enabled on the table, then the
corresponding stream on that table goes into the \code{DISABLED} state, and
the stream is automatically deleted after 24 hours.

Use the \code{DescribeTable} action to check the status of the table.
}
\section{Request syntax}{
\preformatted{svc$delete_table(
  TableName = "string"
)
}
}

\examples{
\dontrun{
# This example deletes the Music table.
svc$delete_table(
  TableName = "Music"
)
}

}
\keyword{internal}
