% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticache_operations.R
\name{elasticache_create_user}
\alias{elasticache_create_user}
\title{For Redis engine version 6}
\usage{
elasticache_create_user(
  UserId,
  UserName,
  Engine,
  Passwords = NULL,
  AccessString,
  NoPasswordRequired = NULL,
  Tags = NULL
)
}
\arguments{
\item{UserId}{[required] The ID of the user.}

\item{UserName}{[required] The username of the user.}

\item{Engine}{[required] The current supported value is Redis.}

\item{Passwords}{Passwords used for this user. You can create up to two passwords for
each user.}

\item{AccessString}{[required] Access permissions string used for this user.}

\item{NoPasswordRequired}{Indicates a password is not required for this user.}

\item{Tags}{A list of tags to be added to this resource. A tag is a key-value pair.
A tag key must be accompanied by a tag value, although null is accepted.}
}
\description{
For Redis engine version 6.0 onwards: Creates a Redis user. For more information, see \href{https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html}{Using Role Based Access Control (RBAC)}.

See \url{https://paws-r.github.io/docs/elasticache/create_user.html} for full documentation.
}
\keyword{internal}
