% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qldb_operations.R
\name{qldb_export_journal_to_s3}
\alias{qldb_export_journal_to_s3}
\title{Exports journal contents within a date and time range from a ledger into
a specified Amazon Simple Storage Service (Amazon S3) bucket}
\usage{
qldb_export_journal_to_s3(
  Name,
  InclusiveStartTime,
  ExclusiveEndTime,
  S3ExportConfiguration,
  RoleArn,
  OutputFormat = NULL
)
}
\arguments{
\item{Name}{[required] The name of the ledger.}

\item{InclusiveStartTime}{[required] The inclusive start date and time for the range of journal contents to
export.

The \code{InclusiveStartTime} must be in \verb{ISO 8601} date and time format and
in Universal Coordinated Time (UTC). For example:
\verb{2019-06-13T21:36:34Z}.

The \code{InclusiveStartTime} must be before \code{ExclusiveEndTime}.

If you provide an \code{InclusiveStartTime} that is before the ledger's
\code{CreationDateTime}, Amazon QLDB defaults it to the ledger's
\code{CreationDateTime}.}

\item{ExclusiveEndTime}{[required] The exclusive end date and time for the range of journal contents to
export.

The \code{ExclusiveEndTime} must be in \verb{ISO 8601} date and time format and in
Universal Coordinated Time (UTC). For example: \verb{2019-06-13T21:36:34Z}.

The \code{ExclusiveEndTime} must be less than or equal to the current UTC
date and time.}

\item{S3ExportConfiguration}{[required] The configuration settings of the Amazon S3 bucket destination for your
export request.}

\item{RoleArn}{[required] The Amazon Resource Name (ARN) of the IAM role that grants QLDB
permissions for a journal export job to do the following:
\itemize{
\item Write objects into your Amazon Simple Storage Service (Amazon S3)
bucket.
\item (Optional) Use your customer managed key in Key Management Service
(KMS) for server-side encryption of your exported data.
}

To pass a role to QLDB when requesting a journal export, you must have
permissions to perform the \code{iam:PassRole} action on the IAM role
resource. This is required for all journal export requests.}

\item{OutputFormat}{The output format of your exported journal data. If this parameter is
not specified, the exported data defaults to \code{ION_TEXT} format.}
}
\description{
Exports journal contents within a date and time range from a ledger into a specified Amazon Simple Storage Service (Amazon S3) bucket. A journal export job can write the data objects in either the text or binary representation of Amazon Ion format, or in \emph{JSON Lines} text format.

See \url{https://paws-r.github.io/docs/qldb/export_journal_to_s3.html} for full documentation.
}
\keyword{internal}
