% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_get_cluster_credentials_with_iam}
\alias{redshift_get_cluster_credentials_with_iam}
\title{Returns a database user name and temporary password with temporary
authorization to log in to an Amazon Redshift database}
\usage{
redshift_get_cluster_credentials_with_iam(
  DbName = NULL,
  ClusterIdentifier,
  DurationSeconds = NULL
)
}
\arguments{
\item{DbName}{The name of the database for which you are requesting credentials. If
the database name is specified, the IAM policy must allow access to the
resource \code{dbname} for the specified database name. If the database name
is not specified, access to all databases is allowed.}

\item{ClusterIdentifier}{[required] The unique identifier of the cluster that contains the database for
which you are requesting credentials.}

\item{DurationSeconds}{The number of seconds until the returned temporary password expires.

Range: 900-3600. Default: 900.}
}
\description{
Returns a database user name and temporary password with temporary authorization to log in to an Amazon Redshift database. The database user is mapped 1:1 to the source Identity and Access Management (IAM) identity. For more information about IAM identities, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id.html}{IAM Identities (users, user groups, and roles)} in the Amazon Web Services Identity and Access Management User Guide.

See \url{https://paws-r.github.io/docs/redshift/get_cluster_credentials_with_iam.html} for full documentation.
}
\keyword{internal}
