# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include qldb_service.R
NULL

#' Ends a given Amazon QLDB journal stream
#'
#' @description
#' Ends a given Amazon QLDB journal stream. Before a stream can be canceled, its current status must be `ACTIVE`.
#'
#' See [https://www.paws-r-sdk.com/docs/qldb_cancel_journal_kinesis_stream/](https://www.paws-r-sdk.com/docs/qldb_cancel_journal_kinesis_stream/) for full documentation.
#'
#' @param LedgerName &#91;required&#93; The name of the ledger.
#' @param StreamId &#91;required&#93; The UUID (represented in Base62-encoded text) of the QLDB journal stream
#' to be canceled.
#'
#' @keywords internal
#'
#' @rdname qldb_cancel_journal_kinesis_stream
qldb_cancel_journal_kinesis_stream <- function(LedgerName, StreamId) {
  op <- new_operation(
    name = "CancelJournalKinesisStream",
    http_method = "DELETE",
    http_path = "/ledgers/{name}/journal-kinesis-streams/{streamId}",
    paginator = list()
  )
  input <- .qldb$cancel_journal_kinesis_stream_input(LedgerName = LedgerName, StreamId = StreamId)
  output <- .qldb$cancel_journal_kinesis_stream_output()
  config <- get_config()
  svc <- .qldb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.qldb$operations$cancel_journal_kinesis_stream <- qldb_cancel_journal_kinesis_stream

#' Creates a new ledger in your Amazon Web Services account in the current
#' Region
#'
#' @description
#' Creates a new ledger in your Amazon Web Services account in the current Region.
#'
#' See [https://www.paws-r-sdk.com/docs/qldb_create_ledger/](https://www.paws-r-sdk.com/docs/qldb_create_ledger/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the ledger that you want to create. The name must be unique
#' among all of the ledgers in your Amazon Web Services account in the
#' current Region.
#' 
#' Naming constraints for ledger names are defined in [Quotas in Amazon
#' QLDB](https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming)
#' in the *Amazon QLDB Developer Guide*.
#' @param Tags The key-value pairs to add as tags to the ledger that you want to
#' create. Tag keys are case sensitive. Tag values are case sensitive and
#' can be null.
#' @param PermissionsMode &#91;required&#93; The permissions mode to assign to the ledger that you want to create.
#' This parameter can have one of the following values:
#' 
#' -   `ALLOW_ALL`: A legacy permissions mode that enables access control
#'     with API-level granularity for ledgers.
#' 
#'     This mode allows users who have the `SendCommand` API permission for
#'     this ledger to run all PartiQL commands (hence, `ALLOW_ALL`) on any
#'     tables in the specified ledger. This mode disregards any table-level
#'     or command-level IAM permissions policies that you create for the
#'     ledger.
#' 
#' -   `STANDARD`: (*Recommended*) A permissions mode that enables access
#'     control with finer granularity for ledgers, tables, and PartiQL
#'     commands.
#' 
#'     By default, this mode denies all user requests to run any PartiQL
#'     commands on any tables in this ledger. To allow PartiQL commands to
#'     run, you must create IAM permissions policies for specific table
#'     resources and PartiQL actions, in addition to the `SendCommand` API
#'     permission for the ledger. For information, see [Getting started
#'     with the standard permissions
#'     mode](https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-standard-mode.html)
#'     in the *Amazon QLDB Developer Guide*.
#' 
#' We strongly recommend using the `STANDARD` permissions mode to maximize
#' the security of your ledger data.
#' @param DeletionProtection Specifies whether the ledger is protected from being deleted by any
#' user. If not defined during ledger creation, this feature is enabled
#' (`true`) by default.
#' 
#' If deletion protection is enabled, you must first disable it before you
#' can delete the ledger. You can disable it by calling the
#' [`update_ledger`][qldb_update_ledger] operation to set this parameter to
#' `false`.
#' @param KmsKey The key in Key Management Service (KMS) to use for encryption of data at
#' rest in the ledger. For more information, see [Encryption at
#' rest](https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html)
#' in the *Amazon QLDB Developer Guide*.
#' 
#' Use one of the following options to specify this parameter:
#' 
#' -   `AWS_OWNED_KMS_KEY`: Use an KMS key that is owned and managed by
#'     Amazon Web Services on your behalf.
#' 
#' -   **Undefined**: By default, use an Amazon Web Services owned KMS key.
#' 
#' -   **A valid symmetric customer managed KMS key**: Use the specified
#'     symmetric encryption KMS key in your account that you create, own,
#'     and manage.
#' 
#'     Amazon QLDB does not support asymmetric keys. For more information,
#'     see [Using symmetric and asymmetric
#'     keys](https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html)
#'     in the *Key Management Service Developer Guide*.
#' 
#' To specify a customer managed KMS key, you can use its key ID, Amazon
#' Resource Name (ARN), alias name, or alias ARN. When using an alias name,
#' prefix it with `"alias/"`. To specify a key in a different Amazon Web
#' Services account, you must use the key ARN or alias ARN.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Alias name: `alias/ExampleAlias`
#' 
#' -   Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
#' 
#' For more information, see [Key identifiers
#' (KeyId)](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id)
#' in the *Key Management Service Developer Guide*.
#'
#' @keywords internal
#'
#' @rdname qldb_create_ledger
qldb_create_ledger <- function(Name, Tags = NULL, PermissionsMode, DeletionProtection = NULL, KmsKey = NULL) {
  op <- new_operation(
    name = "CreateLedger",
    http_method = "POST",
    http_path = "/ledgers",
    paginator = list()
  )
  input <- .qldb$create_ledger_input(Name = Name, Tags = Tags, PermissionsMode = PermissionsMode, DeletionProtection = DeletionProtection, KmsKey = KmsKey)
  output <- .qldb$create_ledger_output()
  config <- get_config()
  svc <- .qldb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.qldb$operations$create_ledger <- qldb_create_ledger

#' Deletes a ledger and all of its contents
#'
#' @description
#' Deletes a ledger and all of its contents. This action is irreversible.
#'
#' See [https://www.paws-r-sdk.com/docs/qldb_delete_ledger/](https://www.paws-r-sdk.com/docs/qldb_delete_ledger/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the ledger that you want to delete.
#'
#' @keywords internal
#'
#' @rdname qldb_delete_ledger
qldb_delete_ledger <- function(Name) {
  op <- new_operation(
    name = "DeleteLedger",
    http_method = "DELETE",
    http_path = "/ledgers/{name}",
    paginator = list()
  )
  input <- .qldb$delete_ledger_input(Name = Name)
  output <- .qldb$delete_ledger_output()
  config <- get_config()
  svc <- .qldb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.qldb$operations$delete_ledger <- qldb_delete_ledger

#' Returns detailed information about a given Amazon QLDB journal stream
#'
#' @description
#' Returns detailed information about a given Amazon QLDB journal stream. The output includes the Amazon Resource Name (ARN), stream name, current status, creation time, and the parameters of the original stream creation request.
#'
#' See [https://www.paws-r-sdk.com/docs/qldb_describe_journal_kinesis_stream/](https://www.paws-r-sdk.com/docs/qldb_describe_journal_kinesis_stream/) for full documentation.
#'
#' @param LedgerName &#91;required&#93; The name of the ledger.
#' @param StreamId &#91;required&#93; The UUID (represented in Base62-encoded text) of the QLDB journal stream
#' to describe.
#'
#' @keywords internal
#'
#' @rdname qldb_describe_journal_kinesis_stream
qldb_describe_journal_kinesis_stream <- function(LedgerName, StreamId) {
  op <- new_operation(
    name = "DescribeJournalKinesisStream",
    http_method = "GET",
    http_path = "/ledgers/{name}/journal-kinesis-streams/{streamId}",
    paginator = list()
  )
  input <- .qldb$describe_journal_kinesis_stream_input(LedgerName = LedgerName, StreamId = StreamId)
  output <- .qldb$describe_journal_kinesis_stream_output()
  config <- get_config()
  svc <- .qldb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.qldb$operations$describe_journal_kinesis_stream <- qldb_describe_journal_kinesis_stream

#' Returns information about a journal export job, including the ledger
#' name, export ID, creation time, current status, and the parameters of
#' the original export creation request
#'
#' @description
#' Returns information about a journal export job, including the ledger name, export ID, creation time, current status, and the parameters of the original export creation request.
#'
#' See [https://www.paws-r-sdk.com/docs/qldb_describe_journal_s3_export/](https://www.paws-r-sdk.com/docs/qldb_describe_journal_s3_export/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the ledger.
#' @param ExportId &#91;required&#93; The UUID (represented in Base62-encoded text) of the journal export job
#' to describe.
#'
#' @keywords internal
#'
#' @rdname qldb_describe_journal_s3_export
qldb_describe_journal_s3_export <- function(Name, ExportId) {
  op <- new_operation(
    name = "DescribeJournalS3Export",
    http_method = "GET",
    http_path = "/ledgers/{name}/journal-s3-exports/{exportId}",
    paginator = list()
  )
  input <- .qldb$describe_journal_s3_export_input(Name = Name, ExportId = ExportId)
  output <- .qldb$describe_journal_s3_export_output()
  config <- get_config()
  svc <- .qldb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.qldb$operations$describe_journal_s3_export <- qldb_describe_journal_s3_export

#' Returns information about a ledger, including its state, permissions
#' mode, encryption at rest settings, and when it was created
#'
#' @description
#' Returns information about a ledger, including its state, permissions mode, encryption at rest settings, and when it was created.
#'
#' See [https://www.paws-r-sdk.com/docs/qldb_describe_ledger/](https://www.paws-r-sdk.com/docs/qldb_describe_ledger/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the ledger that you want to describe.
#'
#' @keywords internal
#'
#' @rdname qldb_describe_ledger
qldb_describe_ledger <- function(Name) {
  op <- new_operation(
    name = "DescribeLedger",
    http_method = "GET",
    http_path = "/ledgers/{name}",
    paginator = list()
  )
  input <- .qldb$describe_ledger_input(Name = Name)
  output <- .qldb$describe_ledger_output()
  config <- get_config()
  svc <- .qldb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.qldb$operations$describe_ledger <- qldb_describe_ledger

#' Exports journal contents within a date and time range from a ledger into
#' a specified Amazon Simple Storage Service (Amazon S3) bucket
#'
#' @description
#' Exports journal contents within a date and time range from a ledger into a specified Amazon Simple Storage Service (Amazon S3) bucket. A journal export job can write the data objects in either the text or binary representation of Amazon Ion format, or in *JSON Lines* text format.
#'
#' See [https://www.paws-r-sdk.com/docs/qldb_export_journal_to_s3/](https://www.paws-r-sdk.com/docs/qldb_export_journal_to_s3/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the ledger.
#' @param InclusiveStartTime &#91;required&#93; The inclusive start date and time for the range of journal contents to
#' export.
#' 
#' The `InclusiveStartTime` must be in `ISO 8601` date and time format and
#' in Universal Coordinated Time (UTC). For example:
#' `2019-06-13T21:36:34Z`.
#' 
#' The `InclusiveStartTime` must be before `ExclusiveEndTime`.
#' 
#' If you provide an `InclusiveStartTime` that is before the ledger's
#' `CreationDateTime`, Amazon QLDB defaults it to the ledger's
#' `CreationDateTime`.
#' @param ExclusiveEndTime &#91;required&#93; The exclusive end date and time for the range of journal contents to
#' export.
#' 
#' The `ExclusiveEndTime` must be in `ISO 8601` date and time format and in
#' Universal Coordinated Time (UTC). For example: `2019-06-13T21:36:34Z`.
#' 
#' The `ExclusiveEndTime` must be less than or equal to the current UTC
#' date and time.
#' @param S3ExportConfiguration &#91;required&#93; The configuration settings of the Amazon S3 bucket destination for your
#' export request.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role that grants QLDB
#' permissions for a journal export job to do the following:
#' 
#' -   Write objects into your Amazon S3 bucket.
#' 
#' -   (Optional) Use your customer managed key in Key Management Service
#'     (KMS) for server-side encryption of your exported data.
#' 
#' To pass a role to QLDB when requesting a journal export, you must have
#' permissions to perform the `iam:PassRole` action on the IAM role
#' resource. This is required for all journal export requests.
#' @param OutputFormat The output format of your exported journal data. A journal export job
#' can write the data objects in either the text or binary representation
#' of [Amazon
#' Ion](https://docs.aws.amazon.com/qldb/latest/developerguide/ion.html)
#' format, or in [JSON Lines](https://jsonlines.org/) text format.
#' 
#' Default: `ION_TEXT`
#' 
#' In JSON Lines format, each journal block in an exported data object is a
#' valid JSON object that is delimited by a newline. You can use this
#' format to directly integrate JSON exports with analytics tools such as
#' Amazon Athena and Glue because these services can parse
#' newline-delimited JSON automatically.
#'
#' @keywords internal
#'
#' @rdname qldb_export_journal_to_s3
qldb_export_journal_to_s3 <- function(Name, InclusiveStartTime, ExclusiveEndTime, S3ExportConfiguration, RoleArn, OutputFormat = NULL) {
  op <- new_operation(
    name = "ExportJournalToS3",
    http_method = "POST",
    http_path = "/ledgers/{name}/journal-s3-exports",
    paginator = list()
  )
  input <- .qldb$export_journal_to_s3_input(Name = Name, InclusiveStartTime = InclusiveStartTime, ExclusiveEndTime = ExclusiveEndTime, S3ExportConfiguration = S3ExportConfiguration, RoleArn = RoleArn, OutputFormat = OutputFormat)
  output <- .qldb$export_journal_to_s3_output()
  config <- get_config()
  svc <- .qldb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.qldb$operations$export_journal_to_s3 <- qldb_export_journal_to_s3

#' Returns a block object at a specified address in a journal
#'
#' @description
#' Returns a block object at a specified address in a journal. Also returns a proof of the specified block for verification if `DigestTipAddress` is provided.
#'
#' See [https://www.paws-r-sdk.com/docs/qldb_get_block/](https://www.paws-r-sdk.com/docs/qldb_get_block/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the ledger.
#' @param BlockAddress &#91;required&#93; The location of the block that you want to request. An address is an
#' Amazon Ion structure that has two fields: `strandId` and `sequenceNo`.
#' 
#' For example: `{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:14}`.
#' @param DigestTipAddress The latest block location covered by the digest for which to request a
#' proof. An address is an Amazon Ion structure that has two fields:
#' `strandId` and `sequenceNo`.
#' 
#' For example: `{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:49}`.
#'
#' @keywords internal
#'
#' @rdname qldb_get_block
qldb_get_block <- function(Name, BlockAddress, DigestTipAddress = NULL) {
  op <- new_operation(
    name = "GetBlock",
    http_method = "POST",
    http_path = "/ledgers/{name}/block",
    paginator = list()
  )
  input <- .qldb$get_block_input(Name = Name, BlockAddress = BlockAddress, DigestTipAddress = DigestTipAddress)
  output <- .qldb$get_block_output()
  config <- get_config()
  svc <- .qldb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.qldb$operations$get_block <- qldb_get_block

#' Returns the digest of a ledger at the latest committed block in the
#' journal
#'
#' @description
#' Returns the digest of a ledger at the latest committed block in the journal. The response includes a 256-bit hash value and a block address.
#'
#' See [https://www.paws-r-sdk.com/docs/qldb_get_digest/](https://www.paws-r-sdk.com/docs/qldb_get_digest/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the ledger.
#'
#' @keywords internal
#'
#' @rdname qldb_get_digest
qldb_get_digest <- function(Name) {
  op <- new_operation(
    name = "GetDigest",
    http_method = "POST",
    http_path = "/ledgers/{name}/digest",
    paginator = list()
  )
  input <- .qldb$get_digest_input(Name = Name)
  output <- .qldb$get_digest_output()
  config <- get_config()
  svc <- .qldb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.qldb$operations$get_digest <- qldb_get_digest

#' Returns a revision data object for a specified document ID and block
#' address
#'
#' @description
#' Returns a revision data object for a specified document ID and block address. Also returns a proof of the specified revision for verification if `DigestTipAddress` is provided.
#'
#' See [https://www.paws-r-sdk.com/docs/qldb_get_revision/](https://www.paws-r-sdk.com/docs/qldb_get_revision/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the ledger.
#' @param BlockAddress &#91;required&#93; The block location of the document revision to be verified. An address
#' is an Amazon Ion structure that has two fields: `strandId` and
#' `sequenceNo`.
#' 
#' For example: `{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:14}`.
#' @param DocumentId &#91;required&#93; The UUID (represented in Base62-encoded text) of the document to be
#' verified.
#' @param DigestTipAddress The latest block location covered by the digest for which to request a
#' proof. An address is an Amazon Ion structure that has two fields:
#' `strandId` and `sequenceNo`.
#' 
#' For example: `{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:49}`.
#'
#' @keywords internal
#'
#' @rdname qldb_get_revision
qldb_get_revision <- function(Name, BlockAddress, DocumentId, DigestTipAddress = NULL) {
  op <- new_operation(
    name = "GetRevision",
    http_method = "POST",
    http_path = "/ledgers/{name}/revision",
    paginator = list()
  )
  input <- .qldb$get_revision_input(Name = Name, BlockAddress = BlockAddress, DocumentId = DocumentId, DigestTipAddress = DigestTipAddress)
  output <- .qldb$get_revision_output()
  config <- get_config()
  svc <- .qldb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.qldb$operations$get_revision <- qldb_get_revision

#' Returns all Amazon QLDB journal streams for a given ledger
#'
#' @description
#' Returns all Amazon QLDB journal streams for a given ledger.
#'
#' See [https://www.paws-r-sdk.com/docs/qldb_list_journal_kinesis_streams_for_ledger/](https://www.paws-r-sdk.com/docs/qldb_list_journal_kinesis_streams_for_ledger/) for full documentation.
#'
#' @param LedgerName &#91;required&#93; The name of the ledger.
#' @param MaxResults The maximum number of results to return in a single
#' [`list_journal_kinesis_streams_for_ledger`][qldb_list_journal_kinesis_streams_for_ledger]
#' request. (The actual number of results returned might be fewer.)
#' @param NextToken A pagination token, indicating that you want to retrieve the next page
#' of results. If you received a value for `NextToken` in the response from
#' a previous
#' [`list_journal_kinesis_streams_for_ledger`][qldb_list_journal_kinesis_streams_for_ledger]
#' call, you should use that value as input here.
#'
#' @keywords internal
#'
#' @rdname qldb_list_journal_kinesis_streams_for_ledger
qldb_list_journal_kinesis_streams_for_ledger <- function(LedgerName, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListJournalKinesisStreamsForLedger",
    http_method = "GET",
    http_path = "/ledgers/{name}/journal-kinesis-streams",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .qldb$list_journal_kinesis_streams_for_ledger_input(LedgerName = LedgerName, MaxResults = MaxResults, NextToken = NextToken)
  output <- .qldb$list_journal_kinesis_streams_for_ledger_output()
  config <- get_config()
  svc <- .qldb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.qldb$operations$list_journal_kinesis_streams_for_ledger <- qldb_list_journal_kinesis_streams_for_ledger

#' Returns all journal export jobs for all ledgers that are associated with
#' the current Amazon Web Services account and Region
#'
#' @description
#' Returns all journal export jobs for all ledgers that are associated with the current Amazon Web Services account and Region.
#'
#' See [https://www.paws-r-sdk.com/docs/qldb_list_journal_s3_exports/](https://www.paws-r-sdk.com/docs/qldb_list_journal_s3_exports/) for full documentation.
#'
#' @param MaxResults The maximum number of results to return in a single
#' [`list_journal_s3_exports`][qldb_list_journal_s3_exports] request. (The
#' actual number of results returned might be fewer.)
#' @param NextToken A pagination token, indicating that you want to retrieve the next page
#' of results. If you received a value for `NextToken` in the response from
#' a previous [`list_journal_s3_exports`][qldb_list_journal_s3_exports]
#' call, then you should use that value as input here.
#'
#' @keywords internal
#'
#' @rdname qldb_list_journal_s3_exports
qldb_list_journal_s3_exports <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListJournalS3Exports",
    http_method = "GET",
    http_path = "/journal-s3-exports",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .qldb$list_journal_s3_exports_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .qldb$list_journal_s3_exports_output()
  config <- get_config()
  svc <- .qldb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.qldb$operations$list_journal_s3_exports <- qldb_list_journal_s3_exports

#' Returns all journal export jobs for a specified ledger
#'
#' @description
#' Returns all journal export jobs for a specified ledger.
#'
#' See [https://www.paws-r-sdk.com/docs/qldb_list_journal_s3_exports_for_ledger/](https://www.paws-r-sdk.com/docs/qldb_list_journal_s3_exports_for_ledger/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the ledger.
#' @param MaxResults The maximum number of results to return in a single
#' [`list_journal_s3_exports_for_ledger`][qldb_list_journal_s3_exports_for_ledger]
#' request. (The actual number of results returned might be fewer.)
#' @param NextToken A pagination token, indicating that you want to retrieve the next page
#' of results. If you received a value for `NextToken` in the response from
#' a previous
#' [`list_journal_s3_exports_for_ledger`][qldb_list_journal_s3_exports_for_ledger]
#' call, then you should use that value as input here.
#'
#' @keywords internal
#'
#' @rdname qldb_list_journal_s3_exports_for_ledger
qldb_list_journal_s3_exports_for_ledger <- function(Name, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListJournalS3ExportsForLedger",
    http_method = "GET",
    http_path = "/ledgers/{name}/journal-s3-exports",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .qldb$list_journal_s3_exports_for_ledger_input(Name = Name, MaxResults = MaxResults, NextToken = NextToken)
  output <- .qldb$list_journal_s3_exports_for_ledger_output()
  config <- get_config()
  svc <- .qldb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.qldb$operations$list_journal_s3_exports_for_ledger <- qldb_list_journal_s3_exports_for_ledger

#' Returns all ledgers that are associated with the current Amazon Web
#' Services account and Region
#'
#' @description
#' Returns all ledgers that are associated with the current Amazon Web Services account and Region.
#'
#' See [https://www.paws-r-sdk.com/docs/qldb_list_ledgers/](https://www.paws-r-sdk.com/docs/qldb_list_ledgers/) for full documentation.
#'
#' @param MaxResults The maximum number of results to return in a single
#' [`list_ledgers`][qldb_list_ledgers] request. (The actual number of
#' results returned might be fewer.)
#' @param NextToken A pagination token, indicating that you want to retrieve the next page
#' of results. If you received a value for `NextToken` in the response from
#' a previous [`list_ledgers`][qldb_list_ledgers] call, then you should use
#' that value as input here.
#'
#' @keywords internal
#'
#' @rdname qldb_list_ledgers
qldb_list_ledgers <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListLedgers",
    http_method = "GET",
    http_path = "/ledgers",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .qldb$list_ledgers_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .qldb$list_ledgers_output()
  config <- get_config()
  svc <- .qldb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.qldb$operations$list_ledgers <- qldb_list_ledgers

#' Returns all tags for a specified Amazon QLDB resource
#'
#' @description
#' Returns all tags for a specified Amazon QLDB resource.
#'
#' See [https://www.paws-r-sdk.com/docs/qldb_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/qldb_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) for which to list the tags. For example:
#' 
#' `arn:aws:qldb:us-east-1:123456789012:ledger/exampleLedger`
#'
#' @keywords internal
#'
#' @rdname qldb_list_tags_for_resource
qldb_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .qldb$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .qldb$list_tags_for_resource_output()
  config <- get_config()
  svc <- .qldb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.qldb$operations$list_tags_for_resource <- qldb_list_tags_for_resource

#' Creates a journal stream for a given Amazon QLDB ledger
#'
#' @description
#' Creates a journal stream for a given Amazon QLDB ledger. The stream captures every document revision that is committed to the ledger's journal and delivers the data to a specified Amazon Kinesis Data Streams resource.
#'
#' See [https://www.paws-r-sdk.com/docs/qldb_stream_journal_to_kinesis/](https://www.paws-r-sdk.com/docs/qldb_stream_journal_to_kinesis/) for full documentation.
#'
#' @param LedgerName &#91;required&#93; The name of the ledger.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role that grants QLDB
#' permissions for a journal stream to write data records to a Kinesis Data
#' Streams resource.
#' 
#' To pass a role to QLDB when requesting a journal stream, you must have
#' permissions to perform the `iam:PassRole` action on the IAM role
#' resource. This is required for all journal stream requests.
#' @param Tags The key-value pairs to add as tags to the stream that you want to
#' create. Tag keys are case sensitive. Tag values are case sensitive and
#' can be null.
#' @param InclusiveStartTime &#91;required&#93; The inclusive start date and time from which to start streaming journal
#' data. This parameter must be in `ISO 8601` date and time format and in
#' Universal Coordinated Time (UTC). For example: `2019-06-13T21:36:34Z`.
#' 
#' The `InclusiveStartTime` cannot be in the future and must be before
#' `ExclusiveEndTime`.
#' 
#' If you provide an `InclusiveStartTime` that is before the ledger's
#' `CreationDateTime`, QLDB effectively defaults it to the ledger's
#' `CreationDateTime`.
#' @param ExclusiveEndTime The exclusive date and time that specifies when the stream ends. If you
#' don't define this parameter, the stream runs indefinitely until you
#' cancel it.
#' 
#' The `ExclusiveEndTime` must be in `ISO 8601` date and time format and in
#' Universal Coordinated Time (UTC). For example: `2019-06-13T21:36:34Z`.
#' @param KinesisConfiguration &#91;required&#93; The configuration settings of the Kinesis Data Streams destination for
#' your stream request.
#' @param StreamName &#91;required&#93; The name that you want to assign to the QLDB journal stream.
#' User-defined names can help identify and indicate the purpose of a
#' stream.
#' 
#' Your stream name must be unique among other *active* streams for a given
#' ledger. Stream names have the same naming constraints as ledger names,
#' as defined in [Quotas in Amazon
#' QLDB](https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming)
#' in the *Amazon QLDB Developer Guide*.
#'
#' @keywords internal
#'
#' @rdname qldb_stream_journal_to_kinesis
qldb_stream_journal_to_kinesis <- function(LedgerName, RoleArn, Tags = NULL, InclusiveStartTime, ExclusiveEndTime = NULL, KinesisConfiguration, StreamName) {
  op <- new_operation(
    name = "StreamJournalToKinesis",
    http_method = "POST",
    http_path = "/ledgers/{name}/journal-kinesis-streams",
    paginator = list()
  )
  input <- .qldb$stream_journal_to_kinesis_input(LedgerName = LedgerName, RoleArn = RoleArn, Tags = Tags, InclusiveStartTime = InclusiveStartTime, ExclusiveEndTime = ExclusiveEndTime, KinesisConfiguration = KinesisConfiguration, StreamName = StreamName)
  output <- .qldb$stream_journal_to_kinesis_output()
  config <- get_config()
  svc <- .qldb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.qldb$operations$stream_journal_to_kinesis <- qldb_stream_journal_to_kinesis

#' Adds one or more tags to a specified Amazon QLDB resource
#'
#' @description
#' Adds one or more tags to a specified Amazon QLDB resource.
#'
#' See [https://www.paws-r-sdk.com/docs/qldb_tag_resource/](https://www.paws-r-sdk.com/docs/qldb_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) to which you want to add the tags. For
#' example:
#' 
#' `arn:aws:qldb:us-east-1:123456789012:ledger/exampleLedger`
#' @param Tags &#91;required&#93; The key-value pairs to add as tags to the specified QLDB resource. Tag
#' keys are case sensitive. If you specify a key that already exists for
#' the resource, your request fails and returns an error. Tag values are
#' case sensitive and can be null.
#'
#' @keywords internal
#'
#' @rdname qldb_tag_resource
qldb_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .qldb$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .qldb$tag_resource_output()
  config <- get_config()
  svc <- .qldb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.qldb$operations$tag_resource <- qldb_tag_resource

#' Removes one or more tags from a specified Amazon QLDB resource
#'
#' @description
#' Removes one or more tags from a specified Amazon QLDB resource. You can specify up to 50 tag keys to remove.
#'
#' See [https://www.paws-r-sdk.com/docs/qldb_untag_resource/](https://www.paws-r-sdk.com/docs/qldb_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) from which to remove the tags. For
#' example:
#' 
#' `arn:aws:qldb:us-east-1:123456789012:ledger/exampleLedger`
#' @param TagKeys &#91;required&#93; The list of tag keys to remove.
#'
#' @keywords internal
#'
#' @rdname qldb_untag_resource
qldb_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .qldb$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .qldb$untag_resource_output()
  config <- get_config()
  svc <- .qldb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.qldb$operations$untag_resource <- qldb_untag_resource

#' Updates properties on a ledger
#'
#' @description
#' Updates properties on a ledger.
#'
#' See [https://www.paws-r-sdk.com/docs/qldb_update_ledger/](https://www.paws-r-sdk.com/docs/qldb_update_ledger/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the ledger.
#' @param DeletionProtection Specifies whether the ledger is protected from being deleted by any
#' user. If not defined during ledger creation, this feature is enabled
#' (`true`) by default.
#' 
#' If deletion protection is enabled, you must first disable it before you
#' can delete the ledger. You can disable it by calling the
#' [`update_ledger`][qldb_update_ledger] operation to set this parameter to
#' `false`.
#' @param KmsKey The key in Key Management Service (KMS) to use for encryption of data at
#' rest in the ledger. For more information, see [Encryption at
#' rest](https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html)
#' in the *Amazon QLDB Developer Guide*.
#' 
#' Use one of the following options to specify this parameter:
#' 
#' -   `AWS_OWNED_KMS_KEY`: Use an KMS key that is owned and managed by
#'     Amazon Web Services on your behalf.
#' 
#' -   **Undefined**: Make no changes to the KMS key of the ledger.
#' 
#' -   **A valid symmetric customer managed KMS key**: Use the specified
#'     symmetric encryption KMS key in your account that you create, own,
#'     and manage.
#' 
#'     Amazon QLDB does not support asymmetric keys. For more information,
#'     see [Using symmetric and asymmetric
#'     keys](https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html)
#'     in the *Key Management Service Developer Guide*.
#' 
#' To specify a customer managed KMS key, you can use its key ID, Amazon
#' Resource Name (ARN), alias name, or alias ARN. When using an alias name,
#' prefix it with `"alias/"`. To specify a key in a different Amazon Web
#' Services account, you must use the key ARN or alias ARN.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Alias name: `alias/ExampleAlias`
#' 
#' -   Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
#' 
#' For more information, see [Key identifiers
#' (KeyId)](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id)
#' in the *Key Management Service Developer Guide*.
#'
#' @keywords internal
#'
#' @rdname qldb_update_ledger
qldb_update_ledger <- function(Name, DeletionProtection = NULL, KmsKey = NULL) {
  op <- new_operation(
    name = "UpdateLedger",
    http_method = "PATCH",
    http_path = "/ledgers/{name}",
    paginator = list()
  )
  input <- .qldb$update_ledger_input(Name = Name, DeletionProtection = DeletionProtection, KmsKey = KmsKey)
  output <- .qldb$update_ledger_output()
  config <- get_config()
  svc <- .qldb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.qldb$operations$update_ledger <- qldb_update_ledger

#' Updates the permissions mode of a ledger
#'
#' @description
#' Updates the permissions mode of a ledger.
#'
#' See [https://www.paws-r-sdk.com/docs/qldb_update_ledger_permissions_mode/](https://www.paws-r-sdk.com/docs/qldb_update_ledger_permissions_mode/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the ledger.
#' @param PermissionsMode &#91;required&#93; The permissions mode to assign to the ledger. This parameter can have
#' one of the following values:
#' 
#' -   `ALLOW_ALL`: A legacy permissions mode that enables access control
#'     with API-level granularity for ledgers.
#' 
#'     This mode allows users who have the `SendCommand` API permission for
#'     this ledger to run all PartiQL commands (hence, `ALLOW_ALL`) on any
#'     tables in the specified ledger. This mode disregards any table-level
#'     or command-level IAM permissions policies that you create for the
#'     ledger.
#' 
#' -   `STANDARD`: (*Recommended*) A permissions mode that enables access
#'     control with finer granularity for ledgers, tables, and PartiQL
#'     commands.
#' 
#'     By default, this mode denies all user requests to run any PartiQL
#'     commands on any tables in this ledger. To allow PartiQL commands to
#'     run, you must create IAM permissions policies for specific table
#'     resources and PartiQL actions, in addition to the `SendCommand` API
#'     permission for the ledger. For information, see [Getting started
#'     with the standard permissions
#'     mode](https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-standard-mode.html)
#'     in the *Amazon QLDB Developer Guide*.
#' 
#' We strongly recommend using the `STANDARD` permissions mode to maximize
#' the security of your ledger data.
#'
#' @keywords internal
#'
#' @rdname qldb_update_ledger_permissions_mode
qldb_update_ledger_permissions_mode <- function(Name, PermissionsMode) {
  op <- new_operation(
    name = "UpdateLedgerPermissionsMode",
    http_method = "PATCH",
    http_path = "/ledgers/{name}/permissions-mode",
    paginator = list()
  )
  input <- .qldb$update_ledger_permissions_mode_input(Name = Name, PermissionsMode = PermissionsMode)
  output <- .qldb$update_ledger_permissions_mode_output()
  config <- get_config()
  svc <- .qldb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.qldb$operations$update_ledger_permissions_mode <- qldb_update_ledger_permissions_mode
