% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_create_custom_db_engine_version}
\alias{rds_create_custom_db_engine_version}
\title{Creates a custom DB engine version (CEV)}
\usage{
rds_create_custom_db_engine_version(
  Engine,
  EngineVersion,
  DatabaseInstallationFilesS3BucketName = NULL,
  DatabaseInstallationFilesS3Prefix = NULL,
  ImageId = NULL,
  KMSKeyId = NULL,
  Description = NULL,
  Manifest = NULL,
  Tags = NULL,
  SourceCustomDbEngineVersionIdentifier = NULL,
  UseAwsProvidedLatestImage = NULL
)
}
\arguments{
\item{Engine}{[required] The database engine to use for your custom engine version (CEV). The
only supported value is \code{custom-oracle-ee}.}

\item{EngineVersion}{[required] The name of your CEV. The name format is 19.\emph{customized_string}. For
example, a valid CEV name is \verb{19.my_cev1}. This setting is required for
RDS Custom for Oracle, but optional for Amazon RDS. The combination of
\code{Engine} and \code{EngineVersion} is unique per customer per Region.}

\item{DatabaseInstallationFilesS3BucketName}{The name of an Amazon S3 bucket that contains database installation
files for your CEV. For example, a valid bucket name is
\code{my-custom-installation-files}.}

\item{DatabaseInstallationFilesS3Prefix}{The Amazon S3 directory that contains the database installation files
for your CEV. For example, a valid bucket name is \code{123456789012/cev1}.
If this setting isn't specified, no prefix is assumed.}

\item{ImageId}{The ID of the Amazon Machine Image (AMI). For RDS Custom for SQL Server,
an AMI ID is required to create a CEV. For RDS Custom for Oracle, the
default is the most recent AMI available, but you can specify an AMI ID
that was used in a different Oracle CEV. Find the AMIs used by your CEVs
by calling the
\code{\link[=rds_describe_db_engine_versions]{describe_db_engine_versions}}
operation.}

\item{KMSKeyId}{The Amazon Web Services KMS key identifier for an encrypted CEV. A
symmetric encryption KMS key is required for RDS Custom, but optional
for Amazon RDS.

If you have an existing symmetric encryption KMS key in your account,
you can use it with RDS Custom. No further action is necessary. If you
don't already have a symmetric encryption KMS key in your account,
follow the instructions in \href{https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html#create-symmetric-cmk}{Creating a symmetric encryption KMS key}
in the \emph{Amazon Web Services Key Management Service Developer Guide}.

You can choose the same symmetric encryption key when you create a CEV
and a DB instance, or choose different keys.}

\item{Description}{An optional description of your CEV.}

\item{Manifest}{The CEV manifest, which is a JSON document that describes the
installation .zip files stored in Amazon S3. Specify the name/value
pairs in a file or a quoted string. RDS Custom applies the patches in
the order in which they are listed.

The following JSON fields are valid:

\strong{MediaImportTemplateVersion}

Version of the CEV manifest. The date is in the format \code{YYYY-MM-DD}.

\strong{databaseInstallationFileNames}

Ordered list of installation files for the CEV.

\strong{opatchFileNames}

Ordered list of OPatch installers used for the Oracle DB engine.

\strong{psuRuPatchFileNames}

The PSU and RU patches for this CEV.

\strong{OtherPatchFileNames}

The patches that are not in the list of PSU and RU patches. Amazon RDS
applies these patches after applying the PSU and RU patches.

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.preparing.manifest}{Creating the CEV manifest}
in the \emph{Amazon RDS User Guide}.}

\item{Tags}{}

\item{SourceCustomDbEngineVersionIdentifier}{Reserved for future use.}

\item{UseAwsProvidedLatestImage}{Reserved for future use.}
}
\description{
Creates a custom DB engine version (CEV).

See \url{https://www.paws-r-sdk.com/docs/rds_create_custom_db_engine_version/} for full documentation.
}
\keyword{internal}
