% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_create_db_proxy_endpoint}
\alias{rds_create_db_proxy_endpoint}
\title{Creates a DBProxyEndpoint}
\usage{
rds_create_db_proxy_endpoint(
  DBProxyName,
  DBProxyEndpointName,
  VpcSubnetIds,
  VpcSecurityGroupIds = NULL,
  TargetRole = NULL,
  Tags = NULL
)
}
\arguments{
\item{DBProxyName}{[required] The name of the DB proxy associated with the DB proxy endpoint that you
create.}

\item{DBProxyEndpointName}{[required] The name of the DB proxy endpoint to create.}

\item{VpcSubnetIds}{[required] The VPC subnet IDs for the DB proxy endpoint that you create. You can
specify a different set of subnet IDs than for the original DB proxy.}

\item{VpcSecurityGroupIds}{The VPC security group IDs for the DB proxy endpoint that you create.
You can specify a different set of security group IDs than for the
original DB proxy. The default is the default security group for the
VPC.}

\item{TargetRole}{The role of the DB proxy endpoint. The role determines whether the
endpoint can be used for read/write or only read operations. The default
is \code{READ_WRITE}. The only role that proxies for RDS for Microsoft SQL
Server support is \code{READ_WRITE}.}

\item{Tags}{}
}
\description{
Creates a \code{DBProxyEndpoint}. Only applies to proxies that are associated with Aurora DB clusters. You can use DB proxy endpoints to specify read/write or read-only access to the DB cluster. You can also use DB proxy endpoints to access a DB proxy through a different VPC than the proxy's default VPC.

See \url{https://www.paws-r-sdk.com/docs/rds_create_db_proxy_endpoint/} for full documentation.
}
\keyword{internal}
