# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include memorydb_service.R
NULL

#' Apply the service update to a list of clusters supplied
#'
#' @description
#' Apply the service update to a list of clusters supplied. For more information on service updates and applying them, see [Applying the service updates](https://docs.aws.amazon.com/memorydb/latest/devguide/managing-updates.html#applying-updates).
#'
#' See [https://www.paws-r-sdk.com/docs/memorydb_batch_update_cluster/](https://www.paws-r-sdk.com/docs/memorydb_batch_update_cluster/) for full documentation.
#'
#' @param ClusterNames &#91;required&#93; The cluster names to apply the updates.
#' @param ServiceUpdate The unique ID of the service update
#'
#' @keywords internal
#'
#' @rdname memorydb_batch_update_cluster
memorydb_batch_update_cluster <- function(ClusterNames, ServiceUpdate = NULL) {
  op <- new_operation(
    name = "BatchUpdateCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .memorydb$batch_update_cluster_input(ClusterNames = ClusterNames, ServiceUpdate = ServiceUpdate)
  output <- .memorydb$batch_update_cluster_output()
  config <- get_config()
  svc <- .memorydb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.memorydb$operations$batch_update_cluster <- memorydb_batch_update_cluster

#' Makes a copy of an existing snapshot
#'
#' @description
#' Makes a copy of an existing snapshot.
#'
#' See [https://www.paws-r-sdk.com/docs/memorydb_copy_snapshot/](https://www.paws-r-sdk.com/docs/memorydb_copy_snapshot/) for full documentation.
#'
#' @param SourceSnapshotName &#91;required&#93; The name of an existing snapshot from which to make a copy.
#' @param TargetSnapshotName &#91;required&#93; A name for the snapshot copy. MemoryDB does not permit overwriting a
#' snapshot, therefore this name must be unique within its context -
#' MemoryDB or an Amazon S3 bucket if exporting.
#' @param TargetBucket The Amazon S3 bucket to which the snapshot is exported. This parameter
#' is used only when exporting a snapshot for external access. When using
#' this parameter to export a snapshot, be sure MemoryDB has the needed
#' permissions to this S3 bucket. For more information, see [Step 2: Grant
#' MemoryDB Access to Your Amazon S3
#' Bucket](https://docs.aws.amazon.com/memorydb/latest/devguide/snapshots-exporting.html).
#' @param KmsKeyId The ID of the KMS key used to encrypt the target snapshot.
#' @param Tags A list of tags to be added to this resource. A tag is a key-value pair.
#' A tag key must be accompanied by a tag value, although null is accepted.
#'
#' @keywords internal
#'
#' @rdname memorydb_copy_snapshot
memorydb_copy_snapshot <- function(SourceSnapshotName, TargetSnapshotName, TargetBucket = NULL, KmsKeyId = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CopySnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .memorydb$copy_snapshot_input(SourceSnapshotName = SourceSnapshotName, TargetSnapshotName = TargetSnapshotName, TargetBucket = TargetBucket, KmsKeyId = KmsKeyId, Tags = Tags)
  output <- .memorydb$copy_snapshot_output()
  config <- get_config()
  svc <- .memorydb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.memorydb$operations$copy_snapshot <- memorydb_copy_snapshot

#' Creates an Access Control List
#'
#' @description
#' Creates an Access Control List. For more information, see [Authenticating users with Access Contol Lists (ACLs)](https://docs.aws.amazon.com/memorydb/latest/devguide/clusters.acls.html).
#'
#' See [https://www.paws-r-sdk.com/docs/memorydb_create_acl/](https://www.paws-r-sdk.com/docs/memorydb_create_acl/) for full documentation.
#'
#' @param ACLName &#91;required&#93; The name of the Access Control List.
#' @param UserNames The list of users that belong to the Access Control List.
#' @param Tags A list of tags to be added to this resource. A tag is a key-value pair.
#' A tag key must be accompanied by a tag value, although null is accepted.
#'
#' @keywords internal
#'
#' @rdname memorydb_create_acl
memorydb_create_acl <- function(ACLName, UserNames = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateACL",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .memorydb$create_acl_input(ACLName = ACLName, UserNames = UserNames, Tags = Tags)
  output <- .memorydb$create_acl_output()
  config <- get_config()
  svc <- .memorydb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.memorydb$operations$create_acl <- memorydb_create_acl

#' Creates a cluster
#'
#' @description
#' Creates a cluster. All nodes in the cluster run the same protocol-compliant engine software.
#'
#' See [https://www.paws-r-sdk.com/docs/memorydb_create_cluster/](https://www.paws-r-sdk.com/docs/memorydb_create_cluster/) for full documentation.
#'
#' @param ClusterName &#91;required&#93; The name of the cluster. This value must be unique as it also serves as
#' the cluster identifier.
#' @param NodeType &#91;required&#93; The compute and memory capacity of the nodes in the cluster.
#' @param ParameterGroupName The name of the parameter group associated with the cluster.
#' @param Description An optional description of the cluster.
#' @param NumShards The number of shards the cluster will contain. The default value is 1.
#' @param NumReplicasPerShard The number of replicas to apply to each shard. The default value is 1.
#' The maximum is 5.
#' @param SubnetGroupName The name of the subnet group to be used for the cluster.
#' @param SecurityGroupIds A list of security group names to associate with this cluster.
#' @param MaintenanceWindow Specifies the weekly time range during which maintenance on the cluster
#' is performed. It is specified as a range in the format
#' ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window
#' is a 60 minute period.
#' 
#' Valid values for `ddd` are:
#' 
#' -   `sun`
#' 
#' -   `mon`
#' 
#' -   `tue`
#' 
#' -   `wed`
#' 
#' -   `thu`
#' 
#' -   `fri`
#' 
#' -   `sat`
#' 
#' Example: `sun:23:00-mon:01:30`
#' @param Port The port number on which each of the nodes accepts connections.
#' @param SnsTopicArn The Amazon Resource Name (ARN) of the Amazon Simple Notification Service
#' (SNS) topic to which notifications are sent.
#' @param TLSEnabled A flag to enable in-transit encryption on the cluster.
#' @param KmsKeyId The ID of the KMS key used to encrypt the cluster.
#' @param SnapshotArns A list of Amazon Resource Names (ARN) that uniquely identify the RDB
#' snapshot files stored in Amazon S3. The snapshot files are used to
#' populate the new cluster. The Amazon S3 object name in the ARN cannot
#' contain any commas.
#' @param SnapshotName The name of a snapshot from which to restore data into the new cluster.
#' The snapshot status changes to restoring while the new cluster is being
#' created.
#' @param SnapshotRetentionLimit The number of days for which MemoryDB retains automatic snapshots before
#' deleting them. For example, if you set SnapshotRetentionLimit to 5, a
#' snapshot that was taken today is retained for 5 days before being
#' deleted.
#' @param Tags A list of tags to be added to this resource. Tags are comma-separated
#' key,value pairs (e.g. Key=myKey, Value=myKeyValue. You can include
#' multiple tags as shown following: Key=myKey, Value=myKeyValue
#' Key=mySecondKey, Value=mySecondKeyValue.
#' @param SnapshotWindow The daily time range (in UTC) during which MemoryDB begins taking a
#' daily snapshot of your shard.
#' 
#' Example: 05:00-09:00
#' 
#' If you do not specify this parameter, MemoryDB automatically chooses an
#' appropriate time range.
#' @param ACLName &#91;required&#93; The name of the Access Control List to associate with the cluster.
#' @param EngineVersion The version number of the Redis engine to be used for the cluster.
#' @param AutoMinorVersionUpgrade When set to true, the cluster will automatically receive minor engine
#' version upgrades after launch.
#' @param DataTiering Enables data tiering. Data tiering is only supported for clusters using
#' the r6gd node type. This parameter must be set when using r6gd nodes.
#' For more information, see [Data
#' tiering](https://docs.aws.amazon.com/memorydb/latest/devguide/data-tiering.html).
#'
#' @keywords internal
#'
#' @rdname memorydb_create_cluster
memorydb_create_cluster <- function(ClusterName, NodeType, ParameterGroupName = NULL, Description = NULL, NumShards = NULL, NumReplicasPerShard = NULL, SubnetGroupName = NULL, SecurityGroupIds = NULL, MaintenanceWindow = NULL, Port = NULL, SnsTopicArn = NULL, TLSEnabled = NULL, KmsKeyId = NULL, SnapshotArns = NULL, SnapshotName = NULL, SnapshotRetentionLimit = NULL, Tags = NULL, SnapshotWindow = NULL, ACLName, EngineVersion = NULL, AutoMinorVersionUpgrade = NULL, DataTiering = NULL) {
  op <- new_operation(
    name = "CreateCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .memorydb$create_cluster_input(ClusterName = ClusterName, NodeType = NodeType, ParameterGroupName = ParameterGroupName, Description = Description, NumShards = NumShards, NumReplicasPerShard = NumReplicasPerShard, SubnetGroupName = SubnetGroupName, SecurityGroupIds = SecurityGroupIds, MaintenanceWindow = MaintenanceWindow, Port = Port, SnsTopicArn = SnsTopicArn, TLSEnabled = TLSEnabled, KmsKeyId = KmsKeyId, SnapshotArns = SnapshotArns, SnapshotName = SnapshotName, SnapshotRetentionLimit = SnapshotRetentionLimit, Tags = Tags, SnapshotWindow = SnapshotWindow, ACLName = ACLName, EngineVersion = EngineVersion, AutoMinorVersionUpgrade = AutoMinorVersionUpgrade, DataTiering = DataTiering)
  output <- .memorydb$create_cluster_output()
  config <- get_config()
  svc <- .memorydb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.memorydb$operations$create_cluster <- memorydb_create_cluster

#' Creates a new MemoryDB parameter group
#'
#' @description
#' Creates a new MemoryDB parameter group. A parameter group is a collection of parameters and their values that are applied to all of the nodes in any cluster. For more information, see [Configuring engine parameters using parameter groups](https://docs.aws.amazon.com/memorydb/latest/devguide/parametergroups.html).
#'
#' See [https://www.paws-r-sdk.com/docs/memorydb_create_parameter_group/](https://www.paws-r-sdk.com/docs/memorydb_create_parameter_group/) for full documentation.
#'
#' @param ParameterGroupName &#91;required&#93; The name of the parameter group.
#' @param Family &#91;required&#93; The name of the parameter group family that the parameter group can be
#' used with.
#' @param Description An optional description of the parameter group.
#' @param Tags A list of tags to be added to this resource. A tag is a key-value pair.
#' A tag key must be accompanied by a tag value, although null is accepted.
#'
#' @keywords internal
#'
#' @rdname memorydb_create_parameter_group
memorydb_create_parameter_group <- function(ParameterGroupName, Family, Description = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .memorydb$create_parameter_group_input(ParameterGroupName = ParameterGroupName, Family = Family, Description = Description, Tags = Tags)
  output <- .memorydb$create_parameter_group_output()
  config <- get_config()
  svc <- .memorydb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.memorydb$operations$create_parameter_group <- memorydb_create_parameter_group

#' Creates a copy of an entire cluster at a specific moment in time
#'
#' @description
#' Creates a copy of an entire cluster at a specific moment in time.
#'
#' See [https://www.paws-r-sdk.com/docs/memorydb_create_snapshot/](https://www.paws-r-sdk.com/docs/memorydb_create_snapshot/) for full documentation.
#'
#' @param ClusterName &#91;required&#93; The snapshot is created from this cluster.
#' @param SnapshotName &#91;required&#93; A name for the snapshot being created.
#' @param KmsKeyId The ID of the KMS key used to encrypt the snapshot.
#' @param Tags A list of tags to be added to this resource. A tag is a key-value pair.
#' A tag key must be accompanied by a tag value, although null is accepted.
#'
#' @keywords internal
#'
#' @rdname memorydb_create_snapshot
memorydb_create_snapshot <- function(ClusterName, SnapshotName, KmsKeyId = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .memorydb$create_snapshot_input(ClusterName = ClusterName, SnapshotName = SnapshotName, KmsKeyId = KmsKeyId, Tags = Tags)
  output <- .memorydb$create_snapshot_output()
  config <- get_config()
  svc <- .memorydb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.memorydb$operations$create_snapshot <- memorydb_create_snapshot

#' Creates a subnet group
#'
#' @description
#' Creates a subnet group. A subnet group is a collection of subnets (typically private) that you can designate for your clusters running in an Amazon Virtual Private Cloud (VPC) environment. When you create a cluster in an Amazon VPC, you must specify a subnet group. MemoryDB uses that subnet group to choose a subnet and IP addresses within that subnet to associate with your nodes. For more information, see [Subnets and subnet groups](https://docs.aws.amazon.com/memorydb/latest/devguide/subnetgroups.html).
#'
#' See [https://www.paws-r-sdk.com/docs/memorydb_create_subnet_group/](https://www.paws-r-sdk.com/docs/memorydb_create_subnet_group/) for full documentation.
#'
#' @param SubnetGroupName &#91;required&#93; The name of the subnet group.
#' @param Description A description for the subnet group.
#' @param SubnetIds &#91;required&#93; A list of VPC subnet IDs for the subnet group.
#' @param Tags A list of tags to be added to this resource. A tag is a key-value pair.
#' A tag key must be accompanied by a tag value, although null is accepted.
#'
#' @keywords internal
#'
#' @rdname memorydb_create_subnet_group
memorydb_create_subnet_group <- function(SubnetGroupName, Description = NULL, SubnetIds, Tags = NULL) {
  op <- new_operation(
    name = "CreateSubnetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .memorydb$create_subnet_group_input(SubnetGroupName = SubnetGroupName, Description = Description, SubnetIds = SubnetIds, Tags = Tags)
  output <- .memorydb$create_subnet_group_output()
  config <- get_config()
  svc <- .memorydb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.memorydb$operations$create_subnet_group <- memorydb_create_subnet_group

#' Creates a MemoryDB user
#'
#' @description
#' Creates a MemoryDB user. For more information, see [Authenticating users with Access Contol Lists (ACLs)](https://docs.aws.amazon.com/memorydb/latest/devguide/clusters.acls.html).
#'
#' See [https://www.paws-r-sdk.com/docs/memorydb_create_user/](https://www.paws-r-sdk.com/docs/memorydb_create_user/) for full documentation.
#'
#' @param UserName &#91;required&#93; The name of the user. This value must be unique as it also serves as the
#' user identifier.
#' @param AuthenticationMode &#91;required&#93; Denotes the user's authentication properties, such as whether it
#' requires a password to authenticate.
#' @param AccessString &#91;required&#93; Access permissions string used for this user.
#' @param Tags A list of tags to be added to this resource. A tag is a key-value pair.
#' A tag key must be accompanied by a tag value, although null is accepted.
#'
#' @keywords internal
#'
#' @rdname memorydb_create_user
memorydb_create_user <- function(UserName, AuthenticationMode, AccessString, Tags = NULL) {
  op <- new_operation(
    name = "CreateUser",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .memorydb$create_user_input(UserName = UserName, AuthenticationMode = AuthenticationMode, AccessString = AccessString, Tags = Tags)
  output <- .memorydb$create_user_output()
  config <- get_config()
  svc <- .memorydb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.memorydb$operations$create_user <- memorydb_create_user

#' Deletes an Access Control List
#'
#' @description
#' Deletes an Access Control List. The ACL must first be disassociated from the cluster before it can be deleted. For more information, see [Authenticating users with Access Contol Lists (ACLs)](https://docs.aws.amazon.com/memorydb/latest/devguide/clusters.acls.html).
#'
#' See [https://www.paws-r-sdk.com/docs/memorydb_delete_acl/](https://www.paws-r-sdk.com/docs/memorydb_delete_acl/) for full documentation.
#'
#' @param ACLName &#91;required&#93; The name of the Access Control List to delete
#'
#' @keywords internal
#'
#' @rdname memorydb_delete_acl
memorydb_delete_acl <- function(ACLName) {
  op <- new_operation(
    name = "DeleteACL",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .memorydb$delete_acl_input(ACLName = ACLName)
  output <- .memorydb$delete_acl_output()
  config <- get_config()
  svc <- .memorydb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.memorydb$operations$delete_acl <- memorydb_delete_acl

#' Deletes a cluster
#'
#' @description
#' Deletes a cluster. It also deletes all associated nodes and node endpoints
#'
#' See [https://www.paws-r-sdk.com/docs/memorydb_delete_cluster/](https://www.paws-r-sdk.com/docs/memorydb_delete_cluster/) for full documentation.
#'
#' @param ClusterName &#91;required&#93; The name of the cluster to be deleted
#' @param FinalSnapshotName The user-supplied name of a final cluster snapshot. This is the unique
#' name that identifies the snapshot. MemoryDB creates the snapshot, and
#' then deletes the cluster immediately afterward.
#'
#' @keywords internal
#'
#' @rdname memorydb_delete_cluster
memorydb_delete_cluster <- function(ClusterName, FinalSnapshotName = NULL) {
  op <- new_operation(
    name = "DeleteCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .memorydb$delete_cluster_input(ClusterName = ClusterName, FinalSnapshotName = FinalSnapshotName)
  output <- .memorydb$delete_cluster_output()
  config <- get_config()
  svc <- .memorydb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.memorydb$operations$delete_cluster <- memorydb_delete_cluster

#' Deletes the specified parameter group
#'
#' @description
#' Deletes the specified parameter group. You cannot delete a parameter group if it is associated with any clusters. You cannot delete the default parameter groups in your account.
#'
#' See [https://www.paws-r-sdk.com/docs/memorydb_delete_parameter_group/](https://www.paws-r-sdk.com/docs/memorydb_delete_parameter_group/) for full documentation.
#'
#' @param ParameterGroupName &#91;required&#93; The name of the parameter group to delete.
#'
#' @keywords internal
#'
#' @rdname memorydb_delete_parameter_group
memorydb_delete_parameter_group <- function(ParameterGroupName) {
  op <- new_operation(
    name = "DeleteParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .memorydb$delete_parameter_group_input(ParameterGroupName = ParameterGroupName)
  output <- .memorydb$delete_parameter_group_output()
  config <- get_config()
  svc <- .memorydb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.memorydb$operations$delete_parameter_group <- memorydb_delete_parameter_group

#' Deletes an existing snapshot
#'
#' @description
#' Deletes an existing snapshot. When you receive a successful response from this operation, MemoryDB immediately begins deleting the snapshot; you cannot cancel or revert this operation.
#'
#' See [https://www.paws-r-sdk.com/docs/memorydb_delete_snapshot/](https://www.paws-r-sdk.com/docs/memorydb_delete_snapshot/) for full documentation.
#'
#' @param SnapshotName &#91;required&#93; The name of the snapshot to delete
#'
#' @keywords internal
#'
#' @rdname memorydb_delete_snapshot
memorydb_delete_snapshot <- function(SnapshotName) {
  op <- new_operation(
    name = "DeleteSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .memorydb$delete_snapshot_input(SnapshotName = SnapshotName)
  output <- .memorydb$delete_snapshot_output()
  config <- get_config()
  svc <- .memorydb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.memorydb$operations$delete_snapshot <- memorydb_delete_snapshot

#' Deletes a subnet group
#'
#' @description
#' Deletes a subnet group. You cannot delete a default subnet group or one that is associated with any clusters.
#'
#' See [https://www.paws-r-sdk.com/docs/memorydb_delete_subnet_group/](https://www.paws-r-sdk.com/docs/memorydb_delete_subnet_group/) for full documentation.
#'
#' @param SubnetGroupName &#91;required&#93; The name of the subnet group to delete
#'
#' @keywords internal
#'
#' @rdname memorydb_delete_subnet_group
memorydb_delete_subnet_group <- function(SubnetGroupName) {
  op <- new_operation(
    name = "DeleteSubnetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .memorydb$delete_subnet_group_input(SubnetGroupName = SubnetGroupName)
  output <- .memorydb$delete_subnet_group_output()
  config <- get_config()
  svc <- .memorydb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.memorydb$operations$delete_subnet_group <- memorydb_delete_subnet_group

#' Deletes a user
#'
#' @description
#' Deletes a user. The user will be removed from all ACLs and in turn removed from all clusters.
#'
#' See [https://www.paws-r-sdk.com/docs/memorydb_delete_user/](https://www.paws-r-sdk.com/docs/memorydb_delete_user/) for full documentation.
#'
#' @param UserName &#91;required&#93; The name of the user to delete
#'
#' @keywords internal
#'
#' @rdname memorydb_delete_user
memorydb_delete_user <- function(UserName) {
  op <- new_operation(
    name = "DeleteUser",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .memorydb$delete_user_input(UserName = UserName)
  output <- .memorydb$delete_user_output()
  config <- get_config()
  svc <- .memorydb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.memorydb$operations$delete_user <- memorydb_delete_user

#' Returns a list of ACLs
#'
#' @description
#' Returns a list of ACLs
#'
#' See [https://www.paws-r-sdk.com/docs/memorydb_describe_ac_ls/](https://www.paws-r-sdk.com/docs/memorydb_describe_ac_ls/) for full documentation.
#'
#' @param ACLName The name of the ACL
#' @param MaxResults The maximum number of records to include in the response. If more
#' records exist than the specified MaxResults value, a token is included
#' in the response so that the remaining results can be retrieved.
#' @param NextToken An optional argument to pass in case the total number of records exceeds
#' the value of MaxResults. If nextToken is returned, there are more
#' results available. The value of nextToken is a unique pagination token
#' for each page. Make the call again using the returned token to retrieve
#' the next page. Keep all other arguments unchanged.
#'
#' @keywords internal
#'
#' @rdname memorydb_describe_ac_ls
memorydb_describe_ac_ls <- function(ACLName = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeACLs",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "ACLs")
  )
  input <- .memorydb$describe_ac_ls_input(ACLName = ACLName, MaxResults = MaxResults, NextToken = NextToken)
  output <- .memorydb$describe_ac_ls_output()
  config <- get_config()
  svc <- .memorydb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.memorydb$operations$describe_ac_ls <- memorydb_describe_ac_ls

#' Returns information about all provisioned clusters if no cluster
#' identifier is specified, or about a specific cluster if a cluster name
#' is supplied
#'
#' @description
#' Returns information about all provisioned clusters if no cluster identifier is specified, or about a specific cluster if a cluster name is supplied.
#'
#' See [https://www.paws-r-sdk.com/docs/memorydb_describe_clusters/](https://www.paws-r-sdk.com/docs/memorydb_describe_clusters/) for full documentation.
#'
#' @param ClusterName The name of the cluster
#' @param MaxResults The maximum number of records to include in the response. If more
#' records exist than the specified MaxResults value, a token is included
#' in the response so that the remaining results can be retrieved.
#' @param NextToken An optional argument to pass in case the total number of records exceeds
#' the value of MaxResults. If nextToken is returned, there are more
#' results available. The value of nextToken is a unique pagination token
#' for each page. Make the call again using the returned token to retrieve
#' the next page. Keep all other arguments unchanged.
#' @param ShowShardDetails An optional flag that can be included in the request to retrieve
#' information about the individual shard(s).
#'
#' @keywords internal
#'
#' @rdname memorydb_describe_clusters
memorydb_describe_clusters <- function(ClusterName = NULL, MaxResults = NULL, NextToken = NULL, ShowShardDetails = NULL) {
  op <- new_operation(
    name = "DescribeClusters",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Clusters")
  )
  input <- .memorydb$describe_clusters_input(ClusterName = ClusterName, MaxResults = MaxResults, NextToken = NextToken, ShowShardDetails = ShowShardDetails)
  output <- .memorydb$describe_clusters_output()
  config <- get_config()
  svc <- .memorydb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.memorydb$operations$describe_clusters <- memorydb_describe_clusters

#' Returns a list of the available Redis engine versions
#'
#' @description
#' Returns a list of the available Redis engine versions.
#'
#' See [https://www.paws-r-sdk.com/docs/memorydb_describe_engine_versions/](https://www.paws-r-sdk.com/docs/memorydb_describe_engine_versions/) for full documentation.
#'
#' @param EngineVersion The Redis engine version
#' @param ParameterGroupFamily The name of a specific parameter group family to return details for.
#' @param MaxResults The maximum number of records to include in the response. If more
#' records exist than the specified MaxResults value, a token is included
#' in the response so that the remaining results can be retrieved.
#' @param NextToken An optional argument to pass in case the total number of records exceeds
#' the value of MaxResults. If nextToken is returned, there are more
#' results available. The value of nextToken is a unique pagination token
#' for each page. Make the call again using the returned token to retrieve
#' the next page. Keep all other arguments unchanged.
#' @param DefaultOnly If true, specifies that only the default version of the specified engine
#' or engine and major version combination is to be returned.
#'
#' @keywords internal
#'
#' @rdname memorydb_describe_engine_versions
memorydb_describe_engine_versions <- function(EngineVersion = NULL, ParameterGroupFamily = NULL, MaxResults = NULL, NextToken = NULL, DefaultOnly = NULL) {
  op <- new_operation(
    name = "DescribeEngineVersions",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "EngineVersions")
  )
  input <- .memorydb$describe_engine_versions_input(EngineVersion = EngineVersion, ParameterGroupFamily = ParameterGroupFamily, MaxResults = MaxResults, NextToken = NextToken, DefaultOnly = DefaultOnly)
  output <- .memorydb$describe_engine_versions_output()
  config <- get_config()
  svc <- .memorydb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.memorydb$operations$describe_engine_versions <- memorydb_describe_engine_versions

#' Returns events related to clusters, security groups, and parameter
#' groups
#'
#' @description
#' Returns events related to clusters, security groups, and parameter groups. You can obtain events specific to a particular cluster, security group, or parameter group by providing the name as a parameter. By default, only the events occurring within the last hour are returned; however, you can retrieve up to 14 days' worth of events if necessary.
#'
#' See [https://www.paws-r-sdk.com/docs/memorydb_describe_events/](https://www.paws-r-sdk.com/docs/memorydb_describe_events/) for full documentation.
#'
#' @param SourceName The identifier of the event source for which events are returned. If not
#' specified, all sources are included in the response.
#' @param SourceType The event source to retrieve events for. If no value is specified, all
#' events are returned.
#' @param StartTime The beginning of the time interval to retrieve events for, specified in
#' ISO 8601 format. Example: 2017-03-30T07:03:49.555Z
#' @param EndTime The end of the time interval for which to retrieve events, specified in
#' ISO 8601 format. Example: 2017-03-30T07:03:49.555Z
#' @param Duration The number of minutes worth of events to retrieve.
#' @param MaxResults The maximum number of records to include in the response. If more
#' records exist than the specified MaxResults value, a token is included
#' in the response so that the remaining results can be retrieved.
#' @param NextToken An optional argument to pass in case the total number of records exceeds
#' the value of MaxResults. If nextToken is returned, there are more
#' results available. The value of nextToken is a unique pagination token
#' for each page. Make the call again using the returned token to retrieve
#' the next page. Keep all other arguments unchanged.
#'
#' @keywords internal
#'
#' @rdname memorydb_describe_events
memorydb_describe_events <- function(SourceName = NULL, SourceType = NULL, StartTime = NULL, EndTime = NULL, Duration = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeEvents",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Events")
  )
  input <- .memorydb$describe_events_input(SourceName = SourceName, SourceType = SourceType, StartTime = StartTime, EndTime = EndTime, Duration = Duration, MaxResults = MaxResults, NextToken = NextToken)
  output <- .memorydb$describe_events_output()
  config <- get_config()
  svc <- .memorydb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.memorydb$operations$describe_events <- memorydb_describe_events

#' Returns a list of parameter group descriptions
#'
#' @description
#' Returns a list of parameter group descriptions. If a parameter group name is specified, the list contains only the descriptions for that group.
#'
#' See [https://www.paws-r-sdk.com/docs/memorydb_describe_parameter_groups/](https://www.paws-r-sdk.com/docs/memorydb_describe_parameter_groups/) for full documentation.
#'
#' @param ParameterGroupName The name of a specific parameter group to return details for.
#' @param MaxResults The maximum number of records to include in the response. If more
#' records exist than the specified MaxResults value, a token is included
#' in the response so that the remaining results can be retrieved.
#' @param NextToken An optional argument to pass in case the total number of records exceeds
#' the value of MaxResults. If nextToken is returned, there are more
#' results available. The value of nextToken is a unique pagination token
#' for each page. Make the call again using the returned token to retrieve
#' the next page. Keep all other arguments unchanged.
#'
#' @keywords internal
#'
#' @rdname memorydb_describe_parameter_groups
memorydb_describe_parameter_groups <- function(ParameterGroupName = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeParameterGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "ParameterGroups")
  )
  input <- .memorydb$describe_parameter_groups_input(ParameterGroupName = ParameterGroupName, MaxResults = MaxResults, NextToken = NextToken)
  output <- .memorydb$describe_parameter_groups_output()
  config <- get_config()
  svc <- .memorydb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.memorydb$operations$describe_parameter_groups <- memorydb_describe_parameter_groups

#' Returns the detailed parameter list for a particular parameter group
#'
#' @description
#' Returns the detailed parameter list for a particular parameter group.
#'
#' See [https://www.paws-r-sdk.com/docs/memorydb_describe_parameters/](https://www.paws-r-sdk.com/docs/memorydb_describe_parameters/) for full documentation.
#'
#' @param ParameterGroupName &#91;required&#93; he name of a specific parameter group to return details for.
#' @param MaxResults The maximum number of records to include in the response. If more
#' records exist than the specified MaxResults value, a token is included
#' in the response so that the remaining results can be retrieved.
#' @param NextToken An optional argument to pass in case the total number of records exceeds
#' the value of MaxResults. If nextToken is returned, there are more
#' results available. The value of nextToken is a unique pagination token
#' for each page. Make the call again using the returned token to retrieve
#' the next page. Keep all other arguments unchanged.
#'
#' @keywords internal
#'
#' @rdname memorydb_describe_parameters
memorydb_describe_parameters <- function(ParameterGroupName, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeParameters",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Parameters")
  )
  input <- .memorydb$describe_parameters_input(ParameterGroupName = ParameterGroupName, MaxResults = MaxResults, NextToken = NextToken)
  output <- .memorydb$describe_parameters_output()
  config <- get_config()
  svc <- .memorydb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.memorydb$operations$describe_parameters <- memorydb_describe_parameters

#' Returns information about reserved nodes for this account, or about a
#' specified reserved node
#'
#' @description
#' Returns information about reserved nodes for this account, or about a specified reserved node.
#'
#' See [https://www.paws-r-sdk.com/docs/memorydb_describe_reserved_nodes/](https://www.paws-r-sdk.com/docs/memorydb_describe_reserved_nodes/) for full documentation.
#'
#' @param ReservationId The reserved node identifier filter value. Use this parameter to show
#' only the reservation that matches the specified reservation ID.
#' @param ReservedNodesOfferingId The offering identifier filter value. Use this parameter to show only
#' purchased reservations matching the specified offering identifier.
#' @param NodeType The node type filter value. Use this parameter to show only those
#' reservations matching the specified node type. For more information, see
#' [Supported node
#' types](https://docs.aws.amazon.com/memorydb/latest/devguide/#reserved-nodes-supported).
#' @param Duration The duration filter value, specified in years or seconds. Use this
#' parameter to show only reservations for this duration.
#' @param OfferingType The offering type filter value. Use this parameter to show only the
#' available offerings matching the specified offering type. Valid values:
#' "All Upfront"|"Partial Upfront"| "No Upfront"
#' @param MaxResults The maximum number of records to include in the response. If more
#' records exist than the specified MaxRecords value, a marker is included
#' in the response so that the remaining results can be retrieved.
#' @param NextToken An optional marker returned from a prior request. Use this marker for
#' pagination of results from this operation. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by MaxRecords.
#'
#' @keywords internal
#'
#' @rdname memorydb_describe_reserved_nodes
memorydb_describe_reserved_nodes <- function(ReservationId = NULL, ReservedNodesOfferingId = NULL, NodeType = NULL, Duration = NULL, OfferingType = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeReservedNodes",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "ReservedNodes")
  )
  input <- .memorydb$describe_reserved_nodes_input(ReservationId = ReservationId, ReservedNodesOfferingId = ReservedNodesOfferingId, NodeType = NodeType, Duration = Duration, OfferingType = OfferingType, MaxResults = MaxResults, NextToken = NextToken)
  output <- .memorydb$describe_reserved_nodes_output()
  config <- get_config()
  svc <- .memorydb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.memorydb$operations$describe_reserved_nodes <- memorydb_describe_reserved_nodes

#' Lists available reserved node offerings
#'
#' @description
#' Lists available reserved node offerings.
#'
#' See [https://www.paws-r-sdk.com/docs/memorydb_describe_reserved_nodes_offerings/](https://www.paws-r-sdk.com/docs/memorydb_describe_reserved_nodes_offerings/) for full documentation.
#'
#' @param ReservedNodesOfferingId The offering identifier filter value. Use this parameter to show only
#' the available offering that matches the specified reservation
#' identifier.
#' @param NodeType The node type for the reserved nodes. For more information, see
#' [Supported node
#' types](https://docs.aws.amazon.com/memorydb/latest/devguide/#reserved-nodes-supported).
#' @param Duration Duration filter value, specified in years or seconds. Use this parameter
#' to show only reservations for a given duration.
#' @param OfferingType The offering type filter value. Use this parameter to show only the
#' available offerings matching the specified offering type. Valid values:
#' "All Upfront"|"Partial Upfront"| "No Upfront"
#' @param MaxResults The maximum number of records to include in the response. If more
#' records exist than the specified MaxRecords value, a marker is included
#' in the response so that the remaining results can be retrieved.
#' @param NextToken An optional marker returned from a prior request. Use this marker for
#' pagination of results from this operation. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by MaxRecords.
#'
#' @keywords internal
#'
#' @rdname memorydb_describe_reserved_nodes_offerings
memorydb_describe_reserved_nodes_offerings <- function(ReservedNodesOfferingId = NULL, NodeType = NULL, Duration = NULL, OfferingType = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeReservedNodesOfferings",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "ReservedNodesOfferings")
  )
  input <- .memorydb$describe_reserved_nodes_offerings_input(ReservedNodesOfferingId = ReservedNodesOfferingId, NodeType = NodeType, Duration = Duration, OfferingType = OfferingType, MaxResults = MaxResults, NextToken = NextToken)
  output <- .memorydb$describe_reserved_nodes_offerings_output()
  config <- get_config()
  svc <- .memorydb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.memorydb$operations$describe_reserved_nodes_offerings <- memorydb_describe_reserved_nodes_offerings

#' Returns details of the service updates
#'
#' @description
#' Returns details of the service updates
#'
#' See [https://www.paws-r-sdk.com/docs/memorydb_describe_service_updates/](https://www.paws-r-sdk.com/docs/memorydb_describe_service_updates/) for full documentation.
#'
#' @param ServiceUpdateName The unique ID of the service update to describe.
#' @param ClusterNames The list of cluster names to identify service updates to apply
#' @param Status The status(es) of the service updates to filter on
#' @param MaxResults The maximum number of records to include in the response. If more
#' records exist than the specified MaxResults value, a token is included
#' in the response so that the remaining results can be retrieved.
#' @param NextToken An optional argument to pass in case the total number of records exceeds
#' the value of MaxResults. If nextToken is returned, there are more
#' results available. The value of nextToken is a unique pagination token
#' for each page. Make the call again using the returned token to retrieve
#' the next page. Keep all other arguments unchanged.
#'
#' @keywords internal
#'
#' @rdname memorydb_describe_service_updates
memorydb_describe_service_updates <- function(ServiceUpdateName = NULL, ClusterNames = NULL, Status = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeServiceUpdates",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "ServiceUpdates")
  )
  input <- .memorydb$describe_service_updates_input(ServiceUpdateName = ServiceUpdateName, ClusterNames = ClusterNames, Status = Status, MaxResults = MaxResults, NextToken = NextToken)
  output <- .memorydb$describe_service_updates_output()
  config <- get_config()
  svc <- .memorydb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.memorydb$operations$describe_service_updates <- memorydb_describe_service_updates

#' Returns information about cluster snapshots
#'
#' @description
#' Returns information about cluster snapshots. By default, DescribeSnapshots lists all of your snapshots; it can optionally describe a single snapshot, or just the snapshots associated with a particular cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/memorydb_describe_snapshots/](https://www.paws-r-sdk.com/docs/memorydb_describe_snapshots/) for full documentation.
#'
#' @param ClusterName A user-supplied cluster identifier. If this parameter is specified, only
#' snapshots associated with that specific cluster are described.
#' @param SnapshotName A user-supplied name of the snapshot. If this parameter is specified,
#' only this named snapshot is described.
#' @param Source If set to system, the output shows snapshots that were automatically
#' created by MemoryDB. If set to user the output shows snapshots that were
#' manually created. If omitted, the output shows both automatically and
#' manually created snapshots.
#' @param NextToken An optional argument to pass in case the total number of records exceeds
#' the value of MaxResults. If nextToken is returned, there are more
#' results available. The value of nextToken is a unique pagination token
#' for each page. Make the call again using the returned token to retrieve
#' the next page. Keep all other arguments unchanged.
#' @param MaxResults The maximum number of records to include in the response. If more
#' records exist than the specified MaxResults value, a token is included
#' in the response so that the remaining results can be retrieved.
#' @param ShowDetail A Boolean value which if true, the shard configuration is included in
#' the snapshot description.
#'
#' @keywords internal
#'
#' @rdname memorydb_describe_snapshots
memorydb_describe_snapshots <- function(ClusterName = NULL, SnapshotName = NULL, Source = NULL, NextToken = NULL, MaxResults = NULL, ShowDetail = NULL) {
  op <- new_operation(
    name = "DescribeSnapshots",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Snapshots")
  )
  input <- .memorydb$describe_snapshots_input(ClusterName = ClusterName, SnapshotName = SnapshotName, Source = Source, NextToken = NextToken, MaxResults = MaxResults, ShowDetail = ShowDetail)
  output <- .memorydb$describe_snapshots_output()
  config <- get_config()
  svc <- .memorydb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.memorydb$operations$describe_snapshots <- memorydb_describe_snapshots

#' Returns a list of subnet group descriptions
#'
#' @description
#' Returns a list of subnet group descriptions. If a subnet group name is specified, the list contains only the description of that group.
#'
#' See [https://www.paws-r-sdk.com/docs/memorydb_describe_subnet_groups/](https://www.paws-r-sdk.com/docs/memorydb_describe_subnet_groups/) for full documentation.
#'
#' @param SubnetGroupName The name of the subnet group to return details for.
#' @param MaxResults The maximum number of records to include in the response. If more
#' records exist than the specified MaxResults value, a token is included
#' in the response so that the remaining results can be retrieved.
#' @param NextToken An optional argument to pass in case the total number of records exceeds
#' the value of MaxResults. If nextToken is returned, there are more
#' results available. The value of nextToken is a unique pagination token
#' for each page. Make the call again using the returned token to retrieve
#' the next page. Keep all other arguments unchanged.
#'
#' @keywords internal
#'
#' @rdname memorydb_describe_subnet_groups
memorydb_describe_subnet_groups <- function(SubnetGroupName = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeSubnetGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "SubnetGroups")
  )
  input <- .memorydb$describe_subnet_groups_input(SubnetGroupName = SubnetGroupName, MaxResults = MaxResults, NextToken = NextToken)
  output <- .memorydb$describe_subnet_groups_output()
  config <- get_config()
  svc <- .memorydb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.memorydb$operations$describe_subnet_groups <- memorydb_describe_subnet_groups

#' Returns a list of users
#'
#' @description
#' Returns a list of users.
#'
#' See [https://www.paws-r-sdk.com/docs/memorydb_describe_users/](https://www.paws-r-sdk.com/docs/memorydb_describe_users/) for full documentation.
#'
#' @param UserName The name of the user
#' @param Filters Filter to determine the list of users to return.
#' @param MaxResults The maximum number of records to include in the response. If more
#' records exist than the specified MaxResults value, a token is included
#' in the response so that the remaining results can be retrieved.
#' @param NextToken An optional argument to pass in case the total number of records exceeds
#' the value of MaxResults. If nextToken is returned, there are more
#' results available. The value of nextToken is a unique pagination token
#' for each page. Make the call again using the returned token to retrieve
#' the next page. Keep all other arguments unchanged.
#'
#' @keywords internal
#'
#' @rdname memorydb_describe_users
memorydb_describe_users <- function(UserName = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeUsers",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Users")
  )
  input <- .memorydb$describe_users_input(UserName = UserName, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .memorydb$describe_users_output()
  config <- get_config()
  svc <- .memorydb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.memorydb$operations$describe_users <- memorydb_describe_users

#' Used to failover a shard
#'
#' @description
#' Used to failover a shard. This API is designed for testing the behavior of your application in case of MemoryDB failover. It is not designed to be used as a production-level tool for initiating a failover to overcome a problem you may have with the cluster. Moreover, in certain conditions such as large scale operational events, Amazon may block this API.
#'
#' See [https://www.paws-r-sdk.com/docs/memorydb_failover_shard/](https://www.paws-r-sdk.com/docs/memorydb_failover_shard/) for full documentation.
#'
#' @param ClusterName &#91;required&#93; The cluster being failed over
#' @param ShardName &#91;required&#93; The name of the shard
#'
#' @keywords internal
#'
#' @rdname memorydb_failover_shard
memorydb_failover_shard <- function(ClusterName, ShardName) {
  op <- new_operation(
    name = "FailoverShard",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .memorydb$failover_shard_input(ClusterName = ClusterName, ShardName = ShardName)
  output <- .memorydb$failover_shard_output()
  config <- get_config()
  svc <- .memorydb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.memorydb$operations$failover_shard <- memorydb_failover_shard

#' Lists all available node types that you can scale to from your cluster's
#' current node type
#'
#' @description
#' Lists all available node types that you can scale to from your cluster's current node type. When you use the UpdateCluster operation to scale your cluster, the value of the NodeType parameter must be one of the node types returned by this operation.
#'
#' See [https://www.paws-r-sdk.com/docs/memorydb_list_allowed_node_type_updates/](https://www.paws-r-sdk.com/docs/memorydb_list_allowed_node_type_updates/) for full documentation.
#'
#' @param ClusterName &#91;required&#93; The name of the cluster you want to scale. MemoryDB uses the cluster
#' name to identify the current node type being used by this cluster, and
#' from that to create a list of node types you can scale up to.
#'
#' @keywords internal
#'
#' @rdname memorydb_list_allowed_node_type_updates
memorydb_list_allowed_node_type_updates <- function(ClusterName) {
  op <- new_operation(
    name = "ListAllowedNodeTypeUpdates",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .memorydb$list_allowed_node_type_updates_input(ClusterName = ClusterName)
  output <- .memorydb$list_allowed_node_type_updates_output()
  config <- get_config()
  svc <- .memorydb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.memorydb$operations$list_allowed_node_type_updates <- memorydb_list_allowed_node_type_updates

#' Lists all tags currently on a named resource
#'
#' @description
#' Lists all tags currently on a named resource. A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track your MemoryDB resources. For more information, see [Tagging your MemoryDB resources](https://docs.aws.amazon.com/memorydb/latest/devguide/)
#'
#' See [https://www.paws-r-sdk.com/docs/memorydb_list_tags/](https://www.paws-r-sdk.com/docs/memorydb_list_tags/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource for which you want the
#' list of tags
#'
#' @keywords internal
#'
#' @rdname memorydb_list_tags
memorydb_list_tags <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .memorydb$list_tags_input(ResourceArn = ResourceArn)
  output <- .memorydb$list_tags_output()
  config <- get_config()
  svc <- .memorydb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.memorydb$operations$list_tags <- memorydb_list_tags

#' Allows you to purchase a reserved node offering
#'
#' @description
#' Allows you to purchase a reserved node offering. Reserved nodes are not eligible for cancellation and are non-refundable.
#'
#' See [https://www.paws-r-sdk.com/docs/memorydb_purchase_reserved_nodes_offering/](https://www.paws-r-sdk.com/docs/memorydb_purchase_reserved_nodes_offering/) for full documentation.
#'
#' @param ReservedNodesOfferingId &#91;required&#93; The ID of the reserved node offering to purchase.
#' @param ReservationId A customer-specified identifier to track this reservation.
#' @param NodeCount The number of node instances to reserve.
#' @param Tags A list of tags to be added to this resource. A tag is a key-value pair.
#' A tag key must be accompanied by a tag value, although null is accepted.
#'
#' @keywords internal
#'
#' @rdname memorydb_purchase_reserved_nodes_offering
memorydb_purchase_reserved_nodes_offering <- function(ReservedNodesOfferingId, ReservationId = NULL, NodeCount = NULL, Tags = NULL) {
  op <- new_operation(
    name = "PurchaseReservedNodesOffering",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .memorydb$purchase_reserved_nodes_offering_input(ReservedNodesOfferingId = ReservedNodesOfferingId, ReservationId = ReservationId, NodeCount = NodeCount, Tags = Tags)
  output <- .memorydb$purchase_reserved_nodes_offering_output()
  config <- get_config()
  svc <- .memorydb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.memorydb$operations$purchase_reserved_nodes_offering <- memorydb_purchase_reserved_nodes_offering

#' Modifies the parameters of a parameter group to the engine or system
#' default value
#'
#' @description
#' Modifies the parameters of a parameter group to the engine or system default value. You can reset specific parameters by submitting a list of parameter names. To reset the entire parameter group, specify the AllParameters and ParameterGroupName parameters.
#'
#' See [https://www.paws-r-sdk.com/docs/memorydb_reset_parameter_group/](https://www.paws-r-sdk.com/docs/memorydb_reset_parameter_group/) for full documentation.
#'
#' @param ParameterGroupName &#91;required&#93; The name of the parameter group to reset.
#' @param AllParameters If true, all parameters in the parameter group are reset to their
#' default values. If false, only the parameters listed by ParameterNames
#' are reset to their default values.
#' @param ParameterNames An array of parameter names to reset to their default values. If
#' AllParameters is true, do not use ParameterNames. If AllParameters is
#' false, you must specify the name of at least one parameter to reset.
#'
#' @keywords internal
#'
#' @rdname memorydb_reset_parameter_group
memorydb_reset_parameter_group <- function(ParameterGroupName, AllParameters = NULL, ParameterNames = NULL) {
  op <- new_operation(
    name = "ResetParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .memorydb$reset_parameter_group_input(ParameterGroupName = ParameterGroupName, AllParameters = AllParameters, ParameterNames = ParameterNames)
  output <- .memorydb$reset_parameter_group_output()
  config <- get_config()
  svc <- .memorydb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.memorydb$operations$reset_parameter_group <- memorydb_reset_parameter_group

#' A tag is a key-value pair where the key and value are case-sensitive
#'
#' @description
#' A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track all your MemoryDB resources. When you add or remove tags on clusters, those actions will be replicated to all nodes in the cluster. For more information, see [Resource-level permissions](https://docs.aws.amazon.com/memorydb/latest/devguide/iam.resourcelevelpermissions.html).
#'
#' See [https://www.paws-r-sdk.com/docs/memorydb_tag_resource/](https://www.paws-r-sdk.com/docs/memorydb_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to which the tags are to
#' be added
#' @param Tags &#91;required&#93; A list of tags to be added to this resource. A tag is a key-value pair.
#' A tag key must be accompanied by a tag value, although null is accepted.
#'
#' @keywords internal
#'
#' @rdname memorydb_tag_resource
memorydb_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .memorydb$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .memorydb$tag_resource_output()
  config <- get_config()
  svc <- .memorydb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.memorydb$operations$tag_resource <- memorydb_tag_resource

#' Use this operation to remove tags on a resource
#'
#' @description
#' Use this operation to remove tags on a resource
#'
#' See [https://www.paws-r-sdk.com/docs/memorydb_untag_resource/](https://www.paws-r-sdk.com/docs/memorydb_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to which the tags are to
#' be removed
#' @param TagKeys &#91;required&#93; The list of keys of the tags that are to be removed
#'
#' @keywords internal
#'
#' @rdname memorydb_untag_resource
memorydb_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .memorydb$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .memorydb$untag_resource_output()
  config <- get_config()
  svc <- .memorydb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.memorydb$operations$untag_resource <- memorydb_untag_resource

#' Changes the list of users that belong to the Access Control List
#'
#' @description
#' Changes the list of users that belong to the Access Control List.
#'
#' See [https://www.paws-r-sdk.com/docs/memorydb_update_acl/](https://www.paws-r-sdk.com/docs/memorydb_update_acl/) for full documentation.
#'
#' @param ACLName &#91;required&#93; The name of the Access Control List
#' @param UserNamesToAdd The list of users to add to the Access Control List
#' @param UserNamesToRemove The list of users to remove from the Access Control List
#'
#' @keywords internal
#'
#' @rdname memorydb_update_acl
memorydb_update_acl <- function(ACLName, UserNamesToAdd = NULL, UserNamesToRemove = NULL) {
  op <- new_operation(
    name = "UpdateACL",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .memorydb$update_acl_input(ACLName = ACLName, UserNamesToAdd = UserNamesToAdd, UserNamesToRemove = UserNamesToRemove)
  output <- .memorydb$update_acl_output()
  config <- get_config()
  svc <- .memorydb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.memorydb$operations$update_acl <- memorydb_update_acl

#' Modifies the settings for a cluster
#'
#' @description
#' Modifies the settings for a cluster. You can use this operation to change one or more cluster configuration settings by specifying the settings and the new values.
#'
#' See [https://www.paws-r-sdk.com/docs/memorydb_update_cluster/](https://www.paws-r-sdk.com/docs/memorydb_update_cluster/) for full documentation.
#'
#' @param ClusterName &#91;required&#93; The name of the cluster to update
#' @param Description The description of the cluster to update
#' @param SecurityGroupIds The SecurityGroupIds to update
#' @param MaintenanceWindow Specifies the weekly time range during which maintenance on the cluster
#' is performed. It is specified as a range in the format
#' ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window
#' is a 60 minute period.
#' 
#' Valid values for `ddd` are:
#' 
#' -   `sun`
#' 
#' -   `mon`
#' 
#' -   `tue`
#' 
#' -   `wed`
#' 
#' -   `thu`
#' 
#' -   `fri`
#' 
#' -   `sat`
#' 
#' Example: `sun:23:00-mon:01:30`
#' @param SnsTopicArn The SNS topic ARN to update
#' @param SnsTopicStatus The status of the Amazon SNS notification topic. Notifications are sent
#' only if the status is active.
#' @param ParameterGroupName The name of the parameter group to update
#' @param SnapshotWindow The daily time range (in UTC) during which MemoryDB begins taking a
#' daily snapshot of your cluster.
#' @param SnapshotRetentionLimit The number of days for which MemoryDB retains automatic cluster
#' snapshots before deleting them. For example, if you set
#' SnapshotRetentionLimit to 5, a snapshot that was taken today is retained
#' for 5 days before being deleted.
#' @param NodeType A valid node type that you want to scale this cluster up or down to.
#' @param EngineVersion The upgraded version of the engine to be run on the nodes. You can
#' upgrade to a newer engine version, but you cannot downgrade to an
#' earlier engine version. If you want to use an earlier engine version,
#' you must delete the existing cluster and create it anew with the earlier
#' engine version.
#' @param ReplicaConfiguration The number of replicas that will reside in each shard
#' @param ShardConfiguration The number of shards in the cluster
#' @param ACLName The Access Control List that is associated with the cluster
#'
#' @keywords internal
#'
#' @rdname memorydb_update_cluster
memorydb_update_cluster <- function(ClusterName, Description = NULL, SecurityGroupIds = NULL, MaintenanceWindow = NULL, SnsTopicArn = NULL, SnsTopicStatus = NULL, ParameterGroupName = NULL, SnapshotWindow = NULL, SnapshotRetentionLimit = NULL, NodeType = NULL, EngineVersion = NULL, ReplicaConfiguration = NULL, ShardConfiguration = NULL, ACLName = NULL) {
  op <- new_operation(
    name = "UpdateCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .memorydb$update_cluster_input(ClusterName = ClusterName, Description = Description, SecurityGroupIds = SecurityGroupIds, MaintenanceWindow = MaintenanceWindow, SnsTopicArn = SnsTopicArn, SnsTopicStatus = SnsTopicStatus, ParameterGroupName = ParameterGroupName, SnapshotWindow = SnapshotWindow, SnapshotRetentionLimit = SnapshotRetentionLimit, NodeType = NodeType, EngineVersion = EngineVersion, ReplicaConfiguration = ReplicaConfiguration, ShardConfiguration = ShardConfiguration, ACLName = ACLName)
  output <- .memorydb$update_cluster_output()
  config <- get_config()
  svc <- .memorydb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.memorydb$operations$update_cluster <- memorydb_update_cluster

#' Updates the parameters of a parameter group
#'
#' @description
#' Updates the parameters of a parameter group. You can modify up to 20 parameters in a single request by submitting a list parameter name and value pairs.
#'
#' See [https://www.paws-r-sdk.com/docs/memorydb_update_parameter_group/](https://www.paws-r-sdk.com/docs/memorydb_update_parameter_group/) for full documentation.
#'
#' @param ParameterGroupName &#91;required&#93; The name of the parameter group to update.
#' @param ParameterNameValues &#91;required&#93; An array of parameter names and values for the parameter update. You
#' must supply at least one parameter name and value; subsequent arguments
#' are optional. A maximum of 20 parameters may be updated per request.
#'
#' @keywords internal
#'
#' @rdname memorydb_update_parameter_group
memorydb_update_parameter_group <- function(ParameterGroupName, ParameterNameValues) {
  op <- new_operation(
    name = "UpdateParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .memorydb$update_parameter_group_input(ParameterGroupName = ParameterGroupName, ParameterNameValues = ParameterNameValues)
  output <- .memorydb$update_parameter_group_output()
  config <- get_config()
  svc <- .memorydb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.memorydb$operations$update_parameter_group <- memorydb_update_parameter_group

#' Updates a subnet group
#'
#' @description
#' Updates a subnet group. For more information, see [Updating a subnet group](https://docs.aws.amazon.com/memorydb/latest/devguide/)
#'
#' See [https://www.paws-r-sdk.com/docs/memorydb_update_subnet_group/](https://www.paws-r-sdk.com/docs/memorydb_update_subnet_group/) for full documentation.
#'
#' @param SubnetGroupName &#91;required&#93; The name of the subnet group
#' @param Description A description of the subnet group
#' @param SubnetIds The EC2 subnet IDs for the subnet group.
#'
#' @keywords internal
#'
#' @rdname memorydb_update_subnet_group
memorydb_update_subnet_group <- function(SubnetGroupName, Description = NULL, SubnetIds = NULL) {
  op <- new_operation(
    name = "UpdateSubnetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .memorydb$update_subnet_group_input(SubnetGroupName = SubnetGroupName, Description = Description, SubnetIds = SubnetIds)
  output <- .memorydb$update_subnet_group_output()
  config <- get_config()
  svc <- .memorydb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.memorydb$operations$update_subnet_group <- memorydb_update_subnet_group

#' Changes user password(s) and/or access string
#'
#' @description
#' Changes user password(s) and/or access string.
#'
#' See [https://www.paws-r-sdk.com/docs/memorydb_update_user/](https://www.paws-r-sdk.com/docs/memorydb_update_user/) for full documentation.
#'
#' @param UserName &#91;required&#93; The name of the user
#' @param AuthenticationMode Denotes the user's authentication properties, such as whether it
#' requires a password to authenticate.
#' @param AccessString Access permissions string used for this user.
#'
#' @keywords internal
#'
#' @rdname memorydb_update_user
memorydb_update_user <- function(UserName, AuthenticationMode = NULL, AccessString = NULL) {
  op <- new_operation(
    name = "UpdateUser",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .memorydb$update_user_input(UserName = UserName, AuthenticationMode = AuthenticationMode, AccessString = AccessString)
  output <- .memorydb$update_user_output()
  config <- get_config()
  svc <- .memorydb$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.memorydb$operations$update_user <- memorydb_update_user
