% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshiftserverless_operations.R
\name{redshiftserverless_create_usage_limit}
\alias{redshiftserverless_create_usage_limit}
\title{Creates a usage limit for a specified Amazon Redshift Serverless usage
type}
\usage{
redshiftserverless_create_usage_limit(
  amount,
  breachAction = NULL,
  period = NULL,
  resourceArn,
  usageType
)
}
\arguments{
\item{amount}{[required] The limit amount. If time-based, this amount is in Redshift Processing
Units (RPU) consumed per hour. If data-based, this amount is in
terabytes (TB) of data transferred between Regions in cross-account
sharing. The value must be a positive number.}

\item{breachAction}{The action that Amazon Redshift Serverless takes when the limit is
reached. The default is log.}

\item{period}{The time period that the amount applies to. A weekly period begins on
Sunday. The default is monthly.}

\item{resourceArn}{[required] The Amazon Resource Name (ARN) of the Amazon Redshift Serverless
resource to create the usage limit for.}

\item{usageType}{[required] The type of Amazon Redshift Serverless usage to create a usage limit
for.}
}
\description{
Creates a usage limit for a specified Amazon Redshift Serverless usage type. The usage limit is identified by the returned usage limit identifier.

See \url{https://www.paws-r-sdk.com/docs/redshiftserverless_create_usage_limit/} for full documentation.
}
\keyword{internal}
