% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptunedata_operations.R
\name{neptunedata_start_ml_model_training_job}
\alias{neptunedata_start_ml_model_training_job}
\title{Creates a new Neptune ML model training job}
\usage{
neptunedata_start_ml_model_training_job(
  id = NULL,
  previousModelTrainingJobId = NULL,
  dataProcessingJobId,
  trainModelS3Location,
  sagemakerIamRoleArn = NULL,
  neptuneIamRoleArn = NULL,
  baseProcessingInstanceType = NULL,
  trainingInstanceType = NULL,
  trainingInstanceVolumeSizeInGB = NULL,
  trainingTimeOutInSeconds = NULL,
  maxHPONumberOfTrainingJobs = NULL,
  maxHPOParallelTrainingJobs = NULL,
  subnets = NULL,
  securityGroupIds = NULL,
  volumeEncryptionKMSKey = NULL,
  s3OutputEncryptionKMSKey = NULL,
  enableManagedSpotTraining = NULL,
  customModelTrainingParameters = NULL
)
}
\arguments{
\item{id}{A unique identifier for the new job. The default is An autogenerated
UUID.}

\item{previousModelTrainingJobId}{The job ID of a completed model-training job that you want to update
incrementally based on updated data.}

\item{dataProcessingJobId}{[required] The job ID of the completed data-processing job that has created the
data that the training will work with.}

\item{trainModelS3Location}{[required] The location in Amazon S3 where the model artifacts are to be stored.}

\item{sagemakerIamRoleArn}{The ARN of an IAM role for SageMaker execution.This must be listed in
your DB cluster parameter group or an error will occur.}

\item{neptuneIamRoleArn}{The ARN of an IAM role that provides Neptune access to SageMaker and
Amazon S3 resources. This must be listed in your DB cluster parameter
group or an error will occur.}

\item{baseProcessingInstanceType}{The type of ML instance used in preparing and managing training of ML
models. This is a CPU instance chosen based on memory requirements for
processing the training data and model.}

\item{trainingInstanceType}{The type of ML instance used for model training. All Neptune ML models
support CPU, GPU, and multiGPU training. The default is \code{ml.p3.2xlarge}.
Choosing the right instance type for training depends on the task type,
graph size, and your budget.}

\item{trainingInstanceVolumeSizeInGB}{The disk volume size of the training instance. Both input data and the
output model are stored on disk, so the volume size must be large enough
to hold both data sets. The default is 0. If not specified or 0, Neptune
ML selects a disk volume size based on the recommendation generated in
the data processing step.}

\item{trainingTimeOutInSeconds}{Timeout in seconds for the training job. The default is 86,400 (1 day).}

\item{maxHPONumberOfTrainingJobs}{Maximum total number of training jobs to start for the hyperparameter
tuning job. The default is 2. Neptune ML automatically tunes the
hyperparameters of the machine learning model. To obtain a model that
performs well, use at least 10 jobs (in other words, set
\code{maxHPONumberOfTrainingJobs} to 10). In general, the more tuning runs,
the better the results.}

\item{maxHPOParallelTrainingJobs}{Maximum number of parallel training jobs to start for the hyperparameter
tuning job. The default is 2. The number of parallel jobs you can run is
limited by the available resources on your training instance.}

\item{subnets}{The IDs of the subnets in the Neptune VPC. The default is None.}

\item{securityGroupIds}{The VPC security group IDs. The default is None.}

\item{volumeEncryptionKMSKey}{The Amazon Key Management Service (KMS) key that SageMaker uses to
encrypt data on the storage volume attached to the ML compute instances
that run the training job. The default is None.}

\item{s3OutputEncryptionKMSKey}{The Amazon Key Management Service (KMS) key that SageMaker uses to
encrypt the output of the processing job. The default is none.}

\item{enableManagedSpotTraining}{Optimizes the cost of training machine-learning models by using Amazon
Elastic Compute Cloud spot instances. The default is \code{False}.}

\item{customModelTrainingParameters}{The configuration for custom model training. This is a JSON object.}
}
\description{
Creates a new Neptune ML model training job. See \href{https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html}{Model training using the \code{modeltraining} command}.

See \url{https://www.paws-r-sdk.com/docs/neptunedata_start_ml_model_training_job/} for full documentation.
}
\keyword{internal}
