# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include workspaces_service.R
NULL

#' Associates the specified connection alias with the specified directory
#' to enable cross-Region redirection
#'
#' @description
#' Associates the specified connection alias with the specified directory
#' to enable cross-Region redirection. For more information, see
#' [Cross-Region Redirection for Amazon
#' WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
#' 
#' Before performing this operation, call
#' [DescribeConnectionAliases](https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html)
#' to make sure that the current state of the connection alias is
#' `CREATED`.
#'
#' @usage
#' workspaces_associate_connection_alias(AliasId, ResourceId)
#'
#' @param AliasId &#91;required&#93; The identifier of the connection alias.
#' @param ResourceId &#91;required&#93; The identifier of the directory to associate the connection alias with.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ConnectionIdentifier = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$associate_connection_alias(
#'   AliasId = "string",
#'   ResourceId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_associate_connection_alias
workspaces_associate_connection_alias <- function(AliasId, ResourceId) {
  op <- new_operation(
    name = "AssociateConnectionAlias",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$associate_connection_alias_input(AliasId = AliasId, ResourceId = ResourceId)
  output <- .workspaces$associate_connection_alias_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$associate_connection_alias <- workspaces_associate_connection_alias

#' Associates the specified IP access control group with the specified
#' directory
#'
#' @description
#' Associates the specified IP access control group with the specified
#' directory.
#'
#' @usage
#' workspaces_associate_ip_groups(DirectoryId, GroupIds)
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory.
#' @param GroupIds &#91;required&#93; The identifiers of one or more IP access control groups.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$associate_ip_groups(
#'   DirectoryId = "string",
#'   GroupIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_associate_ip_groups
workspaces_associate_ip_groups <- function(DirectoryId, GroupIds) {
  op <- new_operation(
    name = "AssociateIpGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$associate_ip_groups_input(DirectoryId = DirectoryId, GroupIds = GroupIds)
  output <- .workspaces$associate_ip_groups_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$associate_ip_groups <- workspaces_associate_ip_groups

#' Adds one or more rules to the specified IP access control group
#'
#' @description
#' Adds one or more rules to the specified IP access control group.
#' 
#' This action gives users permission to access their WorkSpaces from the
#' CIDR address ranges specified in the rules.
#'
#' @usage
#' workspaces_authorize_ip_rules(GroupId, UserRules)
#'
#' @param GroupId &#91;required&#93; The identifier of the group.
#' @param UserRules &#91;required&#93; The rules to add to the group.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$authorize_ip_rules(
#'   GroupId = "string",
#'   UserRules = list(
#'     list(
#'       ipRule = "string",
#'       ruleDesc = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_authorize_ip_rules
workspaces_authorize_ip_rules <- function(GroupId, UserRules) {
  op <- new_operation(
    name = "AuthorizeIpRules",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$authorize_ip_rules_input(GroupId = GroupId, UserRules = UserRules)
  output <- .workspaces$authorize_ip_rules_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$authorize_ip_rules <- workspaces_authorize_ip_rules

#' Copies the specified image from the specified Region to the current
#' Region
#'
#' @description
#' Copies the specified image from the specified Region to the current
#' Region. For more information about copying images, see [Copy a Custom
#' WorkSpaces
#' Image](https://docs.aws.amazon.com/workspaces/latest/adminguide/copy-custom-image.html).
#' 
#' In the China (Ningxia) Region, you can copy images only within the same
#' Region.
#' 
#' In the AWS GovCloud (US-West) Region, to copy images to and from other
#' AWS Regions, contact AWS Support.
#' 
#' Before copying a shared image, be sure to verify that it has been shared
#' from the correct AWS account. To determine if an image has been shared
#' and to see the AWS account ID that owns an image, use the
#' [DescribeWorkSpaceImages](https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImages.html)
#' and
#' [`describe_workspace_image_permissions`][workspaces_describe_workspace_image_permissions]
#' API operations.
#'
#' @usage
#' workspaces_copy_workspace_image(Name, Description, SourceImageId,
#'   SourceRegion, Tags)
#'
#' @param Name &#91;required&#93; The name of the image.
#' @param Description A description of the image.
#' @param SourceImageId &#91;required&#93; The identifier of the source image.
#' @param SourceRegion &#91;required&#93; The identifier of the source Region.
#' @param Tags The tags for the image.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ImageId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$copy_workspace_image(
#'   Name = "string",
#'   Description = "string",
#'   SourceImageId = "string",
#'   SourceRegion = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_copy_workspace_image
workspaces_copy_workspace_image <- function(Name, Description = NULL, SourceImageId, SourceRegion, Tags = NULL) {
  op <- new_operation(
    name = "CopyWorkspaceImage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$copy_workspace_image_input(Name = Name, Description = Description, SourceImageId = SourceImageId, SourceRegion = SourceRegion, Tags = Tags)
  output <- .workspaces$copy_workspace_image_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$copy_workspace_image <- workspaces_copy_workspace_image

#' Creates the specified connection alias for use with cross-Region
#' redirection
#'
#' @description
#' Creates the specified connection alias for use with cross-Region
#' redirection. For more information, see [Cross-Region Redirection for
#' Amazon
#' WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
#'
#' @usage
#' workspaces_create_connection_alias(ConnectionString, Tags)
#'
#' @param ConnectionString &#91;required&#93; A connection string in the form of a fully qualified domain name (FQDN),
#' such as `www.example.com`.
#' 
#' After you create a connection string, it is always associated to your
#' AWS account. You cannot recreate the same connection string with a
#' different account, even if you delete all instances of it from the
#' original account. The connection string is globally reserved for your
#' account.
#' @param Tags The tags to associate with the connection alias.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   AliasId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_connection_alias(
#'   ConnectionString = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_create_connection_alias
workspaces_create_connection_alias <- function(ConnectionString, Tags = NULL) {
  op <- new_operation(
    name = "CreateConnectionAlias",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$create_connection_alias_input(ConnectionString = ConnectionString, Tags = Tags)
  output <- .workspaces$create_connection_alias_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$create_connection_alias <- workspaces_create_connection_alias

#' Creates an IP access control group
#'
#' @description
#' Creates an IP access control group.
#' 
#' An IP access control group provides you with the ability to control the
#' IP addresses from which users are allowed to access their WorkSpaces. To
#' specify the CIDR address ranges, add rules to your IP access control
#' group and then associate the group with your directory. You can add
#' rules when you create the group or at any time using
#' [`authorize_ip_rules`][workspaces_authorize_ip_rules].
#' 
#' There is a default IP access control group associated with your
#' directory. If you don't associate an IP access control group with your
#' directory, the default group is used. The default group includes a
#' default rule that allows users to access their WorkSpaces from anywhere.
#' You cannot modify the default IP access control group for your
#' directory.
#'
#' @usage
#' workspaces_create_ip_group(GroupName, GroupDesc, UserRules, Tags)
#'
#' @param GroupName &#91;required&#93; The name of the group.
#' @param GroupDesc The description of the group.
#' @param UserRules The rules to add to the group.
#' @param Tags The tags. Each WorkSpaces resource can have a maximum of 50 tags.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   GroupId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_ip_group(
#'   GroupName = "string",
#'   GroupDesc = "string",
#'   UserRules = list(
#'     list(
#'       ipRule = "string",
#'       ruleDesc = "string"
#'     )
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_create_ip_group
workspaces_create_ip_group <- function(GroupName, GroupDesc = NULL, UserRules = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateIpGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$create_ip_group_input(GroupName = GroupName, GroupDesc = GroupDesc, UserRules = UserRules, Tags = Tags)
  output <- .workspaces$create_ip_group_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$create_ip_group <- workspaces_create_ip_group

#' Creates the specified tags for the specified WorkSpaces resource
#'
#' @description
#' Creates the specified tags for the specified WorkSpaces resource.
#'
#' @usage
#' workspaces_create_tags(ResourceId, Tags)
#'
#' @param ResourceId &#91;required&#93; The identifier of the WorkSpaces resource. The supported resource types
#' are WorkSpaces, registered directories, images, custom bundles, IP
#' access control groups, and connection aliases.
#' @param Tags &#91;required&#93; The tags. Each WorkSpaces resource can have a maximum of 50 tags.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$create_tags(
#'   ResourceId = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_create_tags
workspaces_create_tags <- function(ResourceId, Tags) {
  op <- new_operation(
    name = "CreateTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$create_tags_input(ResourceId = ResourceId, Tags = Tags)
  output <- .workspaces$create_tags_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$create_tags <- workspaces_create_tags

#' Creates one or more WorkSpaces
#'
#' @description
#' Creates one or more WorkSpaces.
#' 
#' This operation is asynchronous and returns before the WorkSpaces are
#' created.
#'
#' @usage
#' workspaces_create_workspaces(Workspaces)
#'
#' @param Workspaces &#91;required&#93; The WorkSpaces to create. You can specify up to 25 WorkSpaces.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   FailedRequests = list(
#'     list(
#'       WorkspaceRequest = list(
#'         DirectoryId = "string",
#'         UserName = "string",
#'         BundleId = "string",
#'         VolumeEncryptionKey = "string",
#'         UserVolumeEncryptionEnabled = TRUE|FALSE,
#'         RootVolumeEncryptionEnabled = TRUE|FALSE,
#'         WorkspaceProperties = list(
#'           RunningMode = "AUTO_STOP"|"ALWAYS_ON",
#'           RunningModeAutoStopTimeoutInMinutes = 123,
#'           RootVolumeSizeGib = 123,
#'           UserVolumeSizeGib = 123,
#'           ComputeTypeName = "VALUE"|"STANDARD"|"PERFORMANCE"|"POWER"|"GRAPHICS"|"POWERPRO"|"GRAPHICSPRO"
#'         ),
#'         Tags = list(
#'           list(
#'             Key = "string",
#'             Value = "string"
#'           )
#'         )
#'       ),
#'       ErrorCode = "string",
#'       ErrorMessage = "string"
#'     )
#'   ),
#'   PendingRequests = list(
#'     list(
#'       WorkspaceId = "string",
#'       DirectoryId = "string",
#'       UserName = "string",
#'       IpAddress = "string",
#'       State = "PENDING"|"AVAILABLE"|"IMPAIRED"|"UNHEALTHY"|"REBOOTING"|"STARTING"|"REBUILDING"|"RESTORING"|"MAINTENANCE"|"ADMIN_MAINTENANCE"|"TERMINATING"|"TERMINATED"|"SUSPENDED"|"UPDATING"|"STOPPING"|"STOPPED"|"ERROR",
#'       BundleId = "string",
#'       SubnetId = "string",
#'       ErrorMessage = "string",
#'       ErrorCode = "string",
#'       ComputerName = "string",
#'       VolumeEncryptionKey = "string",
#'       UserVolumeEncryptionEnabled = TRUE|FALSE,
#'       RootVolumeEncryptionEnabled = TRUE|FALSE,
#'       WorkspaceProperties = list(
#'         RunningMode = "AUTO_STOP"|"ALWAYS_ON",
#'         RunningModeAutoStopTimeoutInMinutes = 123,
#'         RootVolumeSizeGib = 123,
#'         UserVolumeSizeGib = 123,
#'         ComputeTypeName = "VALUE"|"STANDARD"|"PERFORMANCE"|"POWER"|"GRAPHICS"|"POWERPRO"|"GRAPHICSPRO"
#'       ),
#'       ModificationStates = list(
#'         list(
#'           Resource = "ROOT_VOLUME"|"USER_VOLUME"|"COMPUTE_TYPE",
#'           State = "UPDATE_INITIATED"|"UPDATE_IN_PROGRESS"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_workspaces(
#'   Workspaces = list(
#'     list(
#'       DirectoryId = "string",
#'       UserName = "string",
#'       BundleId = "string",
#'       VolumeEncryptionKey = "string",
#'       UserVolumeEncryptionEnabled = TRUE|FALSE,
#'       RootVolumeEncryptionEnabled = TRUE|FALSE,
#'       WorkspaceProperties = list(
#'         RunningMode = "AUTO_STOP"|"ALWAYS_ON",
#'         RunningModeAutoStopTimeoutInMinutes = 123,
#'         RootVolumeSizeGib = 123,
#'         UserVolumeSizeGib = 123,
#'         ComputeTypeName = "VALUE"|"STANDARD"|"PERFORMANCE"|"POWER"|"GRAPHICS"|"POWERPRO"|"GRAPHICSPRO"
#'       ),
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_create_workspaces
workspaces_create_workspaces <- function(Workspaces) {
  op <- new_operation(
    name = "CreateWorkspaces",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$create_workspaces_input(Workspaces = Workspaces)
  output <- .workspaces$create_workspaces_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$create_workspaces <- workspaces_create_workspaces

#' Deletes the specified connection alias
#'
#' @description
#' Deletes the specified connection alias. For more information, see
#' [Cross-Region Redirection for Amazon
#' WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
#' 
#' **If you will no longer be using a fully qualified domain name (FQDN) as
#' the registration code for your WorkSpaces users, you must take certain
#' precautions to prevent potential security issues.** For more
#' information, see [Security Considerations if You Stop Using Cross-Region
#' Redirection](https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html#cross-region-redirection-security-considerations).
#' 
#' To delete a connection alias that has been shared, the shared account
#' must first disassociate the connection alias from any directories it has
#' been associated with. Then you must unshare the connection alias from
#' the account it has been shared with. You can delete a connection alias
#' only after it is no longer shared with any accounts or associated with
#' any directories.
#'
#' @usage
#' workspaces_delete_connection_alias(AliasId)
#'
#' @param AliasId &#91;required&#93; The identifier of the connection alias to delete.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_connection_alias(
#'   AliasId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_delete_connection_alias
workspaces_delete_connection_alias <- function(AliasId) {
  op <- new_operation(
    name = "DeleteConnectionAlias",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$delete_connection_alias_input(AliasId = AliasId)
  output <- .workspaces$delete_connection_alias_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$delete_connection_alias <- workspaces_delete_connection_alias

#' Deletes the specified IP access control group
#'
#' @description
#' Deletes the specified IP access control group.
#' 
#' You cannot delete an IP access control group that is associated with a
#' directory.
#'
#' @usage
#' workspaces_delete_ip_group(GroupId)
#'
#' @param GroupId &#91;required&#93; The identifier of the IP access control group.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_ip_group(
#'   GroupId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_delete_ip_group
workspaces_delete_ip_group <- function(GroupId) {
  op <- new_operation(
    name = "DeleteIpGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$delete_ip_group_input(GroupId = GroupId)
  output <- .workspaces$delete_ip_group_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$delete_ip_group <- workspaces_delete_ip_group

#' Deletes the specified tags from the specified WorkSpaces resource
#'
#' @description
#' Deletes the specified tags from the specified WorkSpaces resource.
#'
#' @usage
#' workspaces_delete_tags(ResourceId, TagKeys)
#'
#' @param ResourceId &#91;required&#93; The identifier of the WorkSpaces resource. The supported resource types
#' are WorkSpaces, registered directories, images, custom bundles, IP
#' access control groups, and connection aliases.
#' @param TagKeys &#91;required&#93; The tag keys.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_tags(
#'   ResourceId = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_delete_tags
workspaces_delete_tags <- function(ResourceId, TagKeys) {
  op <- new_operation(
    name = "DeleteTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$delete_tags_input(ResourceId = ResourceId, TagKeys = TagKeys)
  output <- .workspaces$delete_tags_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$delete_tags <- workspaces_delete_tags

#' Deletes the specified image from your account
#'
#' @description
#' Deletes the specified image from your account. To delete an image, you
#' must first delete any bundles that are associated with the image and
#' unshare the image if it is shared with other accounts.
#'
#' @usage
#' workspaces_delete_workspace_image(ImageId)
#'
#' @param ImageId &#91;required&#93; The identifier of the image.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_workspace_image(
#'   ImageId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_delete_workspace_image
workspaces_delete_workspace_image <- function(ImageId) {
  op <- new_operation(
    name = "DeleteWorkspaceImage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$delete_workspace_image_input(ImageId = ImageId)
  output <- .workspaces$delete_workspace_image_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$delete_workspace_image <- workspaces_delete_workspace_image

#' Deregisters the specified directory
#'
#' @description
#' Deregisters the specified directory. This operation is asynchronous and
#' returns before the WorkSpace directory is deregistered. If any
#' WorkSpaces are registered to this directory, you must remove them before
#' you can deregister the directory.
#' 
#' Simple AD and AD Connector are made available to you free of charge to
#' use with WorkSpaces. If there are no WorkSpaces being used with your
#' Simple AD or AD Connector directory for 30 consecutive days, this
#' directory will be automatically deregistered for use with Amazon
#' WorkSpaces, and you will be charged for this directory as per the [AWS
#' Directory Services pricing
#' terms](https://aws.amazon.com/directoryservice/pricing/).
#' 
#' To delete empty directories, see [Delete the Directory for Your
#' WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/delete-workspaces-directory.html).
#' If you delete your Simple AD or AD Connector directory, you can always
#' create a new one when you want to start using WorkSpaces again.
#'
#' @usage
#' workspaces_deregister_workspace_directory(DirectoryId)
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory. If any WorkSpaces are registered to
#' this directory, you must remove them before you deregister the
#' directory, or you will receive an OperationNotSupportedException error.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$deregister_workspace_directory(
#'   DirectoryId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_deregister_workspace_directory
workspaces_deregister_workspace_directory <- function(DirectoryId) {
  op <- new_operation(
    name = "DeregisterWorkspaceDirectory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$deregister_workspace_directory_input(DirectoryId = DirectoryId)
  output <- .workspaces$deregister_workspace_directory_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$deregister_workspace_directory <- workspaces_deregister_workspace_directory

#' Retrieves a list that describes the configuration of Bring Your Own
#' License (BYOL) for the specified account
#'
#' @description
#' Retrieves a list that describes the configuration of Bring Your Own
#' License (BYOL) for the specified account.
#'
#' @usage
#' workspaces_describe_account()
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   DedicatedTenancySupport = "ENABLED"|"DISABLED",
#'   DedicatedTenancyManagementCidrRange = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_account()
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_describe_account
workspaces_describe_account <- function() {
  op <- new_operation(
    name = "DescribeAccount",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$describe_account_input()
  output <- .workspaces$describe_account_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$describe_account <- workspaces_describe_account

#' Retrieves a list that describes modifications to the configuration of
#' Bring Your Own License (BYOL) for the specified account
#'
#' @description
#' Retrieves a list that describes modifications to the configuration of
#' Bring Your Own License (BYOL) for the specified account.
#'
#' @usage
#' workspaces_describe_account_modifications(NextToken)
#'
#' @param NextToken If you received a `NextToken` from a previous call that was paginated,
#' provide this token to receive the next set of results.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   AccountModifications = list(
#'     list(
#'       ModificationState = "PENDING"|"COMPLETED"|"FAILED",
#'       DedicatedTenancySupport = "ENABLED"|"DISABLED",
#'       DedicatedTenancyManagementCidrRange = "string",
#'       StartTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       ErrorCode = "string",
#'       ErrorMessage = "string"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_account_modifications(
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_describe_account_modifications
workspaces_describe_account_modifications <- function(NextToken = NULL) {
  op <- new_operation(
    name = "DescribeAccountModifications",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$describe_account_modifications_input(NextToken = NextToken)
  output <- .workspaces$describe_account_modifications_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$describe_account_modifications <- workspaces_describe_account_modifications

#' Retrieves a list that describes one or more specified Amazon WorkSpaces
#' clients
#'
#' @description
#' Retrieves a list that describes one or more specified Amazon WorkSpaces
#' clients.
#'
#' @usage
#' workspaces_describe_client_properties(ResourceIds)
#'
#' @param ResourceIds &#91;required&#93; The resource identifier, in the form of directory IDs.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ClientPropertiesList = list(
#'     list(
#'       ResourceId = "string",
#'       ClientProperties = list(
#'         ReconnectEnabled = "ENABLED"|"DISABLED"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_client_properties(
#'   ResourceIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_describe_client_properties
workspaces_describe_client_properties <- function(ResourceIds) {
  op <- new_operation(
    name = "DescribeClientProperties",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$describe_client_properties_input(ResourceIds = ResourceIds)
  output <- .workspaces$describe_client_properties_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$describe_client_properties <- workspaces_describe_client_properties

#' Describes the permissions that the owner of a connection alias has
#' granted to another AWS account for the specified connection alias
#'
#' @description
#' Describes the permissions that the owner of a connection alias has
#' granted to another AWS account for the specified connection alias. For
#' more information, see [Cross-Region Redirection for Amazon
#' WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
#'
#' @usage
#' workspaces_describe_connection_alias_permissions(AliasId, NextToken,
#'   MaxResults)
#'
#' @param AliasId &#91;required&#93; The identifier of the connection alias.
#' @param NextToken If you received a `NextToken` from a previous call that was paginated,
#' provide this token to receive the next set of results.
#' @param MaxResults The maximum number of results to return.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   AliasId = "string",
#'   ConnectionAliasPermissions = list(
#'     list(
#'       SharedAccountId = "string",
#'       AllowAssociation = TRUE|FALSE
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_connection_alias_permissions(
#'   AliasId = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_describe_connection_alias_permissions
workspaces_describe_connection_alias_permissions <- function(AliasId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeConnectionAliasPermissions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$describe_connection_alias_permissions_input(AliasId = AliasId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .workspaces$describe_connection_alias_permissions_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$describe_connection_alias_permissions <- workspaces_describe_connection_alias_permissions

#' Retrieves a list that describes the connection aliases used for
#' cross-Region redirection
#'
#' @description
#' Retrieves a list that describes the connection aliases used for
#' cross-Region redirection. For more information, see [Cross-Region
#' Redirection for Amazon
#' WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
#'
#' @usage
#' workspaces_describe_connection_aliases(AliasIds, ResourceId, Limit,
#'   NextToken)
#'
#' @param AliasIds The identifiers of the connection aliases to describe.
#' @param ResourceId The identifier of the directory associated with the connection alias.
#' @param Limit The maximum number of connection aliases to return.
#' @param NextToken If you received a `NextToken` from a previous call that was paginated,
#' provide this token to receive the next set of results.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ConnectionAliases = list(
#'     list(
#'       ConnectionString = "string",
#'       AliasId = "string",
#'       State = "CREATING"|"CREATED"|"DELETING",
#'       OwnerAccountId = "string",
#'       Associations = list(
#'         list(
#'           AssociationStatus = "NOT_ASSOCIATED"|"ASSOCIATED_WITH_OWNER_ACCOUNT"|"ASSOCIATED_WITH_SHARED_ACCOUNT"|"PENDING_ASSOCIATION"|"PENDING_DISASSOCIATION",
#'           AssociatedAccountId = "string",
#'           ResourceId = "string",
#'           ConnectionIdentifier = "string"
#'         )
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_connection_aliases(
#'   AliasIds = list(
#'     "string"
#'   ),
#'   ResourceId = "string",
#'   Limit = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_describe_connection_aliases
workspaces_describe_connection_aliases <- function(AliasIds = NULL, ResourceId = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeConnectionAliases",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$describe_connection_aliases_input(AliasIds = AliasIds, ResourceId = ResourceId, Limit = Limit, NextToken = NextToken)
  output <- .workspaces$describe_connection_aliases_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$describe_connection_aliases <- workspaces_describe_connection_aliases

#' Describes one or more of your IP access control groups
#'
#' @description
#' Describes one or more of your IP access control groups.
#'
#' @usage
#' workspaces_describe_ip_groups(GroupIds, NextToken, MaxResults)
#'
#' @param GroupIds The identifiers of one or more IP access control groups.
#' @param NextToken If you received a `NextToken` from a previous call that was paginated,
#' provide this token to receive the next set of results.
#' @param MaxResults The maximum number of items to return.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Result = list(
#'     list(
#'       groupId = "string",
#'       groupName = "string",
#'       groupDesc = "string",
#'       userRules = list(
#'         list(
#'           ipRule = "string",
#'           ruleDesc = "string"
#'         )
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_ip_groups(
#'   GroupIds = list(
#'     "string"
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_describe_ip_groups
workspaces_describe_ip_groups <- function(GroupIds = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeIpGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$describe_ip_groups_input(GroupIds = GroupIds, NextToken = NextToken, MaxResults = MaxResults)
  output <- .workspaces$describe_ip_groups_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$describe_ip_groups <- workspaces_describe_ip_groups

#' Describes the specified tags for the specified WorkSpaces resource
#'
#' @description
#' Describes the specified tags for the specified WorkSpaces resource.
#'
#' @usage
#' workspaces_describe_tags(ResourceId)
#'
#' @param ResourceId &#91;required&#93; The identifier of the WorkSpaces resource. The supported resource types
#' are WorkSpaces, registered directories, images, custom bundles, IP
#' access control groups, and connection aliases.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TagList = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_tags(
#'   ResourceId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_describe_tags
workspaces_describe_tags <- function(ResourceId) {
  op <- new_operation(
    name = "DescribeTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$describe_tags_input(ResourceId = ResourceId)
  output <- .workspaces$describe_tags_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$describe_tags <- workspaces_describe_tags

#' Retrieves a list that describes the available WorkSpace bundles
#'
#' @description
#' Retrieves a list that describes the available WorkSpace bundles.
#' 
#' You can filter the results using either bundle ID or owner, but not
#' both.
#'
#' @usage
#' workspaces_describe_workspace_bundles(BundleIds, Owner, NextToken)
#'
#' @param BundleIds The identifiers of the bundles. You cannot combine this parameter with
#' any other filter.
#' @param Owner The owner of the bundles. You cannot combine this parameter with any
#' other filter.
#' 
#' Specify `AMAZON` to describe the bundles provided by AWS or null to
#' describe the bundles that belong to your account.
#' @param NextToken The token for the next set of results. (You received this token from a
#' previous call.)
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Bundles = list(
#'     list(
#'       BundleId = "string",
#'       Name = "string",
#'       Owner = "string",
#'       Description = "string",
#'       ImageId = "string",
#'       RootStorage = list(
#'         Capacity = "string"
#'       ),
#'       UserStorage = list(
#'         Capacity = "string"
#'       ),
#'       ComputeType = list(
#'         Name = "VALUE"|"STANDARD"|"PERFORMANCE"|"POWER"|"GRAPHICS"|"POWERPRO"|"GRAPHICSPRO"
#'       ),
#'       LastUpdatedTime = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_workspace_bundles(
#'   BundleIds = list(
#'     "string"
#'   ),
#'   Owner = "string",
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_describe_workspace_bundles
workspaces_describe_workspace_bundles <- function(BundleIds = NULL, Owner = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeWorkspaceBundles",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$describe_workspace_bundles_input(BundleIds = BundleIds, Owner = Owner, NextToken = NextToken)
  output <- .workspaces$describe_workspace_bundles_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$describe_workspace_bundles <- workspaces_describe_workspace_bundles

#' Describes the available directories that are registered with Amazon
#' WorkSpaces
#'
#' @description
#' Describes the available directories that are registered with Amazon
#' WorkSpaces.
#'
#' @usage
#' workspaces_describe_workspace_directories(DirectoryIds, Limit,
#'   NextToken)
#'
#' @param DirectoryIds The identifiers of the directories. If the value is null, all
#' directories are retrieved.
#' @param Limit The maximum number of directories to return.
#' @param NextToken If you received a `NextToken` from a previous call that was paginated,
#' provide this token to receive the next set of results.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Directories = list(
#'     list(
#'       DirectoryId = "string",
#'       Alias = "string",
#'       DirectoryName = "string",
#'       RegistrationCode = "string",
#'       SubnetIds = list(
#'         "string"
#'       ),
#'       DnsIpAddresses = list(
#'         "string"
#'       ),
#'       CustomerUserName = "string",
#'       IamRoleId = "string",
#'       DirectoryType = "SIMPLE_AD"|"AD_CONNECTOR",
#'       WorkspaceSecurityGroupId = "string",
#'       State = "REGISTERING"|"REGISTERED"|"DEREGISTERING"|"DEREGISTERED"|"ERROR",
#'       WorkspaceCreationProperties = list(
#'         EnableWorkDocs = TRUE|FALSE,
#'         EnableInternetAccess = TRUE|FALSE,
#'         DefaultOu = "string",
#'         CustomSecurityGroupId = "string",
#'         UserEnabledAsLocalAdministrator = TRUE|FALSE,
#'         EnableMaintenanceMode = TRUE|FALSE
#'       ),
#'       ipGroupIds = list(
#'         "string"
#'       ),
#'       WorkspaceAccessProperties = list(
#'         DeviceTypeWindows = "ALLOW"|"DENY",
#'         DeviceTypeOsx = "ALLOW"|"DENY",
#'         DeviceTypeWeb = "ALLOW"|"DENY",
#'         DeviceTypeIos = "ALLOW"|"DENY",
#'         DeviceTypeAndroid = "ALLOW"|"DENY",
#'         DeviceTypeChromeOs = "ALLOW"|"DENY",
#'         DeviceTypeZeroClient = "ALLOW"|"DENY"
#'       ),
#'       Tenancy = "DEDICATED"|"SHARED",
#'       SelfservicePermissions = list(
#'         RestartWorkspace = "ENABLED"|"DISABLED",
#'         IncreaseVolumeSize = "ENABLED"|"DISABLED",
#'         ChangeComputeType = "ENABLED"|"DISABLED",
#'         SwitchRunningMode = "ENABLED"|"DISABLED",
#'         RebuildWorkspace = "ENABLED"|"DISABLED"
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_workspace_directories(
#'   DirectoryIds = list(
#'     "string"
#'   ),
#'   Limit = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_describe_workspace_directories
workspaces_describe_workspace_directories <- function(DirectoryIds = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeWorkspaceDirectories",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$describe_workspace_directories_input(DirectoryIds = DirectoryIds, Limit = Limit, NextToken = NextToken)
  output <- .workspaces$describe_workspace_directories_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$describe_workspace_directories <- workspaces_describe_workspace_directories

#' Describes the permissions that the owner of an image has granted to
#' other AWS accounts for an image
#'
#' @description
#' Describes the permissions that the owner of an image has granted to
#' other AWS accounts for an image.
#'
#' @usage
#' workspaces_describe_workspace_image_permissions(ImageId, NextToken,
#'   MaxResults)
#'
#' @param ImageId &#91;required&#93; The identifier of the image.
#' @param NextToken If you received a `NextToken` from a previous call that was paginated,
#' provide this token to receive the next set of results.
#' @param MaxResults The maximum number of items to return.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ImageId = "string",
#'   ImagePermissions = list(
#'     list(
#'       SharedAccountId = "string"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_workspace_image_permissions(
#'   ImageId = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_describe_workspace_image_permissions
workspaces_describe_workspace_image_permissions <- function(ImageId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeWorkspaceImagePermissions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$describe_workspace_image_permissions_input(ImageId = ImageId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .workspaces$describe_workspace_image_permissions_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$describe_workspace_image_permissions <- workspaces_describe_workspace_image_permissions

#' Retrieves a list that describes one or more specified images, if the
#' image identifiers are provided
#'
#' @description
#' Retrieves a list that describes one or more specified images, if the
#' image identifiers are provided. Otherwise, all images in the account are
#' described.
#'
#' @usage
#' workspaces_describe_workspace_images(ImageIds, ImageType, NextToken,
#'   MaxResults)
#'
#' @param ImageIds The identifier of the image.
#' @param ImageType The type (owned or shared) of the image.
#' @param NextToken If you received a `NextToken` from a previous call that was paginated,
#' provide this token to receive the next set of results.
#' @param MaxResults The maximum number of items to return.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Images = list(
#'     list(
#'       ImageId = "string",
#'       Name = "string",
#'       Description = "string",
#'       OperatingSystem = list(
#'         Type = "WINDOWS"|"LINUX"
#'       ),
#'       State = "AVAILABLE"|"PENDING"|"ERROR",
#'       RequiredTenancy = "DEFAULT"|"DEDICATED",
#'       ErrorCode = "string",
#'       ErrorMessage = "string",
#'       Created = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       OwnerAccountId = "string"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_workspace_images(
#'   ImageIds = list(
#'     "string"
#'   ),
#'   ImageType = "OWNED"|"SHARED",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_describe_workspace_images
workspaces_describe_workspace_images <- function(ImageIds = NULL, ImageType = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeWorkspaceImages",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$describe_workspace_images_input(ImageIds = ImageIds, ImageType = ImageType, NextToken = NextToken, MaxResults = MaxResults)
  output <- .workspaces$describe_workspace_images_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$describe_workspace_images <- workspaces_describe_workspace_images

#' Describes the snapshots for the specified WorkSpace
#'
#' @description
#' Describes the snapshots for the specified WorkSpace.
#'
#' @usage
#' workspaces_describe_workspace_snapshots(WorkspaceId)
#'
#' @param WorkspaceId &#91;required&#93; The identifier of the WorkSpace.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   RebuildSnapshots = list(
#'     list(
#'       SnapshotTime = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   ),
#'   RestoreSnapshots = list(
#'     list(
#'       SnapshotTime = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_workspace_snapshots(
#'   WorkspaceId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_describe_workspace_snapshots
workspaces_describe_workspace_snapshots <- function(WorkspaceId) {
  op <- new_operation(
    name = "DescribeWorkspaceSnapshots",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$describe_workspace_snapshots_input(WorkspaceId = WorkspaceId)
  output <- .workspaces$describe_workspace_snapshots_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$describe_workspace_snapshots <- workspaces_describe_workspace_snapshots

#' Describes the specified WorkSpaces
#'
#' @description
#' Describes the specified WorkSpaces.
#' 
#' You can filter the results by using the bundle identifier, directory
#' identifier, or owner, but you can specify only one filter at a time.
#'
#' @usage
#' workspaces_describe_workspaces(WorkspaceIds, DirectoryId, UserName,
#'   BundleId, Limit, NextToken)
#'
#' @param WorkspaceIds The identifiers of the WorkSpaces. You cannot combine this parameter
#' with any other filter.
#' 
#' Because the [`create_workspaces`][workspaces_create_workspaces]
#' operation is asynchronous, the identifier it returns is not immediately
#' available. If you immediately call
#' [`describe_workspaces`][workspaces_describe_workspaces] with this
#' identifier, no information is returned.
#' @param DirectoryId The identifier of the directory. In addition, you can optionally specify
#' a specific directory user (see `UserName`). You cannot combine this
#' parameter with any other filter.
#' @param UserName The name of the directory user. You must specify this parameter with
#' `DirectoryId`.
#' @param BundleId The identifier of the bundle. All WorkSpaces that are created from this
#' bundle are retrieved. You cannot combine this parameter with any other
#' filter.
#' @param Limit The maximum number of items to return.
#' @param NextToken If you received a `NextToken` from a previous call that was paginated,
#' provide this token to receive the next set of results.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Workspaces = list(
#'     list(
#'       WorkspaceId = "string",
#'       DirectoryId = "string",
#'       UserName = "string",
#'       IpAddress = "string",
#'       State = "PENDING"|"AVAILABLE"|"IMPAIRED"|"UNHEALTHY"|"REBOOTING"|"STARTING"|"REBUILDING"|"RESTORING"|"MAINTENANCE"|"ADMIN_MAINTENANCE"|"TERMINATING"|"TERMINATED"|"SUSPENDED"|"UPDATING"|"STOPPING"|"STOPPED"|"ERROR",
#'       BundleId = "string",
#'       SubnetId = "string",
#'       ErrorMessage = "string",
#'       ErrorCode = "string",
#'       ComputerName = "string",
#'       VolumeEncryptionKey = "string",
#'       UserVolumeEncryptionEnabled = TRUE|FALSE,
#'       RootVolumeEncryptionEnabled = TRUE|FALSE,
#'       WorkspaceProperties = list(
#'         RunningMode = "AUTO_STOP"|"ALWAYS_ON",
#'         RunningModeAutoStopTimeoutInMinutes = 123,
#'         RootVolumeSizeGib = 123,
#'         UserVolumeSizeGib = 123,
#'         ComputeTypeName = "VALUE"|"STANDARD"|"PERFORMANCE"|"POWER"|"GRAPHICS"|"POWERPRO"|"GRAPHICSPRO"
#'       ),
#'       ModificationStates = list(
#'         list(
#'           Resource = "ROOT_VOLUME"|"USER_VOLUME"|"COMPUTE_TYPE",
#'           State = "UPDATE_INITIATED"|"UPDATE_IN_PROGRESS"
#'         )
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_workspaces(
#'   WorkspaceIds = list(
#'     "string"
#'   ),
#'   DirectoryId = "string",
#'   UserName = "string",
#'   BundleId = "string",
#'   Limit = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_describe_workspaces
workspaces_describe_workspaces <- function(WorkspaceIds = NULL, DirectoryId = NULL, UserName = NULL, BundleId = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeWorkspaces",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$describe_workspaces_input(WorkspaceIds = WorkspaceIds, DirectoryId = DirectoryId, UserName = UserName, BundleId = BundleId, Limit = Limit, NextToken = NextToken)
  output <- .workspaces$describe_workspaces_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$describe_workspaces <- workspaces_describe_workspaces

#' Describes the connection status of the specified WorkSpaces
#'
#' @description
#' Describes the connection status of the specified WorkSpaces.
#'
#' @usage
#' workspaces_describe_workspaces_connection_status(WorkspaceIds,
#'   NextToken)
#'
#' @param WorkspaceIds The identifiers of the WorkSpaces. You can specify up to 25 WorkSpaces.
#' @param NextToken If you received a `NextToken` from a previous call that was paginated,
#' provide this token to receive the next set of results.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   WorkspacesConnectionStatus = list(
#'     list(
#'       WorkspaceId = "string",
#'       ConnectionState = "CONNECTED"|"DISCONNECTED"|"UNKNOWN",
#'       ConnectionStateCheckTimestamp = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       LastKnownUserConnectionTimestamp = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_workspaces_connection_status(
#'   WorkspaceIds = list(
#'     "string"
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_describe_workspaces_connection_status
workspaces_describe_workspaces_connection_status <- function(WorkspaceIds = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeWorkspacesConnectionStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$describe_workspaces_connection_status_input(WorkspaceIds = WorkspaceIds, NextToken = NextToken)
  output <- .workspaces$describe_workspaces_connection_status_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$describe_workspaces_connection_status <- workspaces_describe_workspaces_connection_status

#' Disassociates a connection alias from a directory
#'
#' @description
#' Disassociates a connection alias from a directory. Disassociating a
#' connection alias disables cross-Region redirection between two
#' directories in different AWS Regions. For more information, see
#' [Cross-Region Redirection for Amazon
#' WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
#' 
#' Before performing this operation, call
#' [DescribeConnectionAliases](https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html)
#' to make sure that the current state of the connection alias is
#' `CREATED`.
#'
#' @usage
#' workspaces_disassociate_connection_alias(AliasId)
#'
#' @param AliasId &#91;required&#93; The identifier of the connection alias to disassociate.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_connection_alias(
#'   AliasId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_disassociate_connection_alias
workspaces_disassociate_connection_alias <- function(AliasId) {
  op <- new_operation(
    name = "DisassociateConnectionAlias",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$disassociate_connection_alias_input(AliasId = AliasId)
  output <- .workspaces$disassociate_connection_alias_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$disassociate_connection_alias <- workspaces_disassociate_connection_alias

#' Disassociates the specified IP access control group from the specified
#' directory
#'
#' @description
#' Disassociates the specified IP access control group from the specified
#' directory.
#'
#' @usage
#' workspaces_disassociate_ip_groups(DirectoryId, GroupIds)
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory.
#' @param GroupIds &#91;required&#93; The identifiers of one or more IP access control groups.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_ip_groups(
#'   DirectoryId = "string",
#'   GroupIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_disassociate_ip_groups
workspaces_disassociate_ip_groups <- function(DirectoryId, GroupIds) {
  op <- new_operation(
    name = "DisassociateIpGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$disassociate_ip_groups_input(DirectoryId = DirectoryId, GroupIds = GroupIds)
  output <- .workspaces$disassociate_ip_groups_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$disassociate_ip_groups <- workspaces_disassociate_ip_groups

#' Imports the specified Windows 10 Bring Your Own License (BYOL) image
#' into Amazon WorkSpaces
#'
#' @description
#' Imports the specified Windows 10 Bring Your Own License (BYOL) image
#' into Amazon WorkSpaces. The image must be an already licensed Amazon EC2
#' image that is in your AWS account, and you must own the image. For more
#' information about creating BYOL images, see [Bring Your Own Windows
#' Desktop
#' Licenses](https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html).
#'
#' @usage
#' workspaces_import_workspace_image(Ec2ImageId, IngestionProcess,
#'   ImageName, ImageDescription, Tags, Applications)
#'
#' @param Ec2ImageId &#91;required&#93; The identifier of the EC2 image.
#' @param IngestionProcess &#91;required&#93; The ingestion process to be used when importing the image, depending on
#' which protocol you want to use for your BYOL Workspace image, either
#' PCoIP or WorkSpaces Streaming Protocol (WSP). To use WSP, specify a
#' value that ends in `_WSP`. To use PCoIP, specify a value that does not
#' end in `_WSP`.
#' 
#' For non-GPU-enabled bundles (bundles other than Graphics or
#' GraphicsPro), specify `BYOL_REGULAR` or `BYOL_REGULAR_WSP`, depending on
#' the protocol.
#' @param ImageName &#91;required&#93; The name of the WorkSpace image.
#' @param ImageDescription &#91;required&#93; The description of the WorkSpace image.
#' @param Tags The tags. Each WorkSpaces resource can have a maximum of 50 tags.
#' @param Applications If specified, the version of Microsoft Office to subscribe to. Valid
#' only for Windows 10 BYOL images. For more information about subscribing
#' to Office for BYOL images, see [Bring Your Own Windows Desktop
#' Licenses](https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html).
#' 
#' Although this parameter is an array, only one item is allowed at this
#' time.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ImageId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$import_workspace_image(
#'   Ec2ImageId = "string",
#'   IngestionProcess = "BYOL_REGULAR"|"BYOL_GRAPHICS"|"BYOL_GRAPHICSPRO"|"BYOL_REGULAR_WSP",
#'   ImageName = "string",
#'   ImageDescription = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   Applications = list(
#'     "Microsoft_Office_2016"|"Microsoft_Office_2019"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_import_workspace_image
workspaces_import_workspace_image <- function(Ec2ImageId, IngestionProcess, ImageName, ImageDescription, Tags = NULL, Applications = NULL) {
  op <- new_operation(
    name = "ImportWorkspaceImage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$import_workspace_image_input(Ec2ImageId = Ec2ImageId, IngestionProcess = IngestionProcess, ImageName = ImageName, ImageDescription = ImageDescription, Tags = Tags, Applications = Applications)
  output <- .workspaces$import_workspace_image_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$import_workspace_image <- workspaces_import_workspace_image

#' Retrieves a list of IP address ranges, specified as IPv4 CIDR blocks,
#' that you can use for the network management interface when you enable
#' Bring Your Own License (BYOL)
#'
#' @description
#' Retrieves a list of IP address ranges, specified as IPv4 CIDR blocks,
#' that you can use for the network management interface when you enable
#' Bring Your Own License (BYOL).
#' 
#' This operation can be run only by AWS accounts that are enabled for
#' BYOL. If your account isn't enabled for BYOL, you'll receive an
#' `AccessDeniedException` error.
#' 
#' The management network interface is connected to a secure Amazon
#' WorkSpaces management network. It is used for interactive streaming of
#' the WorkSpace desktop to Amazon WorkSpaces clients, and to allow Amazon
#' WorkSpaces to manage the WorkSpace.
#'
#' @usage
#' workspaces_list_available_management_cidr_ranges(
#'   ManagementCidrRangeConstraint, MaxResults, NextToken)
#'
#' @param ManagementCidrRangeConstraint &#91;required&#93; The IP address range to search. Specify an IP address range that is
#' compatible with your network and in CIDR notation (that is, specify the
#' range as an IPv4 CIDR block).
#' @param MaxResults The maximum number of items to return.
#' @param NextToken If you received a `NextToken` from a previous call that was paginated,
#' provide this token to receive the next set of results.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ManagementCidrRanges = list(
#'     "string"
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_available_management_cidr_ranges(
#'   ManagementCidrRangeConstraint = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_list_available_management_cidr_ranges
workspaces_list_available_management_cidr_ranges <- function(ManagementCidrRangeConstraint, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListAvailableManagementCidrRanges",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$list_available_management_cidr_ranges_input(ManagementCidrRangeConstraint = ManagementCidrRangeConstraint, MaxResults = MaxResults, NextToken = NextToken)
  output <- .workspaces$list_available_management_cidr_ranges_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$list_available_management_cidr_ranges <- workspaces_list_available_management_cidr_ranges

#' Migrates a WorkSpace from one operating system or bundle type to
#' another, while retaining the data on the user volume
#'
#' @description
#' Migrates a WorkSpace from one operating system or bundle type to
#' another, while retaining the data on the user volume.
#' 
#' The migration process recreates the WorkSpace by using a new root volume
#' from the target bundle image and the user volume from the last available
#' snapshot of the original WorkSpace. During migration, the original
#' `D:\Users%USERNAME%` user profile folder is renamed to
#' `D:\Users%USERNAME%MMddyyTHHmmss%.NotMigrated`. A new
#' `D:\Users%USERNAME%\` folder is generated by the new OS. Certain files
#' in the old user profile are moved to the new user profile.
#' 
#' For available migration scenarios, details about what happens during
#' migration, and best practices, see [Migrate a
#' WorkSpace](https://docs.aws.amazon.com/workspaces/latest/adminguide/migrate-workspaces.html).
#'
#' @usage
#' workspaces_migrate_workspace(SourceWorkspaceId, BundleId)
#'
#' @param SourceWorkspaceId &#91;required&#93; The identifier of the WorkSpace to migrate from.
#' @param BundleId &#91;required&#93; The identifier of the target bundle type to migrate the WorkSpace to.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   SourceWorkspaceId = "string",
#'   TargetWorkspaceId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$migrate_workspace(
#'   SourceWorkspaceId = "string",
#'   BundleId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_migrate_workspace
workspaces_migrate_workspace <- function(SourceWorkspaceId, BundleId) {
  op <- new_operation(
    name = "MigrateWorkspace",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$migrate_workspace_input(SourceWorkspaceId = SourceWorkspaceId, BundleId = BundleId)
  output <- .workspaces$migrate_workspace_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$migrate_workspace <- workspaces_migrate_workspace

#' Modifies the configuration of Bring Your Own License (BYOL) for the
#' specified account
#'
#' @description
#' Modifies the configuration of Bring Your Own License (BYOL) for the
#' specified account.
#'
#' @usage
#' workspaces_modify_account(DedicatedTenancySupport,
#'   DedicatedTenancyManagementCidrRange)
#'
#' @param DedicatedTenancySupport The status of BYOL.
#' @param DedicatedTenancyManagementCidrRange The IP address range, specified as an IPv4 CIDR block, for the
#' management network interface. Specify an IP address range that is
#' compatible with your network and in CIDR notation (that is, specify the
#' range as an IPv4 CIDR block). The CIDR block size must be /16 (for
#' example, 203.0.113.25/16). It must also be specified as available by the
#' [`list_available_management_cidr_ranges`][workspaces_list_available_management_cidr_ranges]
#' operation.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$modify_account(
#'   DedicatedTenancySupport = "ENABLED",
#'   DedicatedTenancyManagementCidrRange = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_modify_account
workspaces_modify_account <- function(DedicatedTenancySupport = NULL, DedicatedTenancyManagementCidrRange = NULL) {
  op <- new_operation(
    name = "ModifyAccount",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$modify_account_input(DedicatedTenancySupport = DedicatedTenancySupport, DedicatedTenancyManagementCidrRange = DedicatedTenancyManagementCidrRange)
  output <- .workspaces$modify_account_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$modify_account <- workspaces_modify_account

#' Modifies the properties of the specified Amazon WorkSpaces clients
#'
#' @description
#' Modifies the properties of the specified Amazon WorkSpaces clients.
#'
#' @usage
#' workspaces_modify_client_properties(ResourceId, ClientProperties)
#'
#' @param ResourceId &#91;required&#93; The resource identifiers, in the form of directory IDs.
#' @param ClientProperties &#91;required&#93; Information about the Amazon WorkSpaces client.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$modify_client_properties(
#'   ResourceId = "string",
#'   ClientProperties = list(
#'     ReconnectEnabled = "ENABLED"|"DISABLED"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_modify_client_properties
workspaces_modify_client_properties <- function(ResourceId, ClientProperties) {
  op <- new_operation(
    name = "ModifyClientProperties",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$modify_client_properties_input(ResourceId = ResourceId, ClientProperties = ClientProperties)
  output <- .workspaces$modify_client_properties_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$modify_client_properties <- workspaces_modify_client_properties

#' Modifies the self-service WorkSpace management capabilities for your
#' users
#'
#' @description
#' Modifies the self-service WorkSpace management capabilities for your
#' users. For more information, see [Enable Self-Service WorkSpace
#' Management Capabilities for Your
#' Users](https://docs.aws.amazon.com/workspaces/latest/adminguide/enable-user-self-service-workspace-management.html).
#'
#' @usage
#' workspaces_modify_selfservice_permissions(ResourceId,
#'   SelfservicePermissions)
#'
#' @param ResourceId &#91;required&#93; The identifier of the directory.
#' @param SelfservicePermissions &#91;required&#93; The permissions to enable or disable self-service capabilities.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$modify_selfservice_permissions(
#'   ResourceId = "string",
#'   SelfservicePermissions = list(
#'     RestartWorkspace = "ENABLED"|"DISABLED",
#'     IncreaseVolumeSize = "ENABLED"|"DISABLED",
#'     ChangeComputeType = "ENABLED"|"DISABLED",
#'     SwitchRunningMode = "ENABLED"|"DISABLED",
#'     RebuildWorkspace = "ENABLED"|"DISABLED"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_modify_selfservice_permissions
workspaces_modify_selfservice_permissions <- function(ResourceId, SelfservicePermissions) {
  op <- new_operation(
    name = "ModifySelfservicePermissions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$modify_selfservice_permissions_input(ResourceId = ResourceId, SelfservicePermissions = SelfservicePermissions)
  output <- .workspaces$modify_selfservice_permissions_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$modify_selfservice_permissions <- workspaces_modify_selfservice_permissions

#' Specifies which devices and operating systems users can use to access
#' their WorkSpaces
#'
#' @description
#' Specifies which devices and operating systems users can use to access
#' their WorkSpaces. For more information, see [Control Device
#' Access](https://docs.aws.amazon.com/workspaces/latest/adminguide/update-directory-details.html#control-device-access).
#'
#' @usage
#' workspaces_modify_workspace_access_properties(ResourceId,
#'   WorkspaceAccessProperties)
#'
#' @param ResourceId &#91;required&#93; The identifier of the directory.
#' @param WorkspaceAccessProperties &#91;required&#93; The device types and operating systems to enable or disable for access.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$modify_workspace_access_properties(
#'   ResourceId = "string",
#'   WorkspaceAccessProperties = list(
#'     DeviceTypeWindows = "ALLOW"|"DENY",
#'     DeviceTypeOsx = "ALLOW"|"DENY",
#'     DeviceTypeWeb = "ALLOW"|"DENY",
#'     DeviceTypeIos = "ALLOW"|"DENY",
#'     DeviceTypeAndroid = "ALLOW"|"DENY",
#'     DeviceTypeChromeOs = "ALLOW"|"DENY",
#'     DeviceTypeZeroClient = "ALLOW"|"DENY"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_modify_workspace_access_properties
workspaces_modify_workspace_access_properties <- function(ResourceId, WorkspaceAccessProperties) {
  op <- new_operation(
    name = "ModifyWorkspaceAccessProperties",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$modify_workspace_access_properties_input(ResourceId = ResourceId, WorkspaceAccessProperties = WorkspaceAccessProperties)
  output <- .workspaces$modify_workspace_access_properties_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$modify_workspace_access_properties <- workspaces_modify_workspace_access_properties

#' Modify the default properties used to create WorkSpaces
#'
#' @description
#' Modify the default properties used to create WorkSpaces.
#'
#' @usage
#' workspaces_modify_workspace_creation_properties(ResourceId,
#'   WorkspaceCreationProperties)
#'
#' @param ResourceId &#91;required&#93; The identifier of the directory.
#' @param WorkspaceCreationProperties &#91;required&#93; The default properties for creating WorkSpaces.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$modify_workspace_creation_properties(
#'   ResourceId = "string",
#'   WorkspaceCreationProperties = list(
#'     EnableWorkDocs = TRUE|FALSE,
#'     EnableInternetAccess = TRUE|FALSE,
#'     DefaultOu = "string",
#'     CustomSecurityGroupId = "string",
#'     UserEnabledAsLocalAdministrator = TRUE|FALSE,
#'     EnableMaintenanceMode = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_modify_workspace_creation_properties
workspaces_modify_workspace_creation_properties <- function(ResourceId, WorkspaceCreationProperties) {
  op <- new_operation(
    name = "ModifyWorkspaceCreationProperties",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$modify_workspace_creation_properties_input(ResourceId = ResourceId, WorkspaceCreationProperties = WorkspaceCreationProperties)
  output <- .workspaces$modify_workspace_creation_properties_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$modify_workspace_creation_properties <- workspaces_modify_workspace_creation_properties

#' Modifies the specified WorkSpace properties
#'
#' @description
#' Modifies the specified WorkSpace properties. For important information
#' about how to modify the size of the root and user volumes, see [Modify a
#' WorkSpace](https://docs.aws.amazon.com/workspaces/latest/adminguide/modify-workspaces.html).
#'
#' @usage
#' workspaces_modify_workspace_properties(WorkspaceId, WorkspaceProperties)
#'
#' @param WorkspaceId &#91;required&#93; The identifier of the WorkSpace.
#' @param WorkspaceProperties &#91;required&#93; The properties of the WorkSpace.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$modify_workspace_properties(
#'   WorkspaceId = "string",
#'   WorkspaceProperties = list(
#'     RunningMode = "AUTO_STOP"|"ALWAYS_ON",
#'     RunningModeAutoStopTimeoutInMinutes = 123,
#'     RootVolumeSizeGib = 123,
#'     UserVolumeSizeGib = 123,
#'     ComputeTypeName = "VALUE"|"STANDARD"|"PERFORMANCE"|"POWER"|"GRAPHICS"|"POWERPRO"|"GRAPHICSPRO"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_modify_workspace_properties
workspaces_modify_workspace_properties <- function(WorkspaceId, WorkspaceProperties) {
  op <- new_operation(
    name = "ModifyWorkspaceProperties",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$modify_workspace_properties_input(WorkspaceId = WorkspaceId, WorkspaceProperties = WorkspaceProperties)
  output <- .workspaces$modify_workspace_properties_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$modify_workspace_properties <- workspaces_modify_workspace_properties

#' Sets the state of the specified WorkSpace
#'
#' @description
#' Sets the state of the specified WorkSpace.
#' 
#' To maintain a WorkSpace without being interrupted, set the WorkSpace
#' state to `ADMIN_MAINTENANCE`. WorkSpaces in this state do not respond to
#' requests to reboot, stop, start, rebuild, or restore. An AutoStop
#' WorkSpace in this state is not stopped. Users cannot log into a
#' WorkSpace in the `ADMIN_MAINTENANCE` state.
#'
#' @usage
#' workspaces_modify_workspace_state(WorkspaceId, WorkspaceState)
#'
#' @param WorkspaceId &#91;required&#93; The identifier of the WorkSpace.
#' @param WorkspaceState &#91;required&#93; The WorkSpace state.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$modify_workspace_state(
#'   WorkspaceId = "string",
#'   WorkspaceState = "AVAILABLE"|"ADMIN_MAINTENANCE"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_modify_workspace_state
workspaces_modify_workspace_state <- function(WorkspaceId, WorkspaceState) {
  op <- new_operation(
    name = "ModifyWorkspaceState",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$modify_workspace_state_input(WorkspaceId = WorkspaceId, WorkspaceState = WorkspaceState)
  output <- .workspaces$modify_workspace_state_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$modify_workspace_state <- workspaces_modify_workspace_state

#' Reboots the specified WorkSpaces
#'
#' @description
#' Reboots the specified WorkSpaces.
#' 
#' You cannot reboot a WorkSpace unless its state is `AVAILABLE` or
#' `UNHEALTHY`.
#' 
#' This operation is asynchronous and returns before the WorkSpaces have
#' rebooted.
#'
#' @usage
#' workspaces_reboot_workspaces(RebootWorkspaceRequests)
#'
#' @param RebootWorkspaceRequests &#91;required&#93; The WorkSpaces to reboot. You can specify up to 25 WorkSpaces.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   FailedRequests = list(
#'     list(
#'       WorkspaceId = "string",
#'       ErrorCode = "string",
#'       ErrorMessage = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$reboot_workspaces(
#'   RebootWorkspaceRequests = list(
#'     list(
#'       WorkspaceId = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_reboot_workspaces
workspaces_reboot_workspaces <- function(RebootWorkspaceRequests) {
  op <- new_operation(
    name = "RebootWorkspaces",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$reboot_workspaces_input(RebootWorkspaceRequests = RebootWorkspaceRequests)
  output <- .workspaces$reboot_workspaces_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$reboot_workspaces <- workspaces_reboot_workspaces

#' Rebuilds the specified WorkSpace
#'
#' @description
#' Rebuilds the specified WorkSpace.
#' 
#' You cannot rebuild a WorkSpace unless its state is `AVAILABLE`, `ERROR`,
#' `UNHEALTHY`, `STOPPED`, or `REBOOTING`.
#' 
#' Rebuilding a WorkSpace is a potentially destructive action that can
#' result in the loss of data. For more information, see [Rebuild a
#' WorkSpace](https://docs.aws.amazon.com/workspaces/latest/adminguide/rebuild-workspace.html).
#' 
#' This operation is asynchronous and returns before the WorkSpaces have
#' been completely rebuilt.
#'
#' @usage
#' workspaces_rebuild_workspaces(RebuildWorkspaceRequests)
#'
#' @param RebuildWorkspaceRequests &#91;required&#93; The WorkSpace to rebuild. You can specify a single WorkSpace.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   FailedRequests = list(
#'     list(
#'       WorkspaceId = "string",
#'       ErrorCode = "string",
#'       ErrorMessage = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$rebuild_workspaces(
#'   RebuildWorkspaceRequests = list(
#'     list(
#'       WorkspaceId = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_rebuild_workspaces
workspaces_rebuild_workspaces <- function(RebuildWorkspaceRequests) {
  op <- new_operation(
    name = "RebuildWorkspaces",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$rebuild_workspaces_input(RebuildWorkspaceRequests = RebuildWorkspaceRequests)
  output <- .workspaces$rebuild_workspaces_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$rebuild_workspaces <- workspaces_rebuild_workspaces

#' Registers the specified directory
#'
#' @description
#' Registers the specified directory. This operation is asynchronous and
#' returns before the WorkSpace directory is registered. If this is the
#' first time you are registering a directory, you will need to create the
#' workspaces_DefaultRole role before you can register a directory. For
#' more information, see [Creating the workspaces_DefaultRole
#' Role](https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role).
#'
#' @usage
#' workspaces_register_workspace_directory(DirectoryId, SubnetIds,
#'   EnableWorkDocs, EnableSelfService, Tenancy, Tags)
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory. You cannot register a directory if it
#' does not have a status of Active. If the directory does not have a
#' status of Active, you will receive an InvalidResourceStateException
#' error. If you have already registered the maximum number of directories
#' that you can register with Amazon WorkSpaces, you will receive a
#' ResourceLimitExceededException error. Deregister directories that you
#' are not using for WorkSpaces, and try again.
#' @param SubnetIds The identifiers of the subnets for your virtual private cloud (VPC).
#' Make sure that the subnets are in supported Availability Zones. The
#' subnets must also be in separate Availability Zones. If these conditions
#' are not met, you will receive an OperationNotSupportedException error.
#' @param EnableWorkDocs &#91;required&#93; Indicates whether Amazon WorkDocs is enabled or disabled. If you have
#' enabled this parameter and WorkDocs is not available in the Region, you
#' will receive an OperationNotSupportedException error. Set
#' `EnableWorkDocs` to disabled, and try again.
#' @param EnableSelfService Indicates whether self-service capabilities are enabled or disabled.
#' @param Tenancy Indicates whether your WorkSpace directory is dedicated or shared. To
#' use Bring Your Own License (BYOL) images, this value must be set to
#' `DEDICATED` and your AWS account must be enabled for BYOL. If your
#' account has not been enabled for BYOL, you will receive an
#' InvalidParameterValuesException error. For more information about BYOL
#' images, see [Bring Your Own Windows Desktop
#' Images](https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html).
#' @param Tags The tags associated with the directory.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$register_workspace_directory(
#'   DirectoryId = "string",
#'   SubnetIds = list(
#'     "string"
#'   ),
#'   EnableWorkDocs = TRUE|FALSE,
#'   EnableSelfService = TRUE|FALSE,
#'   Tenancy = "DEDICATED"|"SHARED",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_register_workspace_directory
workspaces_register_workspace_directory <- function(DirectoryId, SubnetIds = NULL, EnableWorkDocs, EnableSelfService = NULL, Tenancy = NULL, Tags = NULL) {
  op <- new_operation(
    name = "RegisterWorkspaceDirectory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$register_workspace_directory_input(DirectoryId = DirectoryId, SubnetIds = SubnetIds, EnableWorkDocs = EnableWorkDocs, EnableSelfService = EnableSelfService, Tenancy = Tenancy, Tags = Tags)
  output <- .workspaces$register_workspace_directory_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$register_workspace_directory <- workspaces_register_workspace_directory

#' Restores the specified WorkSpace to its last known healthy state
#'
#' @description
#' Restores the specified WorkSpace to its last known healthy state.
#' 
#' You cannot restore a WorkSpace unless its state is ` AVAILABLE`,
#' `ERROR`, `UNHEALTHY`, or `STOPPED`.
#' 
#' Restoring a WorkSpace is a potentially destructive action that can
#' result in the loss of data. For more information, see [Restore a
#' WorkSpace](https://docs.aws.amazon.com/workspaces/latest/adminguide/restore-workspace.html).
#' 
#' This operation is asynchronous and returns before the WorkSpace is
#' completely restored.
#'
#' @usage
#' workspaces_restore_workspace(WorkspaceId)
#'
#' @param WorkspaceId &#91;required&#93; The identifier of the WorkSpace.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$restore_workspace(
#'   WorkspaceId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_restore_workspace
workspaces_restore_workspace <- function(WorkspaceId) {
  op <- new_operation(
    name = "RestoreWorkspace",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$restore_workspace_input(WorkspaceId = WorkspaceId)
  output <- .workspaces$restore_workspace_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$restore_workspace <- workspaces_restore_workspace

#' Removes one or more rules from the specified IP access control group
#'
#' @description
#' Removes one or more rules from the specified IP access control group.
#'
#' @usage
#' workspaces_revoke_ip_rules(GroupId, UserRules)
#'
#' @param GroupId &#91;required&#93; The identifier of the group.
#' @param UserRules &#91;required&#93; The rules to remove from the group.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$revoke_ip_rules(
#'   GroupId = "string",
#'   UserRules = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_revoke_ip_rules
workspaces_revoke_ip_rules <- function(GroupId, UserRules) {
  op <- new_operation(
    name = "RevokeIpRules",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$revoke_ip_rules_input(GroupId = GroupId, UserRules = UserRules)
  output <- .workspaces$revoke_ip_rules_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$revoke_ip_rules <- workspaces_revoke_ip_rules

#' Starts the specified WorkSpaces
#'
#' @description
#' Starts the specified WorkSpaces.
#' 
#' You cannot start a WorkSpace unless it has a running mode of `AutoStop`
#' and a state of `STOPPED`.
#'
#' @usage
#' workspaces_start_workspaces(StartWorkspaceRequests)
#'
#' @param StartWorkspaceRequests &#91;required&#93; The WorkSpaces to start. You can specify up to 25 WorkSpaces.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   FailedRequests = list(
#'     list(
#'       WorkspaceId = "string",
#'       ErrorCode = "string",
#'       ErrorMessage = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$start_workspaces(
#'   StartWorkspaceRequests = list(
#'     list(
#'       WorkspaceId = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_start_workspaces
workspaces_start_workspaces <- function(StartWorkspaceRequests) {
  op <- new_operation(
    name = "StartWorkspaces",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$start_workspaces_input(StartWorkspaceRequests = StartWorkspaceRequests)
  output <- .workspaces$start_workspaces_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$start_workspaces <- workspaces_start_workspaces

#' Stops the specified WorkSpaces
#'
#' @description
#' Stops the specified WorkSpaces.
#' 
#' You cannot stop a WorkSpace unless it has a running mode of `AutoStop`
#' and a state of `AVAILABLE`, `IMPAIRED`, `UNHEALTHY`, or `ERROR`.
#'
#' @usage
#' workspaces_stop_workspaces(StopWorkspaceRequests)
#'
#' @param StopWorkspaceRequests &#91;required&#93; The WorkSpaces to stop. You can specify up to 25 WorkSpaces.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   FailedRequests = list(
#'     list(
#'       WorkspaceId = "string",
#'       ErrorCode = "string",
#'       ErrorMessage = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$stop_workspaces(
#'   StopWorkspaceRequests = list(
#'     list(
#'       WorkspaceId = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_stop_workspaces
workspaces_stop_workspaces <- function(StopWorkspaceRequests) {
  op <- new_operation(
    name = "StopWorkspaces",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$stop_workspaces_input(StopWorkspaceRequests = StopWorkspaceRequests)
  output <- .workspaces$stop_workspaces_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$stop_workspaces <- workspaces_stop_workspaces

#' Terminates the specified WorkSpaces
#'
#' @description
#' Terminates the specified WorkSpaces.
#' 
#' Terminating a WorkSpace is a permanent action and cannot be undone. The
#' user's data is destroyed. If you need to archive any user data, contact
#' AWS Support before terminating the WorkSpace.
#' 
#' You can terminate a WorkSpace that is in any state except `SUSPENDED`.
#' 
#' This operation is asynchronous and returns before the WorkSpaces have
#' been completely terminated. After a WorkSpace is terminated, the
#' `TERMINATED` state is returned only briefly before the WorkSpace
#' directory metadata is cleaned up, so this state is rarely returned. To
#' confirm that a WorkSpace is terminated, check for the WorkSpace ID by
#' using
#' [DescribeWorkSpaces](https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaces.html).
#' If the WorkSpace ID isn't returned, then the WorkSpace has been
#' successfully terminated.
#' 
#' Simple AD and AD Connector are made available to you free of charge to
#' use with WorkSpaces. If there are no WorkSpaces being used with your
#' Simple AD or AD Connector directory for 30 consecutive days, this
#' directory will be automatically deregistered for use with Amazon
#' WorkSpaces, and you will be charged for this directory as per the [AWS
#' Directory Services pricing
#' terms](https://aws.amazon.com/directoryservice/pricing/).
#' 
#' To delete empty directories, see [Delete the Directory for Your
#' WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/delete-workspaces-directory.html).
#' If you delete your Simple AD or AD Connector directory, you can always
#' create a new one when you want to start using WorkSpaces again.
#'
#' @usage
#' workspaces_terminate_workspaces(TerminateWorkspaceRequests)
#'
#' @param TerminateWorkspaceRequests &#91;required&#93; The WorkSpaces to terminate. You can specify up to 25 WorkSpaces.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   FailedRequests = list(
#'     list(
#'       WorkspaceId = "string",
#'       ErrorCode = "string",
#'       ErrorMessage = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$terminate_workspaces(
#'   TerminateWorkspaceRequests = list(
#'     list(
#'       WorkspaceId = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_terminate_workspaces
workspaces_terminate_workspaces <- function(TerminateWorkspaceRequests) {
  op <- new_operation(
    name = "TerminateWorkspaces",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$terminate_workspaces_input(TerminateWorkspaceRequests = TerminateWorkspaceRequests)
  output <- .workspaces$terminate_workspaces_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$terminate_workspaces <- workspaces_terminate_workspaces

#' Shares or unshares a connection alias with one account by specifying
#' whether that account has permission to associate the connection alias
#' with a directory
#'
#' @description
#' Shares or unshares a connection alias with one account by specifying
#' whether that account has permission to associate the connection alias
#' with a directory. If the association permission is granted, the
#' connection alias is shared with that account. If the association
#' permission is revoked, the connection alias is unshared with the
#' account. For more information, see [Cross-Region Redirection for Amazon
#' WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
#' 
#' -   Before performing this operation, call
#'     [DescribeConnectionAliases](https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html)
#'     to make sure that the current state of the connection alias is
#'     `CREATED`.
#' 
#' -   To delete a connection alias that has been shared, the shared
#'     account must first disassociate the connection alias from any
#'     directories it has been associated with. Then you must unshare the
#'     connection alias from the account it has been shared with. You can
#'     delete a connection alias only after it is no longer shared with any
#'     accounts or associated with any directories.
#'
#' @usage
#' workspaces_update_connection_alias_permission(AliasId,
#'   ConnectionAliasPermission)
#'
#' @param AliasId &#91;required&#93; The identifier of the connection alias that you want to update
#' permissions for.
#' @param ConnectionAliasPermission &#91;required&#93; Indicates whether to share or unshare the connection alias with the
#' specified AWS account.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$update_connection_alias_permission(
#'   AliasId = "string",
#'   ConnectionAliasPermission = list(
#'     SharedAccountId = "string",
#'     AllowAssociation = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_update_connection_alias_permission
workspaces_update_connection_alias_permission <- function(AliasId, ConnectionAliasPermission) {
  op <- new_operation(
    name = "UpdateConnectionAliasPermission",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$update_connection_alias_permission_input(AliasId = AliasId, ConnectionAliasPermission = ConnectionAliasPermission)
  output <- .workspaces$update_connection_alias_permission_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$update_connection_alias_permission <- workspaces_update_connection_alias_permission

#' Replaces the current rules of the specified IP access control group with
#' the specified rules
#'
#' @description
#' Replaces the current rules of the specified IP access control group with
#' the specified rules.
#'
#' @usage
#' workspaces_update_rules_of_ip_group(GroupId, UserRules)
#'
#' @param GroupId &#91;required&#93; The identifier of the group.
#' @param UserRules &#91;required&#93; One or more rules.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$update_rules_of_ip_group(
#'   GroupId = "string",
#'   UserRules = list(
#'     list(
#'       ipRule = "string",
#'       ruleDesc = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_update_rules_of_ip_group
workspaces_update_rules_of_ip_group <- function(GroupId, UserRules) {
  op <- new_operation(
    name = "UpdateRulesOfIpGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$update_rules_of_ip_group_input(GroupId = GroupId, UserRules = UserRules)
  output <- .workspaces$update_rules_of_ip_group_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$update_rules_of_ip_group <- workspaces_update_rules_of_ip_group

#' Shares or unshares an image with one account in the same AWS Region by
#' specifying whether that account has permission to copy the image
#'
#' @description
#' Shares or unshares an image with one account in the same AWS Region by
#' specifying whether that account has permission to copy the image. If the
#' copy image permission is granted, the image is shared with that account.
#' If the copy image permission is revoked, the image is unshared with the
#' account.
#' 
#' After an image has been shared, the recipient account can copy the image
#' to other AWS Regions as needed.
#' 
#' In the China (Ningxia) Region, you can copy images only within the same
#' Region.
#' 
#' In the AWS GovCloud (US-West) Region, to copy images to and from other
#' AWS Regions, contact AWS Support.
#' 
#' For more information about sharing images, see [Share or Unshare a
#' Custom WorkSpaces
#' Image](https://docs.aws.amazon.com/workspaces/latest/adminguide/share-custom-image.html).
#' 
#' -   To delete an image that has been shared, you must unshare the image
#'     before you delete it.
#' 
#' -   Sharing Bring Your Own License (BYOL) images across AWS accounts
#'     isn't supported at this time in the AWS GovCloud (US-West) Region.
#'     To share BYOL images across accounts in the AWS GovCloud (US-West)
#'     Region, contact AWS Support.
#'
#' @usage
#' workspaces_update_workspace_image_permission(ImageId, AllowCopyImage,
#'   SharedAccountId)
#'
#' @param ImageId &#91;required&#93; The identifier of the image.
#' @param AllowCopyImage &#91;required&#93; The permission to copy the image. This permission can be revoked only
#' after an image has been shared.
#' @param SharedAccountId &#91;required&#93; The identifier of the AWS account to share or unshare the image with.
#' 
#' Before sharing the image, confirm that you are sharing to the correct
#' AWS account ID.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$update_workspace_image_permission(
#'   ImageId = "string",
#'   AllowCopyImage = TRUE|FALSE,
#'   SharedAccountId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname workspaces_update_workspace_image_permission
workspaces_update_workspace_image_permission <- function(ImageId, AllowCopyImage, SharedAccountId) {
  op <- new_operation(
    name = "UpdateWorkspaceImagePermission",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$update_workspace_image_permission_input(ImageId = ImageId, AllowCopyImage = AllowCopyImage, SharedAccountId = SharedAccountId)
  output <- .workspaces$update_workspace_image_permission_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$update_workspace_image_permission <- workspaces_update_workspace_image_permission
