% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worklink_operations.R
\name{worklink_describe_fleet_metadata}
\alias{worklink_describe_fleet_metadata}
\title{Provides basic information for the specified fleet, excluding identity
provider, networking, and device configuration details}
\usage{
worklink_describe_fleet_metadata(FleetArn)
}
\arguments{
\item{FleetArn}{[required] The Amazon Resource Name (ARN) of the fleet.}
}
\value{
A list with the following syntax:\preformatted{list(
  CreatedTime = as.POSIXct(
    "2015-01-01"
  ),
  LastUpdatedTime = as.POSIXct(
    "2015-01-01"
  ),
  FleetName = "string",
  DisplayName = "string",
  OptimizeForEndUserLocation = TRUE|FALSE,
  CompanyCode = "string",
  FleetStatus = "CREATING"|"ACTIVE"|"DELETING"|"DELETED"|"FAILED_TO_CREATE"|"FAILED_TO_DELETE",
  Tags = list(
    "string"
  )
)
}
}
\description{
Provides basic information for the specified fleet, excluding identity
provider, networking, and device configuration details.
}
\section{Request syntax}{
\preformatted{svc$describe_fleet_metadata(
  FleetArn = "string"
)
}
}

\keyword{internal}
