% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspaces_operations.R
\name{workspaces_delete_connection_alias}
\alias{workspaces_delete_connection_alias}
\title{Deletes the specified connection alias}
\usage{
workspaces_delete_connection_alias(AliasId)
}
\arguments{
\item{AliasId}{[required] The identifier of the connection alias to delete.}
}
\value{
An empty list.
}
\description{
Deletes the specified connection alias. For more information, see
\href{https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html}{Cross-Region Redirection for Amazon WorkSpaces}.

\strong{If you will no longer be using a fully qualified domain name (FQDN) as
the registration code for your WorkSpaces users, you must take certain
precautions to prevent potential security issues.} For more
information, see \href{https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html#cross-region-redirection-security-considerations}{Security Considerations if You Stop Using Cross-Region Redirection}.

To delete a connection alias that has been shared, the shared account
must first disassociate the connection alias from any directories it has
been associated with. Then you must unshare the connection alias from
the account it has been shared with. You can delete a connection alias
only after it is no longer shared with any accounts or associated with
any directories.
}
\section{Request syntax}{
\preformatted{svc$delete_connection_alias(
  AliasId = "string"
)
}
}

\keyword{internal}
