% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appstream_operations.R
\name{appstream_create_theme_for_stack}
\alias{appstream_create_theme_for_stack}
\title{Creates custom branding that customizes the appearance of the streaming
application catalog page}
\usage{
appstream_create_theme_for_stack(
  StackName,
  FooterLinks = NULL,
  TitleText,
  ThemeStyling,
  OrganizationLogoS3Location,
  FaviconS3Location
)
}
\arguments{
\item{StackName}{[required] The name of the stack for the theme.}

\item{FooterLinks}{The links that are displayed in the footer of the streaming application
catalog page. These links are helpful resources for users, such as the
organization's IT support and product marketing sites.}

\item{TitleText}{[required] The title that is displayed at the top of the browser tab during users'
application streaming sessions.}

\item{ThemeStyling}{[required] The color theme that is applied to website links, text, and buttons.
These colors are also applied as accents in the background for the
streaming application catalog page.}

\item{OrganizationLogoS3Location}{[required] The organization logo that appears on the streaming application catalog
page.}

\item{FaviconS3Location}{[required] The S3 location of the favicon. The favicon enables users to recognize
their application streaming site in a browser full of tabs or bookmarks.
It is displayed at the top of the browser tab for the application
streaming site during users' streaming sessions.}
}
\description{
Creates custom branding that customizes the appearance of the streaming application catalog page.

See \url{https://www.paws-r-sdk.com/docs/appstream_create_theme_for_stack/} for full documentation.
}
\keyword{internal}
