# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include workspacesweb_service.R
NULL

#' Associates a browser settings resource with a web portal
#'
#' @description
#' Associates a browser settings resource with a web portal.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_associate_browser_settings/](https://www.paws-r-sdk.com/docs/workspacesweb_associate_browser_settings/) for full documentation.
#'
#' @param browserSettingsArn &#91;required&#93; The ARN of the browser settings.
#' @param portalArn &#91;required&#93; The ARN of the web portal.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_associate_browser_settings
workspacesweb_associate_browser_settings <- function(browserSettingsArn, portalArn) {
  op <- new_operation(
    name = "AssociateBrowserSettings",
    http_method = "PUT",
    http_path = "/portals/{portalArn+}/browserSettings",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$associate_browser_settings_input(browserSettingsArn = browserSettingsArn, portalArn = portalArn)
  output <- .workspacesweb$associate_browser_settings_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$associate_browser_settings <- workspacesweb_associate_browser_settings

#' Associates a data protection settings resource with a web portal
#'
#' @description
#' Associates a data protection settings resource with a web portal.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_associate_data_protection_settings/](https://www.paws-r-sdk.com/docs/workspacesweb_associate_data_protection_settings/) for full documentation.
#'
#' @param dataProtectionSettingsArn &#91;required&#93; The ARN of the data protection settings.
#' @param portalArn &#91;required&#93; The ARN of the web portal.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_associate_data_protection_settings
workspacesweb_associate_data_protection_settings <- function(dataProtectionSettingsArn, portalArn) {
  op <- new_operation(
    name = "AssociateDataProtectionSettings",
    http_method = "PUT",
    http_path = "/portals/{portalArn+}/dataProtectionSettings",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$associate_data_protection_settings_input(dataProtectionSettingsArn = dataProtectionSettingsArn, portalArn = portalArn)
  output <- .workspacesweb$associate_data_protection_settings_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$associate_data_protection_settings <- workspacesweb_associate_data_protection_settings

#' Associates an IP access settings resource with a web portal
#'
#' @description
#' Associates an IP access settings resource with a web portal.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_associate_ip_access_settings/](https://www.paws-r-sdk.com/docs/workspacesweb_associate_ip_access_settings/) for full documentation.
#'
#' @param ipAccessSettingsArn &#91;required&#93; The ARN of the IP access settings.
#' @param portalArn &#91;required&#93; The ARN of the web portal.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_associate_ip_access_settings
workspacesweb_associate_ip_access_settings <- function(ipAccessSettingsArn, portalArn) {
  op <- new_operation(
    name = "AssociateIpAccessSettings",
    http_method = "PUT",
    http_path = "/portals/{portalArn+}/ipAccessSettings",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$associate_ip_access_settings_input(ipAccessSettingsArn = ipAccessSettingsArn, portalArn = portalArn)
  output <- .workspacesweb$associate_ip_access_settings_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$associate_ip_access_settings <- workspacesweb_associate_ip_access_settings

#' Associates a network settings resource with a web portal
#'
#' @description
#' Associates a network settings resource with a web portal.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_associate_network_settings/](https://www.paws-r-sdk.com/docs/workspacesweb_associate_network_settings/) for full documentation.
#'
#' @param networkSettingsArn &#91;required&#93; The ARN of the network settings.
#' @param portalArn &#91;required&#93; The ARN of the web portal.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_associate_network_settings
workspacesweb_associate_network_settings <- function(networkSettingsArn, portalArn) {
  op <- new_operation(
    name = "AssociateNetworkSettings",
    http_method = "PUT",
    http_path = "/portals/{portalArn+}/networkSettings",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$associate_network_settings_input(networkSettingsArn = networkSettingsArn, portalArn = portalArn)
  output <- .workspacesweb$associate_network_settings_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$associate_network_settings <- workspacesweb_associate_network_settings

#' Associates a trust store with a web portal
#'
#' @description
#' Associates a trust store with a web portal.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_associate_trust_store/](https://www.paws-r-sdk.com/docs/workspacesweb_associate_trust_store/) for full documentation.
#'
#' @param portalArn &#91;required&#93; The ARN of the web portal.
#' @param trustStoreArn &#91;required&#93; The ARN of the trust store.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_associate_trust_store
workspacesweb_associate_trust_store <- function(portalArn, trustStoreArn) {
  op <- new_operation(
    name = "AssociateTrustStore",
    http_method = "PUT",
    http_path = "/portals/{portalArn+}/trustStores",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$associate_trust_store_input(portalArn = portalArn, trustStoreArn = trustStoreArn)
  output <- .workspacesweb$associate_trust_store_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$associate_trust_store <- workspacesweb_associate_trust_store

#' Associates a user access logging settings resource with a web portal
#'
#' @description
#' Associates a user access logging settings resource with a web portal.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_associate_user_access_logging_settings/](https://www.paws-r-sdk.com/docs/workspacesweb_associate_user_access_logging_settings/) for full documentation.
#'
#' @param portalArn &#91;required&#93; The ARN of the web portal.
#' @param userAccessLoggingSettingsArn &#91;required&#93; The ARN of the user access logging settings.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_associate_user_access_logging_settings
workspacesweb_associate_user_access_logging_settings <- function(portalArn, userAccessLoggingSettingsArn) {
  op <- new_operation(
    name = "AssociateUserAccessLoggingSettings",
    http_method = "PUT",
    http_path = "/portals/{portalArn+}/userAccessLoggingSettings",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$associate_user_access_logging_settings_input(portalArn = portalArn, userAccessLoggingSettingsArn = userAccessLoggingSettingsArn)
  output <- .workspacesweb$associate_user_access_logging_settings_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$associate_user_access_logging_settings <- workspacesweb_associate_user_access_logging_settings

#' Associates a user settings resource with a web portal
#'
#' @description
#' Associates a user settings resource with a web portal.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_associate_user_settings/](https://www.paws-r-sdk.com/docs/workspacesweb_associate_user_settings/) for full documentation.
#'
#' @param portalArn &#91;required&#93; The ARN of the web portal.
#' @param userSettingsArn &#91;required&#93; The ARN of the user settings.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_associate_user_settings
workspacesweb_associate_user_settings <- function(portalArn, userSettingsArn) {
  op <- new_operation(
    name = "AssociateUserSettings",
    http_method = "PUT",
    http_path = "/portals/{portalArn+}/userSettings",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$associate_user_settings_input(portalArn = portalArn, userSettingsArn = userSettingsArn)
  output <- .workspacesweb$associate_user_settings_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$associate_user_settings <- workspacesweb_associate_user_settings

#' Creates a browser settings resource that can be associated with a web
#' portal
#'
#' @description
#' Creates a browser settings resource that can be associated with a web portal. Once associated with a web portal, browser settings control how the browser will behave once a user starts a streaming session for the web portal.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_create_browser_settings/](https://www.paws-r-sdk.com/docs/workspacesweb_create_browser_settings/) for full documentation.
#'
#' @param additionalEncryptionContext Additional encryption context of the browser settings.
#' @param browserPolicy &#91;required&#93; A JSON string containing Chrome Enterprise policies that will be applied
#' to all streaming sessions.
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Idempotency ensures that an API request
#' completes only once. With an idempotent request, if the original request
#' completes successfully, subsequent retries with the same client token
#' returns the result from the original successful request.
#' 
#' If you do not specify a client token, one is automatically generated by
#' the Amazon Web Services SDK.
#' @param customerManagedKey The custom managed key of the browser settings.
#' @param tags The tags to add to the browser settings resource. A tag is a key-value
#' pair.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_create_browser_settings
workspacesweb_create_browser_settings <- function(additionalEncryptionContext = NULL, browserPolicy, clientToken = NULL, customerManagedKey = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateBrowserSettings",
    http_method = "POST",
    http_path = "/browserSettings",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$create_browser_settings_input(additionalEncryptionContext = additionalEncryptionContext, browserPolicy = browserPolicy, clientToken = clientToken, customerManagedKey = customerManagedKey, tags = tags)
  output <- .workspacesweb$create_browser_settings_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$create_browser_settings <- workspacesweb_create_browser_settings

#' Creates a data protection settings resource that can be associated with
#' a web portal
#'
#' @description
#' Creates a data protection settings resource that can be associated with a web portal.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_create_data_protection_settings/](https://www.paws-r-sdk.com/docs/workspacesweb_create_data_protection_settings/) for full documentation.
#'
#' @param additionalEncryptionContext Additional encryption context of the data protection settings.
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Idempotency ensures that an API request
#' completes only once. With an idempotent request, if the original request
#' completes successfully, subsequent retries with the same client token
#' returns the result from the original successful request.
#' 
#' If you do not specify a client token, one is automatically generated by
#' the Amazon Web Services SDK.
#' @param customerManagedKey The custom managed key of the data protection settings.
#' @param description The description of the data protection settings.
#' @param displayName The display name of the data protection settings.
#' @param inlineRedactionConfiguration The inline redaction configuration of the data protection settings that
#' will be applied to all sessions.
#' @param tags The tags to add to the data protection settings resource. A tag is a
#' key-value pair.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_create_data_protection_settings
workspacesweb_create_data_protection_settings <- function(additionalEncryptionContext = NULL, clientToken = NULL, customerManagedKey = NULL, description = NULL, displayName = NULL, inlineRedactionConfiguration = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateDataProtectionSettings",
    http_method = "POST",
    http_path = "/dataProtectionSettings",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$create_data_protection_settings_input(additionalEncryptionContext = additionalEncryptionContext, clientToken = clientToken, customerManagedKey = customerManagedKey, description = description, displayName = displayName, inlineRedactionConfiguration = inlineRedactionConfiguration, tags = tags)
  output <- .workspacesweb$create_data_protection_settings_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$create_data_protection_settings <- workspacesweb_create_data_protection_settings

#' Creates an identity provider resource that is then associated with a web
#' portal
#'
#' @description
#' Creates an identity provider resource that is then associated with a web portal.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_create_identity_provider/](https://www.paws-r-sdk.com/docs/workspacesweb_create_identity_provider/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Idempotency ensures that an API request
#' completes only once. With an idempotent request, if the original request
#' completes successfully, subsequent retries with the same client token
#' returns the result from the original successful request.
#' 
#' If you do not specify a client token, one is automatically generated by
#' the Amazon Web Services SDK.
#' @param identityProviderDetails &#91;required&#93; The identity provider details. The following list describes the provider
#' detail keys for each identity provider type.
#' 
#' -   For Google and Login with Amazon:
#' 
#'     -   `client_id`
#' 
#'     -   `client_secret`
#' 
#'     -   `authorize_scopes`
#' 
#' -   For Facebook:
#' 
#'     -   `client_id`
#' 
#'     -   `client_secret`
#' 
#'     -   `authorize_scopes`
#' 
#'     -   `api_version`
#' 
#' -   For Sign in with Apple:
#' 
#'     -   `client_id`
#' 
#'     -   `team_id`
#' 
#'     -   `key_id`
#' 
#'     -   `private_key`
#' 
#'     -   `authorize_scopes`
#' 
#' -   For OIDC providers:
#' 
#'     -   `client_id`
#' 
#'     -   `client_secret`
#' 
#'     -   `attributes_request_method`
#' 
#'     -   `oidc_issuer`
#' 
#'     -   `authorize_scopes`
#' 
#'     -   `authorize_url` *if not available from discovery URL specified
#'         by oidc_issuer key*
#' 
#'     -   `token_url` *if not available from discovery URL specified by
#'         oidc_issuer key*
#' 
#'     -   `attributes_url` *if not available from discovery URL specified
#'         by oidc_issuer key*
#' 
#'     -   `jwks_uri` *if not available from discovery URL specified by
#'         oidc_issuer key*
#' 
#' -   For SAML providers:
#' 
#'     -   `MetadataFile` OR `MetadataURL`
#' 
#'     -   `IDPSignout` (boolean) *optional*
#' 
#'     -   `IDPInit` (boolean) *optional*
#' 
#'     -   `RequestSigningAlgorithm` (string) *optional* - Only accepts
#'         `rsa-sha256`
#' 
#'     -   `EncryptedResponses` (boolean) *optional*
#' @param identityProviderName &#91;required&#93; The identity provider name.
#' @param identityProviderType &#91;required&#93; The identity provider type.
#' @param portalArn &#91;required&#93; The ARN of the web portal.
#' @param tags The tags to add to the identity provider resource. A tag is a key-value
#' pair.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_create_identity_provider
workspacesweb_create_identity_provider <- function(clientToken = NULL, identityProviderDetails, identityProviderName, identityProviderType, portalArn, tags = NULL) {
  op <- new_operation(
    name = "CreateIdentityProvider",
    http_method = "POST",
    http_path = "/identityProviders",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$create_identity_provider_input(clientToken = clientToken, identityProviderDetails = identityProviderDetails, identityProviderName = identityProviderName, identityProviderType = identityProviderType, portalArn = portalArn, tags = tags)
  output <- .workspacesweb$create_identity_provider_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$create_identity_provider <- workspacesweb_create_identity_provider

#' Creates an IP access settings resource that can be associated with a web
#' portal
#'
#' @description
#' Creates an IP access settings resource that can be associated with a web portal.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_create_ip_access_settings/](https://www.paws-r-sdk.com/docs/workspacesweb_create_ip_access_settings/) for full documentation.
#'
#' @param additionalEncryptionContext Additional encryption context of the IP access settings.
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Idempotency ensures that an API request
#' completes only once. With an idempotent request, if the original request
#' completes successfully, subsequent retries with the same client token
#' returns the result from the original successful request.
#' 
#' If you do not specify a client token, one is automatically generated by
#' the Amazon Web Services SDK.
#' @param customerManagedKey The custom managed key of the IP access settings.
#' @param description The description of the IP access settings.
#' @param displayName The display name of the IP access settings.
#' @param ipRules &#91;required&#93; The IP rules of the IP access settings.
#' @param tags The tags to add to the IP access settings resource. A tag is a key-value
#' pair.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_create_ip_access_settings
workspacesweb_create_ip_access_settings <- function(additionalEncryptionContext = NULL, clientToken = NULL, customerManagedKey = NULL, description = NULL, displayName = NULL, ipRules, tags = NULL) {
  op <- new_operation(
    name = "CreateIpAccessSettings",
    http_method = "POST",
    http_path = "/ipAccessSettings",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$create_ip_access_settings_input(additionalEncryptionContext = additionalEncryptionContext, clientToken = clientToken, customerManagedKey = customerManagedKey, description = description, displayName = displayName, ipRules = ipRules, tags = tags)
  output <- .workspacesweb$create_ip_access_settings_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$create_ip_access_settings <- workspacesweb_create_ip_access_settings

#' Creates a network settings resource that can be associated with a web
#' portal
#'
#' @description
#' Creates a network settings resource that can be associated with a web portal. Once associated with a web portal, network settings define how streaming instances will connect with your specified VPC.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_create_network_settings/](https://www.paws-r-sdk.com/docs/workspacesweb_create_network_settings/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Idempotency ensures that an API request
#' completes only once. With an idempotent request, if the original request
#' completes successfully, subsequent retries with the same client token
#' returns the result from the original successful request.
#' 
#' If you do not specify a client token, one is automatically generated by
#' the Amazon Web Services SDK.
#' @param securityGroupIds &#91;required&#93; One or more security groups used to control access from streaming
#' instances to your VPC.
#' @param subnetIds &#91;required&#93; The subnets in which network interfaces are created to connect streaming
#' instances to your VPC. At least two of these subnets must be in
#' different availability zones.
#' @param tags The tags to add to the network settings resource. A tag is a key-value
#' pair.
#' @param vpcId &#91;required&#93; The VPC that streaming instances will connect to.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_create_network_settings
workspacesweb_create_network_settings <- function(clientToken = NULL, securityGroupIds, subnetIds, tags = NULL, vpcId) {
  op <- new_operation(
    name = "CreateNetworkSettings",
    http_method = "POST",
    http_path = "/networkSettings",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$create_network_settings_input(clientToken = clientToken, securityGroupIds = securityGroupIds, subnetIds = subnetIds, tags = tags, vpcId = vpcId)
  output <- .workspacesweb$create_network_settings_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$create_network_settings <- workspacesweb_create_network_settings

#' Creates a web portal
#'
#' @description
#' Creates a web portal.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_create_portal/](https://www.paws-r-sdk.com/docs/workspacesweb_create_portal/) for full documentation.
#'
#' @param additionalEncryptionContext The additional encryption context of the portal.
#' @param authenticationType The type of authentication integration points used when signing into the
#' web portal. Defaults to `Standard`.
#' 
#' `Standard` web portals are authenticated directly through your identity
#' provider. You need to call
#' [`create_identity_provider`][workspacesweb_create_identity_provider] to
#' integrate your identity provider with your web portal. User and group
#' access to your web portal is controlled through your identity provider.
#' 
#' `IAM Identity Center` web portals are authenticated through IAM Identity
#' Center. Identity sources (including external identity provider
#' integration), plus user and group access to your web portal, can be
#' configured in the IAM Identity Center.
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Idempotency ensures that an API request
#' completes only once. With an idempotent request, if the original request
#' completes successfully, subsequent retries with the same client token
#' returns the result from the original successful request.
#' 
#' If you do not specify a client token, one is automatically generated by
#' the Amazon Web Services SDK.
#' @param customerManagedKey The customer managed key of the web portal.
#' @param displayName The name of the web portal. This is not visible to users who log into
#' the web portal.
#' @param instanceType The type and resources of the underlying instance.
#' @param maxConcurrentSessions The maximum number of concurrent sessions for the portal.
#' @param tags The tags to add to the web portal. A tag is a key-value pair.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_create_portal
workspacesweb_create_portal <- function(additionalEncryptionContext = NULL, authenticationType = NULL, clientToken = NULL, customerManagedKey = NULL, displayName = NULL, instanceType = NULL, maxConcurrentSessions = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreatePortal",
    http_method = "POST",
    http_path = "/portals",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$create_portal_input(additionalEncryptionContext = additionalEncryptionContext, authenticationType = authenticationType, clientToken = clientToken, customerManagedKey = customerManagedKey, displayName = displayName, instanceType = instanceType, maxConcurrentSessions = maxConcurrentSessions, tags = tags)
  output <- .workspacesweb$create_portal_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$create_portal <- workspacesweb_create_portal

#' Creates a trust store that can be associated with a web portal
#'
#' @description
#' Creates a trust store that can be associated with a web portal. A trust store contains certificate authority (CA) certificates. Once associated with a web portal, the browser in a streaming session will recognize certificates that have been issued using any of the CAs in the trust store. If your organization has internal websites that use certificates issued by private CAs, you should add the private CA certificate to the trust store.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_create_trust_store/](https://www.paws-r-sdk.com/docs/workspacesweb_create_trust_store/) for full documentation.
#'
#' @param certificateList &#91;required&#93; A list of CA certificates to be added to the trust store.
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Idempotency ensures that an API request
#' completes only once. With an idempotent request, if the original request
#' completes successfully, subsequent retries with the same client token
#' returns the result from the original successful request.
#' 
#' If you do not specify a client token, one is automatically generated by
#' the Amazon Web Services SDK.
#' @param tags The tags to add to the trust store. A tag is a key-value pair.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_create_trust_store
workspacesweb_create_trust_store <- function(certificateList, clientToken = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateTrustStore",
    http_method = "POST",
    http_path = "/trustStores",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$create_trust_store_input(certificateList = certificateList, clientToken = clientToken, tags = tags)
  output <- .workspacesweb$create_trust_store_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$create_trust_store <- workspacesweb_create_trust_store

#' Creates a user access logging settings resource that can be associated
#' with a web portal
#'
#' @description
#' Creates a user access logging settings resource that can be associated with a web portal.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_create_user_access_logging_settings/](https://www.paws-r-sdk.com/docs/workspacesweb_create_user_access_logging_settings/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Idempotency ensures that an API request
#' completes only once. With an idempotent request, if the original request
#' completes successfully, subsequent retries with the same client token
#' returns the result from the original successful request.
#' 
#' If you do not specify a client token, one is automatically generated by
#' the Amazon Web Services SDK.
#' @param kinesisStreamArn &#91;required&#93; The ARN of the Kinesis stream.
#' @param tags The tags to add to the user settings resource. A tag is a key-value
#' pair.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_create_user_access_logging_settings
workspacesweb_create_user_access_logging_settings <- function(clientToken = NULL, kinesisStreamArn, tags = NULL) {
  op <- new_operation(
    name = "CreateUserAccessLoggingSettings",
    http_method = "POST",
    http_path = "/userAccessLoggingSettings",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$create_user_access_logging_settings_input(clientToken = clientToken, kinesisStreamArn = kinesisStreamArn, tags = tags)
  output <- .workspacesweb$create_user_access_logging_settings_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$create_user_access_logging_settings <- workspacesweb_create_user_access_logging_settings

#' Creates a user settings resource that can be associated with a web
#' portal
#'
#' @description
#' Creates a user settings resource that can be associated with a web portal. Once associated with a web portal, user settings control how users can transfer data between a streaming session and the their local devices.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_create_user_settings/](https://www.paws-r-sdk.com/docs/workspacesweb_create_user_settings/) for full documentation.
#'
#' @param additionalEncryptionContext The additional encryption context of the user settings.
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Idempotency ensures that an API request
#' completes only once. With an idempotent request, if the original request
#' completes successfully, subsequent retries with the same client token
#' returns the result from the original successful request.
#' 
#' If you do not specify a client token, one is automatically generated by
#' the Amazon Web Services SDK.
#' @param cookieSynchronizationConfiguration The configuration that specifies which cookies should be synchronized
#' from the end user's local browser to the remote browser.
#' @param copyAllowed &#91;required&#93; Specifies whether the user can copy text from the streaming session to
#' the local device.
#' @param customerManagedKey The customer managed key used to encrypt sensitive information in the
#' user settings.
#' @param deepLinkAllowed Specifies whether the user can use deep links that open automatically
#' when connecting to a session.
#' @param disconnectTimeoutInMinutes The amount of time that a streaming session remains active after users
#' disconnect.
#' @param downloadAllowed &#91;required&#93; Specifies whether the user can download files from the streaming session
#' to the local device.
#' @param idleDisconnectTimeoutInMinutes The amount of time that users can be idle (inactive) before they are
#' disconnected from their streaming session and the disconnect timeout
#' interval begins.
#' @param pasteAllowed &#91;required&#93; Specifies whether the user can paste text from the local device to the
#' streaming session.
#' @param printAllowed &#91;required&#93; Specifies whether the user can print to the local device.
#' @param tags The tags to add to the user settings resource. A tag is a key-value
#' pair.
#' @param uploadAllowed &#91;required&#93; Specifies whether the user can upload files from the local device to the
#' streaming session.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_create_user_settings
workspacesweb_create_user_settings <- function(additionalEncryptionContext = NULL, clientToken = NULL, cookieSynchronizationConfiguration = NULL, copyAllowed, customerManagedKey = NULL, deepLinkAllowed = NULL, disconnectTimeoutInMinutes = NULL, downloadAllowed, idleDisconnectTimeoutInMinutes = NULL, pasteAllowed, printAllowed, tags = NULL, uploadAllowed) {
  op <- new_operation(
    name = "CreateUserSettings",
    http_method = "POST",
    http_path = "/userSettings",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$create_user_settings_input(additionalEncryptionContext = additionalEncryptionContext, clientToken = clientToken, cookieSynchronizationConfiguration = cookieSynchronizationConfiguration, copyAllowed = copyAllowed, customerManagedKey = customerManagedKey, deepLinkAllowed = deepLinkAllowed, disconnectTimeoutInMinutes = disconnectTimeoutInMinutes, downloadAllowed = downloadAllowed, idleDisconnectTimeoutInMinutes = idleDisconnectTimeoutInMinutes, pasteAllowed = pasteAllowed, printAllowed = printAllowed, tags = tags, uploadAllowed = uploadAllowed)
  output <- .workspacesweb$create_user_settings_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$create_user_settings <- workspacesweb_create_user_settings

#' Deletes browser settings
#'
#' @description
#' Deletes browser settings.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_delete_browser_settings/](https://www.paws-r-sdk.com/docs/workspacesweb_delete_browser_settings/) for full documentation.
#'
#' @param browserSettingsArn &#91;required&#93; The ARN of the browser settings.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_delete_browser_settings
workspacesweb_delete_browser_settings <- function(browserSettingsArn) {
  op <- new_operation(
    name = "DeleteBrowserSettings",
    http_method = "DELETE",
    http_path = "/browserSettings/{browserSettingsArn+}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$delete_browser_settings_input(browserSettingsArn = browserSettingsArn)
  output <- .workspacesweb$delete_browser_settings_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$delete_browser_settings <- workspacesweb_delete_browser_settings

#' Deletes data protection settings
#'
#' @description
#' Deletes data protection settings.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_delete_data_protection_settings/](https://www.paws-r-sdk.com/docs/workspacesweb_delete_data_protection_settings/) for full documentation.
#'
#' @param dataProtectionSettingsArn &#91;required&#93; The ARN of the data protection settings.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_delete_data_protection_settings
workspacesweb_delete_data_protection_settings <- function(dataProtectionSettingsArn) {
  op <- new_operation(
    name = "DeleteDataProtectionSettings",
    http_method = "DELETE",
    http_path = "/dataProtectionSettings/{dataProtectionSettingsArn+}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$delete_data_protection_settings_input(dataProtectionSettingsArn = dataProtectionSettingsArn)
  output <- .workspacesweb$delete_data_protection_settings_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$delete_data_protection_settings <- workspacesweb_delete_data_protection_settings

#' Deletes the identity provider
#'
#' @description
#' Deletes the identity provider.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_delete_identity_provider/](https://www.paws-r-sdk.com/docs/workspacesweb_delete_identity_provider/) for full documentation.
#'
#' @param identityProviderArn &#91;required&#93; The ARN of the identity provider.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_delete_identity_provider
workspacesweb_delete_identity_provider <- function(identityProviderArn) {
  op <- new_operation(
    name = "DeleteIdentityProvider",
    http_method = "DELETE",
    http_path = "/identityProviders/{identityProviderArn+}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$delete_identity_provider_input(identityProviderArn = identityProviderArn)
  output <- .workspacesweb$delete_identity_provider_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$delete_identity_provider <- workspacesweb_delete_identity_provider

#' Deletes IP access settings
#'
#' @description
#' Deletes IP access settings.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_delete_ip_access_settings/](https://www.paws-r-sdk.com/docs/workspacesweb_delete_ip_access_settings/) for full documentation.
#'
#' @param ipAccessSettingsArn &#91;required&#93; The ARN of the IP access settings.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_delete_ip_access_settings
workspacesweb_delete_ip_access_settings <- function(ipAccessSettingsArn) {
  op <- new_operation(
    name = "DeleteIpAccessSettings",
    http_method = "DELETE",
    http_path = "/ipAccessSettings/{ipAccessSettingsArn+}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$delete_ip_access_settings_input(ipAccessSettingsArn = ipAccessSettingsArn)
  output <- .workspacesweb$delete_ip_access_settings_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$delete_ip_access_settings <- workspacesweb_delete_ip_access_settings

#' Deletes network settings
#'
#' @description
#' Deletes network settings.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_delete_network_settings/](https://www.paws-r-sdk.com/docs/workspacesweb_delete_network_settings/) for full documentation.
#'
#' @param networkSettingsArn &#91;required&#93; The ARN of the network settings.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_delete_network_settings
workspacesweb_delete_network_settings <- function(networkSettingsArn) {
  op <- new_operation(
    name = "DeleteNetworkSettings",
    http_method = "DELETE",
    http_path = "/networkSettings/{networkSettingsArn+}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$delete_network_settings_input(networkSettingsArn = networkSettingsArn)
  output <- .workspacesweb$delete_network_settings_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$delete_network_settings <- workspacesweb_delete_network_settings

#' Deletes a web portal
#'
#' @description
#' Deletes a web portal.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_delete_portal/](https://www.paws-r-sdk.com/docs/workspacesweb_delete_portal/) for full documentation.
#'
#' @param portalArn &#91;required&#93; The ARN of the web portal.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_delete_portal
workspacesweb_delete_portal <- function(portalArn) {
  op <- new_operation(
    name = "DeletePortal",
    http_method = "DELETE",
    http_path = "/portals/{portalArn+}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$delete_portal_input(portalArn = portalArn)
  output <- .workspacesweb$delete_portal_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$delete_portal <- workspacesweb_delete_portal

#' Deletes the trust store
#'
#' @description
#' Deletes the trust store.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_delete_trust_store/](https://www.paws-r-sdk.com/docs/workspacesweb_delete_trust_store/) for full documentation.
#'
#' @param trustStoreArn &#91;required&#93; The ARN of the trust store.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_delete_trust_store
workspacesweb_delete_trust_store <- function(trustStoreArn) {
  op <- new_operation(
    name = "DeleteTrustStore",
    http_method = "DELETE",
    http_path = "/trustStores/{trustStoreArn+}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$delete_trust_store_input(trustStoreArn = trustStoreArn)
  output <- .workspacesweb$delete_trust_store_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$delete_trust_store <- workspacesweb_delete_trust_store

#' Deletes user access logging settings
#'
#' @description
#' Deletes user access logging settings.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_delete_user_access_logging_settings/](https://www.paws-r-sdk.com/docs/workspacesweb_delete_user_access_logging_settings/) for full documentation.
#'
#' @param userAccessLoggingSettingsArn &#91;required&#93; The ARN of the user access logging settings.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_delete_user_access_logging_settings
workspacesweb_delete_user_access_logging_settings <- function(userAccessLoggingSettingsArn) {
  op <- new_operation(
    name = "DeleteUserAccessLoggingSettings",
    http_method = "DELETE",
    http_path = "/userAccessLoggingSettings/{userAccessLoggingSettingsArn+}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$delete_user_access_logging_settings_input(userAccessLoggingSettingsArn = userAccessLoggingSettingsArn)
  output <- .workspacesweb$delete_user_access_logging_settings_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$delete_user_access_logging_settings <- workspacesweb_delete_user_access_logging_settings

#' Deletes user settings
#'
#' @description
#' Deletes user settings.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_delete_user_settings/](https://www.paws-r-sdk.com/docs/workspacesweb_delete_user_settings/) for full documentation.
#'
#' @param userSettingsArn &#91;required&#93; The ARN of the user settings.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_delete_user_settings
workspacesweb_delete_user_settings <- function(userSettingsArn) {
  op <- new_operation(
    name = "DeleteUserSettings",
    http_method = "DELETE",
    http_path = "/userSettings/{userSettingsArn+}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$delete_user_settings_input(userSettingsArn = userSettingsArn)
  output <- .workspacesweb$delete_user_settings_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$delete_user_settings <- workspacesweb_delete_user_settings

#' Disassociates browser settings from a web portal
#'
#' @description
#' Disassociates browser settings from a web portal.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_disassociate_browser_settings/](https://www.paws-r-sdk.com/docs/workspacesweb_disassociate_browser_settings/) for full documentation.
#'
#' @param portalArn &#91;required&#93; The ARN of the web portal.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_disassociate_browser_settings
workspacesweb_disassociate_browser_settings <- function(portalArn) {
  op <- new_operation(
    name = "DisassociateBrowserSettings",
    http_method = "DELETE",
    http_path = "/portals/{portalArn+}/browserSettings",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$disassociate_browser_settings_input(portalArn = portalArn)
  output <- .workspacesweb$disassociate_browser_settings_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$disassociate_browser_settings <- workspacesweb_disassociate_browser_settings

#' Disassociates data protection settings from a web portal
#'
#' @description
#' Disassociates data protection settings from a web portal.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_disassociate_data_protection_settings/](https://www.paws-r-sdk.com/docs/workspacesweb_disassociate_data_protection_settings/) for full documentation.
#'
#' @param portalArn &#91;required&#93; The ARN of the web portal.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_disassociate_data_protection_settings
workspacesweb_disassociate_data_protection_settings <- function(portalArn) {
  op <- new_operation(
    name = "DisassociateDataProtectionSettings",
    http_method = "DELETE",
    http_path = "/portals/{portalArn+}/dataProtectionSettings",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$disassociate_data_protection_settings_input(portalArn = portalArn)
  output <- .workspacesweb$disassociate_data_protection_settings_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$disassociate_data_protection_settings <- workspacesweb_disassociate_data_protection_settings

#' Disassociates IP access settings from a web portal
#'
#' @description
#' Disassociates IP access settings from a web portal.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_disassociate_ip_access_settings/](https://www.paws-r-sdk.com/docs/workspacesweb_disassociate_ip_access_settings/) for full documentation.
#'
#' @param portalArn &#91;required&#93; The ARN of the web portal.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_disassociate_ip_access_settings
workspacesweb_disassociate_ip_access_settings <- function(portalArn) {
  op <- new_operation(
    name = "DisassociateIpAccessSettings",
    http_method = "DELETE",
    http_path = "/portals/{portalArn+}/ipAccessSettings",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$disassociate_ip_access_settings_input(portalArn = portalArn)
  output <- .workspacesweb$disassociate_ip_access_settings_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$disassociate_ip_access_settings <- workspacesweb_disassociate_ip_access_settings

#' Disassociates network settings from a web portal
#'
#' @description
#' Disassociates network settings from a web portal.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_disassociate_network_settings/](https://www.paws-r-sdk.com/docs/workspacesweb_disassociate_network_settings/) for full documentation.
#'
#' @param portalArn &#91;required&#93; The ARN of the web portal.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_disassociate_network_settings
workspacesweb_disassociate_network_settings <- function(portalArn) {
  op <- new_operation(
    name = "DisassociateNetworkSettings",
    http_method = "DELETE",
    http_path = "/portals/{portalArn+}/networkSettings",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$disassociate_network_settings_input(portalArn = portalArn)
  output <- .workspacesweb$disassociate_network_settings_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$disassociate_network_settings <- workspacesweb_disassociate_network_settings

#' Disassociates a trust store from a web portal
#'
#' @description
#' Disassociates a trust store from a web portal.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_disassociate_trust_store/](https://www.paws-r-sdk.com/docs/workspacesweb_disassociate_trust_store/) for full documentation.
#'
#' @param portalArn &#91;required&#93; The ARN of the web portal.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_disassociate_trust_store
workspacesweb_disassociate_trust_store <- function(portalArn) {
  op <- new_operation(
    name = "DisassociateTrustStore",
    http_method = "DELETE",
    http_path = "/portals/{portalArn+}/trustStores",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$disassociate_trust_store_input(portalArn = portalArn)
  output <- .workspacesweb$disassociate_trust_store_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$disassociate_trust_store <- workspacesweb_disassociate_trust_store

#' Disassociates user access logging settings from a web portal
#'
#' @description
#' Disassociates user access logging settings from a web portal.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_disassociate_user_access_logging_settings/](https://www.paws-r-sdk.com/docs/workspacesweb_disassociate_user_access_logging_settings/) for full documentation.
#'
#' @param portalArn &#91;required&#93; The ARN of the web portal.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_disassociate_user_access_logging_settings
workspacesweb_disassociate_user_access_logging_settings <- function(portalArn) {
  op <- new_operation(
    name = "DisassociateUserAccessLoggingSettings",
    http_method = "DELETE",
    http_path = "/portals/{portalArn+}/userAccessLoggingSettings",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$disassociate_user_access_logging_settings_input(portalArn = portalArn)
  output <- .workspacesweb$disassociate_user_access_logging_settings_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$disassociate_user_access_logging_settings <- workspacesweb_disassociate_user_access_logging_settings

#' Disassociates user settings from a web portal
#'
#' @description
#' Disassociates user settings from a web portal.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_disassociate_user_settings/](https://www.paws-r-sdk.com/docs/workspacesweb_disassociate_user_settings/) for full documentation.
#'
#' @param portalArn &#91;required&#93; The ARN of the web portal.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_disassociate_user_settings
workspacesweb_disassociate_user_settings <- function(portalArn) {
  op <- new_operation(
    name = "DisassociateUserSettings",
    http_method = "DELETE",
    http_path = "/portals/{portalArn+}/userSettings",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$disassociate_user_settings_input(portalArn = portalArn)
  output <- .workspacesweb$disassociate_user_settings_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$disassociate_user_settings <- workspacesweb_disassociate_user_settings

#' Expires an active secure browser session
#'
#' @description
#' Expires an active secure browser session.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_expire_session/](https://www.paws-r-sdk.com/docs/workspacesweb_expire_session/) for full documentation.
#'
#' @param portalId &#91;required&#93; The ID of the web portal for the session.
#' @param sessionId &#91;required&#93; The ID of the session to expire.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_expire_session
workspacesweb_expire_session <- function(portalId, sessionId) {
  op <- new_operation(
    name = "ExpireSession",
    http_method = "DELETE",
    http_path = "/portals/{portalId}/sessions/{sessionId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$expire_session_input(portalId = portalId, sessionId = sessionId)
  output <- .workspacesweb$expire_session_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$expire_session <- workspacesweb_expire_session

#' Gets browser settings
#'
#' @description
#' Gets browser settings.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_get_browser_settings/](https://www.paws-r-sdk.com/docs/workspacesweb_get_browser_settings/) for full documentation.
#'
#' @param browserSettingsArn &#91;required&#93; The ARN of the browser settings.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_get_browser_settings
workspacesweb_get_browser_settings <- function(browserSettingsArn) {
  op <- new_operation(
    name = "GetBrowserSettings",
    http_method = "GET",
    http_path = "/browserSettings/{browserSettingsArn+}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$get_browser_settings_input(browserSettingsArn = browserSettingsArn)
  output <- .workspacesweb$get_browser_settings_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$get_browser_settings <- workspacesweb_get_browser_settings

#' Gets the data protection settings
#'
#' @description
#' Gets the data protection settings.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_get_data_protection_settings/](https://www.paws-r-sdk.com/docs/workspacesweb_get_data_protection_settings/) for full documentation.
#'
#' @param dataProtectionSettingsArn &#91;required&#93; The ARN of the data protection settings.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_get_data_protection_settings
workspacesweb_get_data_protection_settings <- function(dataProtectionSettingsArn) {
  op <- new_operation(
    name = "GetDataProtectionSettings",
    http_method = "GET",
    http_path = "/dataProtectionSettings/{dataProtectionSettingsArn+}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$get_data_protection_settings_input(dataProtectionSettingsArn = dataProtectionSettingsArn)
  output <- .workspacesweb$get_data_protection_settings_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$get_data_protection_settings <- workspacesweb_get_data_protection_settings

#' Gets the identity provider
#'
#' @description
#' Gets the identity provider.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_get_identity_provider/](https://www.paws-r-sdk.com/docs/workspacesweb_get_identity_provider/) for full documentation.
#'
#' @param identityProviderArn &#91;required&#93; The ARN of the identity provider.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_get_identity_provider
workspacesweb_get_identity_provider <- function(identityProviderArn) {
  op <- new_operation(
    name = "GetIdentityProvider",
    http_method = "GET",
    http_path = "/identityProviders/{identityProviderArn+}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$get_identity_provider_input(identityProviderArn = identityProviderArn)
  output <- .workspacesweb$get_identity_provider_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$get_identity_provider <- workspacesweb_get_identity_provider

#' Gets the IP access settings
#'
#' @description
#' Gets the IP access settings.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_get_ip_access_settings/](https://www.paws-r-sdk.com/docs/workspacesweb_get_ip_access_settings/) for full documentation.
#'
#' @param ipAccessSettingsArn &#91;required&#93; The ARN of the IP access settings.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_get_ip_access_settings
workspacesweb_get_ip_access_settings <- function(ipAccessSettingsArn) {
  op <- new_operation(
    name = "GetIpAccessSettings",
    http_method = "GET",
    http_path = "/ipAccessSettings/{ipAccessSettingsArn+}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$get_ip_access_settings_input(ipAccessSettingsArn = ipAccessSettingsArn)
  output <- .workspacesweb$get_ip_access_settings_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$get_ip_access_settings <- workspacesweb_get_ip_access_settings

#' Gets the network settings
#'
#' @description
#' Gets the network settings.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_get_network_settings/](https://www.paws-r-sdk.com/docs/workspacesweb_get_network_settings/) for full documentation.
#'
#' @param networkSettingsArn &#91;required&#93; The ARN of the network settings.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_get_network_settings
workspacesweb_get_network_settings <- function(networkSettingsArn) {
  op <- new_operation(
    name = "GetNetworkSettings",
    http_method = "GET",
    http_path = "/networkSettings/{networkSettingsArn+}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$get_network_settings_input(networkSettingsArn = networkSettingsArn)
  output <- .workspacesweb$get_network_settings_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$get_network_settings <- workspacesweb_get_network_settings

#' Gets the web portal
#'
#' @description
#' Gets the web portal.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_get_portal/](https://www.paws-r-sdk.com/docs/workspacesweb_get_portal/) for full documentation.
#'
#' @param portalArn &#91;required&#93; The ARN of the web portal.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_get_portal
workspacesweb_get_portal <- function(portalArn) {
  op <- new_operation(
    name = "GetPortal",
    http_method = "GET",
    http_path = "/portals/{portalArn+}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$get_portal_input(portalArn = portalArn)
  output <- .workspacesweb$get_portal_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$get_portal <- workspacesweb_get_portal

#' Gets the service provider metadata
#'
#' @description
#' Gets the service provider metadata.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_get_portal_service_provider_metadata/](https://www.paws-r-sdk.com/docs/workspacesweb_get_portal_service_provider_metadata/) for full documentation.
#'
#' @param portalArn &#91;required&#93; The ARN of the web portal.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_get_portal_service_provider_metadata
workspacesweb_get_portal_service_provider_metadata <- function(portalArn) {
  op <- new_operation(
    name = "GetPortalServiceProviderMetadata",
    http_method = "GET",
    http_path = "/portalIdp/{portalArn+}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$get_portal_service_provider_metadata_input(portalArn = portalArn)
  output <- .workspacesweb$get_portal_service_provider_metadata_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$get_portal_service_provider_metadata <- workspacesweb_get_portal_service_provider_metadata

#' Gets information for a secure browser session
#'
#' @description
#' Gets information for a secure browser session.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_get_session/](https://www.paws-r-sdk.com/docs/workspacesweb_get_session/) for full documentation.
#'
#' @param portalId &#91;required&#93; The ID of the web portal for the session.
#' @param sessionId &#91;required&#93; The ID of the session.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_get_session
workspacesweb_get_session <- function(portalId, sessionId) {
  op <- new_operation(
    name = "GetSession",
    http_method = "GET",
    http_path = "/portals/{portalId}/sessions/{sessionId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$get_session_input(portalId = portalId, sessionId = sessionId)
  output <- .workspacesweb$get_session_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$get_session <- workspacesweb_get_session

#' Gets the trust store
#'
#' @description
#' Gets the trust store.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_get_trust_store/](https://www.paws-r-sdk.com/docs/workspacesweb_get_trust_store/) for full documentation.
#'
#' @param trustStoreArn &#91;required&#93; The ARN of the trust store.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_get_trust_store
workspacesweb_get_trust_store <- function(trustStoreArn) {
  op <- new_operation(
    name = "GetTrustStore",
    http_method = "GET",
    http_path = "/trustStores/{trustStoreArn+}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$get_trust_store_input(trustStoreArn = trustStoreArn)
  output <- .workspacesweb$get_trust_store_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$get_trust_store <- workspacesweb_get_trust_store

#' Gets the trust store certificate
#'
#' @description
#' Gets the trust store certificate.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_get_trust_store_certificate/](https://www.paws-r-sdk.com/docs/workspacesweb_get_trust_store_certificate/) for full documentation.
#'
#' @param thumbprint &#91;required&#93; The thumbprint of the trust store certificate.
#' @param trustStoreArn &#91;required&#93; The ARN of the trust store certificate.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_get_trust_store_certificate
workspacesweb_get_trust_store_certificate <- function(thumbprint, trustStoreArn) {
  op <- new_operation(
    name = "GetTrustStoreCertificate",
    http_method = "GET",
    http_path = "/trustStores/{trustStoreArn+}/certificate",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$get_trust_store_certificate_input(thumbprint = thumbprint, trustStoreArn = trustStoreArn)
  output <- .workspacesweb$get_trust_store_certificate_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$get_trust_store_certificate <- workspacesweb_get_trust_store_certificate

#' Gets user access logging settings
#'
#' @description
#' Gets user access logging settings.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_get_user_access_logging_settings/](https://www.paws-r-sdk.com/docs/workspacesweb_get_user_access_logging_settings/) for full documentation.
#'
#' @param userAccessLoggingSettingsArn &#91;required&#93; The ARN of the user access logging settings.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_get_user_access_logging_settings
workspacesweb_get_user_access_logging_settings <- function(userAccessLoggingSettingsArn) {
  op <- new_operation(
    name = "GetUserAccessLoggingSettings",
    http_method = "GET",
    http_path = "/userAccessLoggingSettings/{userAccessLoggingSettingsArn+}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$get_user_access_logging_settings_input(userAccessLoggingSettingsArn = userAccessLoggingSettingsArn)
  output <- .workspacesweb$get_user_access_logging_settings_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$get_user_access_logging_settings <- workspacesweb_get_user_access_logging_settings

#' Gets user settings
#'
#' @description
#' Gets user settings.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_get_user_settings/](https://www.paws-r-sdk.com/docs/workspacesweb_get_user_settings/) for full documentation.
#'
#' @param userSettingsArn &#91;required&#93; The ARN of the user settings.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_get_user_settings
workspacesweb_get_user_settings <- function(userSettingsArn) {
  op <- new_operation(
    name = "GetUserSettings",
    http_method = "GET",
    http_path = "/userSettings/{userSettingsArn+}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$get_user_settings_input(userSettingsArn = userSettingsArn)
  output <- .workspacesweb$get_user_settings_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$get_user_settings <- workspacesweb_get_user_settings

#' Retrieves a list of browser settings
#'
#' @description
#' Retrieves a list of browser settings.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_list_browser_settings/](https://www.paws-r-sdk.com/docs/workspacesweb_list_browser_settings/) for full documentation.
#'
#' @param maxResults The maximum number of results to be included in the next page.
#' @param nextToken The pagination token used to retrieve the next page of results for this
#' operation.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_list_browser_settings
workspacesweb_list_browser_settings <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListBrowserSettings",
    http_method = "GET",
    http_path = "/browserSettings",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults"),
    stream_api = FALSE
  )
  input <- .workspacesweb$list_browser_settings_input(maxResults = maxResults, nextToken = nextToken)
  output <- .workspacesweb$list_browser_settings_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$list_browser_settings <- workspacesweb_list_browser_settings

#' Retrieves a list of data protection settings
#'
#' @description
#' Retrieves a list of data protection settings.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_list_data_protection_settings/](https://www.paws-r-sdk.com/docs/workspacesweb_list_data_protection_settings/) for full documentation.
#'
#' @param maxResults The maximum number of results to be included in the next page.
#' @param nextToken The pagination token used to retrieve the next page of results for this
#' operation.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_list_data_protection_settings
workspacesweb_list_data_protection_settings <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListDataProtectionSettings",
    http_method = "GET",
    http_path = "/dataProtectionSettings",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "dataProtectionSettings"),
    stream_api = FALSE
  )
  input <- .workspacesweb$list_data_protection_settings_input(maxResults = maxResults, nextToken = nextToken)
  output <- .workspacesweb$list_data_protection_settings_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$list_data_protection_settings <- workspacesweb_list_data_protection_settings

#' Retrieves a list of identity providers for a specific web portal
#'
#' @description
#' Retrieves a list of identity providers for a specific web portal.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_list_identity_providers/](https://www.paws-r-sdk.com/docs/workspacesweb_list_identity_providers/) for full documentation.
#'
#' @param maxResults The maximum number of results to be included in the next page.
#' @param nextToken The pagination token used to retrieve the next page of results for this
#' operation.
#' @param portalArn &#91;required&#93; The ARN of the web portal.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_list_identity_providers
workspacesweb_list_identity_providers <- function(maxResults = NULL, nextToken = NULL, portalArn) {
  op <- new_operation(
    name = "ListIdentityProviders",
    http_method = "GET",
    http_path = "/portals/{portalArn+}/identityProviders",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults"),
    stream_api = FALSE
  )
  input <- .workspacesweb$list_identity_providers_input(maxResults = maxResults, nextToken = nextToken, portalArn = portalArn)
  output <- .workspacesweb$list_identity_providers_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$list_identity_providers <- workspacesweb_list_identity_providers

#' Retrieves a list of IP access settings
#'
#' @description
#' Retrieves a list of IP access settings.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_list_ip_access_settings/](https://www.paws-r-sdk.com/docs/workspacesweb_list_ip_access_settings/) for full documentation.
#'
#' @param maxResults The maximum number of results to be included in the next page.
#' @param nextToken The pagination token used to retrieve the next page of results for this
#' operation.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_list_ip_access_settings
workspacesweb_list_ip_access_settings <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListIpAccessSettings",
    http_method = "GET",
    http_path = "/ipAccessSettings",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults"),
    stream_api = FALSE
  )
  input <- .workspacesweb$list_ip_access_settings_input(maxResults = maxResults, nextToken = nextToken)
  output <- .workspacesweb$list_ip_access_settings_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$list_ip_access_settings <- workspacesweb_list_ip_access_settings

#' Retrieves a list of network settings
#'
#' @description
#' Retrieves a list of network settings.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_list_network_settings/](https://www.paws-r-sdk.com/docs/workspacesweb_list_network_settings/) for full documentation.
#'
#' @param maxResults The maximum number of results to be included in the next page.
#' @param nextToken The pagination token used to retrieve the next page of results for this
#' operation.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_list_network_settings
workspacesweb_list_network_settings <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListNetworkSettings",
    http_method = "GET",
    http_path = "/networkSettings",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults"),
    stream_api = FALSE
  )
  input <- .workspacesweb$list_network_settings_input(maxResults = maxResults, nextToken = nextToken)
  output <- .workspacesweb$list_network_settings_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$list_network_settings <- workspacesweb_list_network_settings

#' Retrieves a list or web portals
#'
#' @description
#' Retrieves a list or web portals.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_list_portals/](https://www.paws-r-sdk.com/docs/workspacesweb_list_portals/) for full documentation.
#'
#' @param maxResults The maximum number of results to be included in the next page.
#' @param nextToken The pagination token used to retrieve the next page of results for this
#' operation.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_list_portals
workspacesweb_list_portals <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListPortals",
    http_method = "GET",
    http_path = "/portals",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults"),
    stream_api = FALSE
  )
  input <- .workspacesweb$list_portals_input(maxResults = maxResults, nextToken = nextToken)
  output <- .workspacesweb$list_portals_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$list_portals <- workspacesweb_list_portals

#' Lists information for multiple secure browser sessions from a specific
#' portal
#'
#' @description
#' Lists information for multiple secure browser sessions from a specific portal.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_list_sessions/](https://www.paws-r-sdk.com/docs/workspacesweb_list_sessions/) for full documentation.
#'
#' @param maxResults The maximum number of results to be included in the next page.
#' @param nextToken The pagination token used to retrieve the next page of results for this
#' operation.
#' @param portalId &#91;required&#93; The ID of the web portal for the sessions.
#' @param sessionId The ID of the session.
#' @param sortBy The method in which the returned sessions should be sorted.
#' @param status The status of the session.
#' @param username The username of the session.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_list_sessions
workspacesweb_list_sessions <- function(maxResults = NULL, nextToken = NULL, portalId, sessionId = NULL, sortBy = NULL, status = NULL, username = NULL) {
  op <- new_operation(
    name = "ListSessions",
    http_method = "GET",
    http_path = "/portals/{portalId}/sessions",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "sessions"),
    stream_api = FALSE
  )
  input <- .workspacesweb$list_sessions_input(maxResults = maxResults, nextToken = nextToken, portalId = portalId, sessionId = sessionId, sortBy = sortBy, status = status, username = username)
  output <- .workspacesweb$list_sessions_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$list_sessions <- workspacesweb_list_sessions

#' Retrieves a list of tags for a resource
#'
#' @description
#' Retrieves a list of tags for a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/workspacesweb_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_list_tags_for_resource
workspacesweb_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn+}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .workspacesweb$list_tags_for_resource_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$list_tags_for_resource <- workspacesweb_list_tags_for_resource

#' Retrieves a list of trust store certificates
#'
#' @description
#' Retrieves a list of trust store certificates.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_list_trust_store_certificates/](https://www.paws-r-sdk.com/docs/workspacesweb_list_trust_store_certificates/) for full documentation.
#'
#' @param maxResults The maximum number of results to be included in the next page.
#' @param nextToken The pagination token used to retrieve the next page of results for this
#' operation.
#' @param trustStoreArn &#91;required&#93; The ARN of the trust store
#'
#' @keywords internal
#'
#' @rdname workspacesweb_list_trust_store_certificates
workspacesweb_list_trust_store_certificates <- function(maxResults = NULL, nextToken = NULL, trustStoreArn) {
  op <- new_operation(
    name = "ListTrustStoreCertificates",
    http_method = "GET",
    http_path = "/trustStores/{trustStoreArn+}/certificates",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults"),
    stream_api = FALSE
  )
  input <- .workspacesweb$list_trust_store_certificates_input(maxResults = maxResults, nextToken = nextToken, trustStoreArn = trustStoreArn)
  output <- .workspacesweb$list_trust_store_certificates_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$list_trust_store_certificates <- workspacesweb_list_trust_store_certificates

#' Retrieves a list of trust stores
#'
#' @description
#' Retrieves a list of trust stores.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_list_trust_stores/](https://www.paws-r-sdk.com/docs/workspacesweb_list_trust_stores/) for full documentation.
#'
#' @param maxResults The maximum number of results to be included in the next page.
#' @param nextToken The pagination token used to retrieve the next page of results for this
#' operation.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_list_trust_stores
workspacesweb_list_trust_stores <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListTrustStores",
    http_method = "GET",
    http_path = "/trustStores",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults"),
    stream_api = FALSE
  )
  input <- .workspacesweb$list_trust_stores_input(maxResults = maxResults, nextToken = nextToken)
  output <- .workspacesweb$list_trust_stores_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$list_trust_stores <- workspacesweb_list_trust_stores

#' Retrieves a list of user access logging settings
#'
#' @description
#' Retrieves a list of user access logging settings.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_list_user_access_logging_settings/](https://www.paws-r-sdk.com/docs/workspacesweb_list_user_access_logging_settings/) for full documentation.
#'
#' @param maxResults The maximum number of results to be included in the next page.
#' @param nextToken The pagination token used to retrieve the next page of results for this
#' operation.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_list_user_access_logging_settings
workspacesweb_list_user_access_logging_settings <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListUserAccessLoggingSettings",
    http_method = "GET",
    http_path = "/userAccessLoggingSettings",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults"),
    stream_api = FALSE
  )
  input <- .workspacesweb$list_user_access_logging_settings_input(maxResults = maxResults, nextToken = nextToken)
  output <- .workspacesweb$list_user_access_logging_settings_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$list_user_access_logging_settings <- workspacesweb_list_user_access_logging_settings

#' Retrieves a list of user settings
#'
#' @description
#' Retrieves a list of user settings.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_list_user_settings/](https://www.paws-r-sdk.com/docs/workspacesweb_list_user_settings/) for full documentation.
#'
#' @param maxResults The maximum number of results to be included in the next page.
#' @param nextToken The pagination token used to retrieve the next page of results for this
#' operation.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_list_user_settings
workspacesweb_list_user_settings <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListUserSettings",
    http_method = "GET",
    http_path = "/userSettings",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults"),
    stream_api = FALSE
  )
  input <- .workspacesweb$list_user_settings_input(maxResults = maxResults, nextToken = nextToken)
  output <- .workspacesweb$list_user_settings_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$list_user_settings <- workspacesweb_list_user_settings

#' Adds or overwrites one or more tags for the specified resource
#'
#' @description
#' Adds or overwrites one or more tags for the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_tag_resource/](https://www.paws-r-sdk.com/docs/workspacesweb_tag_resource/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Idempotency ensures that an API request
#' completes only once. With an idempotent request, if the original request
#' completes successfully, subsequent retries with the same client token
#' returns the result from the original successful request.
#' 
#' If you do not specify a client token, one is automatically generated by
#' the Amazon Web Services SDK.
#' @param resourceArn &#91;required&#93; The ARN of the resource.
#' @param tags &#91;required&#93; The tags of the resource.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_tag_resource
workspacesweb_tag_resource <- function(clientToken = NULL, resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn+}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$tag_resource_input(clientToken = clientToken, resourceArn = resourceArn, tags = tags)
  output <- .workspacesweb$tag_resource_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$tag_resource <- workspacesweb_tag_resource

#' Removes one or more tags from the specified resource
#'
#' @description
#' Removes one or more tags from the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_untag_resource/](https://www.paws-r-sdk.com/docs/workspacesweb_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource.
#' @param tagKeys &#91;required&#93; The list of tag keys to remove from the resource.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_untag_resource
workspacesweb_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn+}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .workspacesweb$untag_resource_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$untag_resource <- workspacesweb_untag_resource

#' Updates browser settings
#'
#' @description
#' Updates browser settings.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_update_browser_settings/](https://www.paws-r-sdk.com/docs/workspacesweb_update_browser_settings/) for full documentation.
#'
#' @param browserPolicy A JSON string containing Chrome Enterprise policies that will be applied
#' to all streaming sessions.
#' @param browserSettingsArn &#91;required&#93; The ARN of the browser settings.
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Idempotency ensures that an API request
#' completes only once. With an idempotent request, if the original request
#' completes successfully, subsequent retries with the same client token
#' return the result from the original successful request.
#' 
#' If you do not specify a client token, one is automatically generated by
#' the Amazon Web Services SDK.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_update_browser_settings
workspacesweb_update_browser_settings <- function(browserPolicy = NULL, browserSettingsArn, clientToken = NULL) {
  op <- new_operation(
    name = "UpdateBrowserSettings",
    http_method = "PATCH",
    http_path = "/browserSettings/{browserSettingsArn+}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$update_browser_settings_input(browserPolicy = browserPolicy, browserSettingsArn = browserSettingsArn, clientToken = clientToken)
  output <- .workspacesweb$update_browser_settings_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$update_browser_settings <- workspacesweb_update_browser_settings

#' Updates data protection settings
#'
#' @description
#' Updates data protection settings.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_update_data_protection_settings/](https://www.paws-r-sdk.com/docs/workspacesweb_update_data_protection_settings/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Idempotency ensures that an API request
#' completes only once. With an idempotent request, if the original request
#' completes successfully, subsequent retries with the same client token
#' return the result from the original successful request.
#' 
#' If you do not specify a client token, one is automatically generated by
#' the Amazon Web Services SDK.
#' @param dataProtectionSettingsArn &#91;required&#93; The ARN of the data protection settings.
#' @param description The description of the data protection settings.
#' @param displayName The display name of the data protection settings.
#' @param inlineRedactionConfiguration The inline redaction configuration of the data protection settings that
#' will be applied to all sessions.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_update_data_protection_settings
workspacesweb_update_data_protection_settings <- function(clientToken = NULL, dataProtectionSettingsArn, description = NULL, displayName = NULL, inlineRedactionConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateDataProtectionSettings",
    http_method = "PATCH",
    http_path = "/dataProtectionSettings/{dataProtectionSettingsArn+}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$update_data_protection_settings_input(clientToken = clientToken, dataProtectionSettingsArn = dataProtectionSettingsArn, description = description, displayName = displayName, inlineRedactionConfiguration = inlineRedactionConfiguration)
  output <- .workspacesweb$update_data_protection_settings_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$update_data_protection_settings <- workspacesweb_update_data_protection_settings

#' Updates the identity provider
#'
#' @description
#' Updates the identity provider.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_update_identity_provider/](https://www.paws-r-sdk.com/docs/workspacesweb_update_identity_provider/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Idempotency ensures that an API request
#' completes only once. With an idempotent request, if the original request
#' completes successfully, subsequent retries with the same client token
#' return the result from the original successful request.
#' 
#' If you do not specify a client token, one is automatically generated by
#' the Amazon Web Services SDK.
#' @param identityProviderArn &#91;required&#93; The ARN of the identity provider.
#' @param identityProviderDetails The details of the identity provider. The following list describes the
#' provider detail keys for each identity provider type.
#' 
#' -   For Google and Login with Amazon:
#' 
#'     -   `client_id`
#' 
#'     -   `client_secret`
#' 
#'     -   `authorize_scopes`
#' 
#' -   For Facebook:
#' 
#'     -   `client_id`
#' 
#'     -   `client_secret`
#' 
#'     -   `authorize_scopes`
#' 
#'     -   `api_version`
#' 
#' -   For Sign in with Apple:
#' 
#'     -   `client_id`
#' 
#'     -   `team_id`
#' 
#'     -   `key_id`
#' 
#'     -   `private_key`
#' 
#'     -   `authorize_scopes`
#' 
#' -   For OIDC providers:
#' 
#'     -   `client_id`
#' 
#'     -   `client_secret`
#' 
#'     -   `attributes_request_method`
#' 
#'     -   `oidc_issuer`
#' 
#'     -   `authorize_scopes`
#' 
#'     -   `authorize_url` *if not available from discovery URL specified
#'         by oidc_issuer key*
#' 
#'     -   `token_url` *if not available from discovery URL specified by
#'         oidc_issuer key*
#' 
#'     -   `attributes_url` *if not available from discovery URL specified
#'         by oidc_issuer key*
#' 
#'     -   `jwks_uri` *if not available from discovery URL specified by
#'         oidc_issuer key*
#' 
#' -   For SAML providers:
#' 
#'     -   `MetadataFile` OR `MetadataURL`
#' 
#'     -   `IDPSignout` (boolean) *optional*
#' 
#'     -   `IDPInit` (boolean) *optional*
#' 
#'     -   `RequestSigningAlgorithm` (string) *optional* - Only accepts
#'         `rsa-sha256`
#' 
#'     -   `EncryptedResponses` (boolean) *optional*
#' @param identityProviderName The name of the identity provider.
#' @param identityProviderType The type of the identity provider.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_update_identity_provider
workspacesweb_update_identity_provider <- function(clientToken = NULL, identityProviderArn, identityProviderDetails = NULL, identityProviderName = NULL, identityProviderType = NULL) {
  op <- new_operation(
    name = "UpdateIdentityProvider",
    http_method = "PATCH",
    http_path = "/identityProviders/{identityProviderArn+}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$update_identity_provider_input(clientToken = clientToken, identityProviderArn = identityProviderArn, identityProviderDetails = identityProviderDetails, identityProviderName = identityProviderName, identityProviderType = identityProviderType)
  output <- .workspacesweb$update_identity_provider_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$update_identity_provider <- workspacesweb_update_identity_provider

#' Updates IP access settings
#'
#' @description
#' Updates IP access settings.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_update_ip_access_settings/](https://www.paws-r-sdk.com/docs/workspacesweb_update_ip_access_settings/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Idempotency ensures that an API request
#' completes only once. With an idempotent request, if the original request
#' completes successfully, subsequent retries with the same client token
#' return the result from the original successful request.
#' 
#' If you do not specify a client token, one is automatically generated by
#' the Amazon Web Services SDK.
#' @param description The description of the IP access settings.
#' @param displayName The display name of the IP access settings.
#' @param ipAccessSettingsArn &#91;required&#93; The ARN of the IP access settings.
#' @param ipRules The updated IP rules of the IP access settings.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_update_ip_access_settings
workspacesweb_update_ip_access_settings <- function(clientToken = NULL, description = NULL, displayName = NULL, ipAccessSettingsArn, ipRules = NULL) {
  op <- new_operation(
    name = "UpdateIpAccessSettings",
    http_method = "PATCH",
    http_path = "/ipAccessSettings/{ipAccessSettingsArn+}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$update_ip_access_settings_input(clientToken = clientToken, description = description, displayName = displayName, ipAccessSettingsArn = ipAccessSettingsArn, ipRules = ipRules)
  output <- .workspacesweb$update_ip_access_settings_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$update_ip_access_settings <- workspacesweb_update_ip_access_settings

#' Updates network settings
#'
#' @description
#' Updates network settings.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_update_network_settings/](https://www.paws-r-sdk.com/docs/workspacesweb_update_network_settings/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Idempotency ensures that an API request
#' completes only once. With an idempotent request, if the original request
#' completes successfully, subsequent retries with the same client token
#' return the result from the original successful request.
#' 
#' If you do not specify a client token, one is automatically generated by
#' the Amazon Web Services SDK.
#' @param networkSettingsArn &#91;required&#93; The ARN of the network settings.
#' @param securityGroupIds One or more security groups used to control access from streaming
#' instances to your VPC.
#' @param subnetIds The subnets in which network interfaces are created to connect streaming
#' instances to your VPC. At least two of these subnets must be in
#' different availability zones.
#' @param vpcId The VPC that streaming instances will connect to.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_update_network_settings
workspacesweb_update_network_settings <- function(clientToken = NULL, networkSettingsArn, securityGroupIds = NULL, subnetIds = NULL, vpcId = NULL) {
  op <- new_operation(
    name = "UpdateNetworkSettings",
    http_method = "PATCH",
    http_path = "/networkSettings/{networkSettingsArn+}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$update_network_settings_input(clientToken = clientToken, networkSettingsArn = networkSettingsArn, securityGroupIds = securityGroupIds, subnetIds = subnetIds, vpcId = vpcId)
  output <- .workspacesweb$update_network_settings_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$update_network_settings <- workspacesweb_update_network_settings

#' Updates a web portal
#'
#' @description
#' Updates a web portal.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_update_portal/](https://www.paws-r-sdk.com/docs/workspacesweb_update_portal/) for full documentation.
#'
#' @param authenticationType The type of authentication integration points used when signing into the
#' web portal. Defaults to `Standard`.
#' 
#' `Standard` web portals are authenticated directly through your identity
#' provider. You need to call
#' [`create_identity_provider`][workspacesweb_create_identity_provider] to
#' integrate your identity provider with your web portal. User and group
#' access to your web portal is controlled through your identity provider.
#' 
#' `IAM Identity Center` web portals are authenticated through IAM Identity
#' Center. Identity sources (including external identity provider
#' integration), plus user and group access to your web portal, can be
#' configured in the IAM Identity Center.
#' @param displayName The name of the web portal. This is not visible to users who log into
#' the web portal.
#' @param instanceType The type and resources of the underlying instance.
#' @param maxConcurrentSessions The maximum number of concurrent sessions for the portal.
#' @param portalArn &#91;required&#93; The ARN of the web portal.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_update_portal
workspacesweb_update_portal <- function(authenticationType = NULL, displayName = NULL, instanceType = NULL, maxConcurrentSessions = NULL, portalArn) {
  op <- new_operation(
    name = "UpdatePortal",
    http_method = "PUT",
    http_path = "/portals/{portalArn+}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$update_portal_input(authenticationType = authenticationType, displayName = displayName, instanceType = instanceType, maxConcurrentSessions = maxConcurrentSessions, portalArn = portalArn)
  output <- .workspacesweb$update_portal_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$update_portal <- workspacesweb_update_portal

#' Updates the trust store
#'
#' @description
#' Updates the trust store.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_update_trust_store/](https://www.paws-r-sdk.com/docs/workspacesweb_update_trust_store/) for full documentation.
#'
#' @param certificatesToAdd A list of CA certificates to add to the trust store.
#' @param certificatesToDelete A list of CA certificates to delete from a trust store.
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Idempotency ensures that an API request
#' completes only once. With an idempotent request, if the original request
#' completes successfully, subsequent retries with the same client token
#' return the result from the original successful request.
#' 
#' If you do not specify a client token, one is automatically generated by
#' the Amazon Web Services SDK.
#' @param trustStoreArn &#91;required&#93; The ARN of the trust store.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_update_trust_store
workspacesweb_update_trust_store <- function(certificatesToAdd = NULL, certificatesToDelete = NULL, clientToken = NULL, trustStoreArn) {
  op <- new_operation(
    name = "UpdateTrustStore",
    http_method = "PATCH",
    http_path = "/trustStores/{trustStoreArn+}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$update_trust_store_input(certificatesToAdd = certificatesToAdd, certificatesToDelete = certificatesToDelete, clientToken = clientToken, trustStoreArn = trustStoreArn)
  output <- .workspacesweb$update_trust_store_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$update_trust_store <- workspacesweb_update_trust_store

#' Updates the user access logging settings
#'
#' @description
#' Updates the user access logging settings.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_update_user_access_logging_settings/](https://www.paws-r-sdk.com/docs/workspacesweb_update_user_access_logging_settings/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Idempotency ensures that an API request
#' completes only once. With an idempotent request, if the original request
#' completes successfully, subsequent retries with the same client token
#' return the result from the original successful request.
#' 
#' If you do not specify a client token, one is automatically generated by
#' the Amazon Web Services SDK.
#' @param kinesisStreamArn The ARN of the Kinesis stream.
#' @param userAccessLoggingSettingsArn &#91;required&#93; The ARN of the user access logging settings.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_update_user_access_logging_settings
workspacesweb_update_user_access_logging_settings <- function(clientToken = NULL, kinesisStreamArn = NULL, userAccessLoggingSettingsArn) {
  op <- new_operation(
    name = "UpdateUserAccessLoggingSettings",
    http_method = "PATCH",
    http_path = "/userAccessLoggingSettings/{userAccessLoggingSettingsArn+}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$update_user_access_logging_settings_input(clientToken = clientToken, kinesisStreamArn = kinesisStreamArn, userAccessLoggingSettingsArn = userAccessLoggingSettingsArn)
  output <- .workspacesweb$update_user_access_logging_settings_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$update_user_access_logging_settings <- workspacesweb_update_user_access_logging_settings

#' Updates the user settings
#'
#' @description
#' Updates the user settings.
#'
#' See [https://www.paws-r-sdk.com/docs/workspacesweb_update_user_settings/](https://www.paws-r-sdk.com/docs/workspacesweb_update_user_settings/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Idempotency ensures that an API request
#' completes only once. With an idempotent request, if the original request
#' completes successfully, subsequent retries with the same client token
#' return the result from the original successful request.
#' 
#' If you do not specify a client token, one is automatically generated by
#' the Amazon Web Services SDK.
#' @param cookieSynchronizationConfiguration The configuration that specifies which cookies should be synchronized
#' from the end user's local browser to the remote browser.
#' 
#' If the allowlist and blocklist are empty, the configuration becomes
#' null.
#' @param copyAllowed Specifies whether the user can copy text from the streaming session to
#' the local device.
#' @param deepLinkAllowed Specifies whether the user can use deep links that open automatically
#' when connecting to a session.
#' @param disconnectTimeoutInMinutes The amount of time that a streaming session remains active after users
#' disconnect.
#' @param downloadAllowed Specifies whether the user can download files from the streaming session
#' to the local device.
#' @param idleDisconnectTimeoutInMinutes The amount of time that users can be idle (inactive) before they are
#' disconnected from their streaming session and the disconnect timeout
#' interval begins.
#' @param pasteAllowed Specifies whether the user can paste text from the local device to the
#' streaming session.
#' @param printAllowed Specifies whether the user can print to the local device.
#' @param uploadAllowed Specifies whether the user can upload files from the local device to the
#' streaming session.
#' @param userSettingsArn &#91;required&#93; The ARN of the user settings.
#'
#' @keywords internal
#'
#' @rdname workspacesweb_update_user_settings
workspacesweb_update_user_settings <- function(clientToken = NULL, cookieSynchronizationConfiguration = NULL, copyAllowed = NULL, deepLinkAllowed = NULL, disconnectTimeoutInMinutes = NULL, downloadAllowed = NULL, idleDisconnectTimeoutInMinutes = NULL, pasteAllowed = NULL, printAllowed = NULL, uploadAllowed = NULL, userSettingsArn) {
  op <- new_operation(
    name = "UpdateUserSettings",
    http_method = "PATCH",
    http_path = "/userSettings/{userSettingsArn+}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .workspacesweb$update_user_settings_input(clientToken = clientToken, cookieSynchronizationConfiguration = cookieSynchronizationConfiguration, copyAllowed = copyAllowed, deepLinkAllowed = deepLinkAllowed, disconnectTimeoutInMinutes = disconnectTimeoutInMinutes, downloadAllowed = downloadAllowed, idleDisconnectTimeoutInMinutes = idleDisconnectTimeoutInMinutes, pasteAllowed = pasteAllowed, printAllowed = printAllowed, uploadAllowed = uploadAllowed, userSettingsArn = userSettingsArn)
  output <- .workspacesweb$update_user_settings_output()
  config <- get_config()
  svc <- .workspacesweb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspacesweb$operations$update_user_settings <- workspacesweb_update_user_settings
